﻿$(document).ready(() => {
    let selectedExip = [];  // An array for ID of extensions or IP addresses of selected rows
    let selectedDNs = [];   // An array for DNs of selected rows

    function RemoveFromArray(array, element) {
        //remove element form array
        const index = array.indexOf(element);

        if (index !== -1) {
            array.splice(index, 1);
        }
    }

    //Getting the current date in string format
    function currentdate() {
        var c_datetime = new Date();
        var day;
        var month;
        if (c_datetime.getDate() <= 9) { day = "0" + c_datetime.getDate().toString(); }
        else { day = c_datetime.getDate().toString(); }
        if (c_datetime.getMonth() + 1 <= 9) { month = "0" + (c_datetime.getMonth() +1).toString(); }
        else { month = c_datetime.getMonth().toString(); }
        var year = c_datetime.getFullYear().toString();
        return year + "-" + month + "-" + day;
    }

    function UpdateFreeData() {
        $('#freeAB').text('~');
        $('#countAB').text('~');

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetFreeSpaceData',
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#freeAB').text(response.free);
                    $('#countAB').text(response.used);
                }
            }
        });
    }

    function initdatetimepickers() {
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),
            locale: $('#LocaleThread').val(),
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true,
            format: 'L'
        };

        $('#datetimepickerFromDN').datetimepicker(options);
        $('#datetimepickerToDN').datetimepicker(options);
    }

    function UpdateExipButtonUI() {
        if (selectedExip.length === 0) {
            $('#btnEditexip').prop('disabled', true);
            $('#btnDeleteexip').prop('disabled', true);
            $('#btnSetMainexip').prop('disabled', true);
            $('#btnSetRatePlane').prop('disabled', true);
            $('#btnSetAddress').prop('disabled', true);
            $('#btnDNtransfer').prop('disabled', true);
        }
        else if (selectedExip.length === 1) {
            $('#btnEditexip').prop('disabled', false);
            $('#btnDeleteexip').prop('disabled', false);
            $('#btnSetMainexip').prop('disabled', false);
            $('#btnSetRatePlane').prop('disabled', false);
            $('#btnSetAddress').prop('disabled', false);
            $('#btnDNtransfer').prop('disabled', false);
        }
        else {
            $('#btnEditexip').prop('disabled', true);
            $('#btnSetMainexip').prop('disabled', true);
            $('#btnSetRatePlane').prop('disabled', true);
            $('#btnSetAddress').prop('disabled', true);
            $('#btnDNtransfer').prop('disabled', false);
            $('#btnDeleteexip').prop('disabled', false);
        }
    }

    function AttachEventsToExip() {
        var header = document.getElementById("ExtensionsHead");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        selectedExip = [];
        selectedDNs = [];

        //select rows
        $('#tariscope-abonent-exip tbody').on('click', 'tr', function (e) {
            if (e.shiftKey) {//select via shift
                var newIndex = $(this).index();

                var table = $('#tariscope-abonent-exip');

                //init first row
                if (rowIndex === null)
                    rowIndex = $(this).index();

                tempIndex = rowIndex;

                //clear prev selected
                selectedExip = [];
                selectedDNs = [];

                $('#tariscope-abonent-exip tr.selected').removeClass('selected');

                var direction = newIndex >= rowIndex;

                if (direction) {//select down
                    while (tempIndex <= newIndex) {
                        tempIndex += 1;

                        var tr = $('tr:eq(' + tempIndex + ')', table);

                        if (tr.css('display') !== 'none') {
                            tr.addClass('selected');
                            RemoveFromArray(selectedExip, tr.find('td[data-name="ID"]').text());
                            selectedExip.push(tr.find('td[data-name="ID"]').text());
                            RemoveFromArray(selectedDNs, tr.find('td[data-name="DN"]').text());
                            selectedDNs.push(tr.find('td[data-name="DN"]').text());
                        }
                    }
                }
                else {//select up
                    while (tempIndex > (newIndex - 1)) {
                        var tr2 = $('tr:eq(' + (tempIndex + 1) + ')', table);

                        if (tr2.css('display') !== 'none') {
                            tr2.addClass('selected');
                            RemoveFromArray(selectedExip, tr2.find('td[data-name="ID"]').text());
                            selectedExip.push(tr2.find('td[data-name="ID"]').text());
                            RemoveFromArray(selectedDNs, tr2.find('td[data-name="DN"]').text());
                            selectedDNs.push(tr2.find('td[data-name="DN"]').text());

                        }

                        tempIndex -= 1;
                    }
                }
            }
            else {
                if (e.ctrlKey) {//selection with Control key
                    selectedExip.push($(this).find('td[data-name="ID"]').text());
                    selectedDNs.push($(this).find('td[data-name="DN"]').text());
                    $(this).addClass('selected');
                }
                else {//single select
                    rowIndex = $(this).index();

                    selectedExip = [];
                    selectedDNs = [];

                    if ($(this).hasClass('selected')) {
                        $('#tariscope-abonent-exip tr.selected').removeClass('selected');
                    }
                    else {
                        $('#tariscope-abonent-exip tr.selected').removeClass('selected');
                        selectedExip.push($(this).find('td[data-name="ID"]').text());
                        selectedDNs.push($(this).find('td[data-name="DN"]').text());
                        $(this).addClass('selected');
                    }
                }
            }

            UpdateExipButtonUI();
        });

        //click to open services
        $('.click_dn').on('click', function () {
            $('#btnBackToAbonentFromExip').click();
            OpenServicesForDN($(this).data('dn'));
        });

        UpdateExipButtonUI();
    }

    function LoadExip() {
        $('#exipTable').load('/Subscribers/LoadExtensions/' + $('#AbonentID').val(), AttachEventsToExip);
    }

    function GetRanges() {
        $('#abDNRanges').empty();
        $('#abDNRanges').append('<option value="0"></option>');

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetRanges/' + $('#abDNPBX').val(),
            success: function (response) {
                if (response !== null && response.success === true) {

                    response.rgs.forEach(e => {
                        $('#abDNRanges').append('<option value="' + e.ID + '">' + e.Name + '</option>');
                    });

                    GetFreeDNs();
                }
            }
        });
    }

    function GetFreeDNs() {
        $('#freeDnsList').empty();

        if ($('#abDNRanges').val() * 1 !== 0) {
            $.ajax({
                type: "POST",
                traditional: true,
                url: '/Subscribers/GetFreeDNs/' + $('#abDNRanges').val(),
                success: function (response) {
                    if (response !== null && response.success === true) {

                        response.frees.forEach(e => {
                            $('#freeDnsList').append('<option>' + e + '</option>');
                        });
                    }
                }
            });
        }
    }

    //open section for plans
    $('#btnSetRatePlane').on('click', () => {
        $('#additionalSection').load('/Subscribers/GetDNPlans/' + selectedExip[0]);
    });

    //back to abonent
    $('#btnBackToAbonentFromExip').on('click', () => {
        $('#additionalSection').slideUp('fast');
        $('#editSection').slideDown('fast');

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetExIp/' + $('#AbonentID').val(),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#AbonentExtensions').val(response.e);
                    $('#AbonentIPs').val(response.i);
                }
            }
        });

        LoadDns();
    });

    //changing the Active only state
    $('#ActiveOnlyExtensions').change(() => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/SetExIpActiveOnly/?state=' + $('#ActiveOnlyExtensions').prop('checked'),
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadExip();
                }
            }
        });
    });

    //Show the DN transferring modal window
    $('#btnDNtransfer').on('click', function () {
        var dns = "";
        var dnIDs = "";
        if (selectedDNs.length >= 1) {
            dns = selectedDNs[0];
            dnIDs = selectedExip[0];
            for (let i=1; i < selectedDNs.length; i++) {
                dns = dns + "," + selectedDNs[i];
                dnIDs = dnIDs + "," + selectedExip[i];
            }
        }
        var mindate = new Date();
        var curmonth = mindate.getMonth();
        var cmonth = "";
        if (curmonth < 10)
        {
            curmonth++;
            if (curmonth < 10) { cmonth = "0" + curmonth.toString(); }
            else { cmonth = curmonth.toString();}
        }
        $('#transdate').attr("min", mindate.getFullYear() + "-" + cmonth + "-01");
        $('#extensions').val(dns);
        $('#extensionIDs').val(dnIDs);
        $('#subscriberID').val($('#AbonentID').val());
        $('#DNtransferring').modal('show');
    });

    //Transfer of the DN Transferring window data to the controller
    $('#dnTransfer').on('click', function () {
        $('#DNtransferring').modal('hide');
        ShowSpinner(true);
        var data = $('#transferreddn').serialize();
        $.ajax({
            method: 'POST',
            async: true,
            data: data,
            dataType: 'json',
            url: '/Subscribers/DNtransfer/',
            success: function () {
                ShowSpinner(false);
                LoadExip();
                UpdateFreeData();
            }   
        })
    })

    //show modal for delete an abonent dn
    $('#btnDeleteexip').on('click', () => {
        $('#cannotDeleteDN').hide();
        $('#deleteAbonentexipConfirm').prop('disabled', false);
        $('#deleteAbonentexip').modal('show');
    });

    //confirm delete dn
    $('#deleteAbonentexipConfirm').on('click', () => {
        $('#deleteAbonentexip').modal('hide');
        ShowSpinner(true);

        $.ajax({
            method: 'POST',
            data: { ids: selectedExip },
            dataType: "json",
            url: '/Subscribers/DeleteDN/',
            success: function (response) {
                ShowSpinner(false);
                LoadExip();
                UpdateFreeData();
            }
        });
    });

    //show modal for setup dn as main
    $('#btnSetMainexip').on('click', () => { $('#setupAsMainDN').modal('show'); });

    //confirm setup as main
    $('#setupAsMainbtn').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/SetupDNAsMain/' + selectedExip[0],
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#setupAsMainDN').modal('hide');
                    LoadExip();
                }
            }
        });
    });

    //show modal for adding a new dn
    $('#btnAddexip').on('click', () => {

        $('#addDnAgain').unbind();
        $('#saveDNbtn').unbind();

        GetRanges();

        $('#abDN').val('');
        $('#abDNDescription').val('');

        $('#FromDNEnabled').prop('checked', true);
        $('#ToDNEnabled').prop('checked', false);

        //$('#datetimepickerFromDN').removeClass('disDiv');
        //$('#datetimepickerToDN').addClass('disDiv');

        //$('#datetimepickerFromDN').data("DateTimePicker").setDate(new Date());
        //$('#datetimepickerToDN').data("DateTimePicker").setDate(new Date(3000, 0));
        $('#dateFromDN').val('2023-01-01');
        $('#dateToDN').val('3000-01-01');

        $('#saveDNbtn').prop('disabled', true);
        $('#abDNRequired').hide();
        $('#dnisnotFreSection').hide();
        $('#editDNtitle').text($('#newAbexip').val());
        $('#ExtensionType').val(0);

        //add dn
        $('#addDnAgain').on('click', () => {
            $('#editDNmodal').modal('hide');
            ShowSpinner(true);

            var formData = new FormData();
            formData.append('fromdt', $('#dateFromDN').val());
            formData.append('todt', $('#dateToDN').val());

            $.ajax({
                type: 'POST',
                async: true,
                url: '/Subscribers/AddDN/' + $('#abDNPBX').val()
                    + '/' + $('#AbonentID').val()
                    + '/?DN=' + encodeURIComponent($('#abDN').val())
                    + '&Description=' + encodeURIComponent($('#abDNDescription').val())
                    + '&FromEnable=' + $('#FromDNEnabled').prop('checked')
                    + '&ToEnable=' + $('#ToDNEnabled').prop('checked')
                    + '&Type=' + $('#ExtensionType').val(),
                data: formData,
                datatype: 'application/octet-stream',
                contentType: false,
                processData: false,
                traditional: true,
                success: function (response) {
                    ShowSpinner(false);
                    if (response !== null && response.success === true) {
                        LoadExip();
                        UpdateFreeData();
                    }
                    else {
                        $('#licenceModal').modal('show');
                    }
                }
            });
        });

        //check dn
        $('#saveDNbtn').on('click', () => {
            $('#saveDNbtn').prop('disabled', true);

            $.ajax({
                type: "POST",
                traditional: true,
                url: '/Subscribers/IsFreeDN/' + $('#abDNPBX').val() + '/?DN=' + encodeURIComponent($('#abDN').val()),
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#addDnAgain').click();
                    }
                    else {
                        $('#dnisnotFreSection').slideDown('fast');
                    }
                }
            });
        });

        $('#editDNmodal').modal('show');
    });

    //load new ranges
    $('#abDNPBX').change(GetRanges);

    //load new free dns for selected range
    $('#abDNRanges').change(GetFreeDNs);

    //date checkboxes
    $('#FromDNEnabled').change(() => {
        if ($('#FromDNEnabled').prop('checked') === true) {
            $('#dateFromDN').val(currentdate());
        }
        else {
            $('#dateFromDN').val("1900-01-01");
        }
    });
    $('#ToDNEnabled').change(() => {
        if ($('#ToDNEnabled').prop('checked') === true) {
            $('#dateToDN').val(currentdate());
        }
        else {
            $('#dateToDN').val("3000-01-01");
         }
    });

    //show error when dn field is empty
    $('#abDN').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#abDNRequired').slideDown('fast');
            $('#saveDNbtn').prop('disabled', true);
        }
        else {
            $('#abDNRequired').slideUp('fast');
            $('#saveDNbtn').prop('disabled', false);
        }
    });

    //show modal for editing dn
    $('#btnEditexip').on('click', () => {
        $('#addDnAgain').unbind();
        $('#saveDNbtn').unbind();
        
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetDN/' + selectedExip[0],
            success: function (response) {
                if (response !== null && response.success === true) {

                    GetRanges();

                    $('#abDN').val(response.dn.DN);
                    $('#abDNDescription').val(response.dn.Description);
                    $('#abDNPBX').val(response.dn.PbxId);

                    if (response.dn.FromDate !== null && response.dn.FromDate !== undefined) {
                        $('#FromDNEnabled').prop('checked', true);
                        $('#dateFromDN').val(response.dn.FromDateValue.substr(0, 10));
                    }
                    else {
                        $('#FromDNEnabled').prop('checked', false);
                        $('#dateFromDN').val("1900-01-01");
                    }

                    if (response.dn.ToDate !== null && response.dn.ToDate !== undefined) {
                        $('#ToDNEnabled').prop('checked', true);
                        $('#dateToDN').val(response.dn.ToDateValue.substr(0, 10));
                    }
                    else {
                        $('#ToDNEnabled').prop('checked', false);
                        $('#dateToDN').val("3000-01-01");
                    }

                    $('#ExtensionType').val(response.dn.NumberType);

                    $('#saveDNbtn').prop('disabled', false);
                    $('#abDNRequired').hide();
                    $('#dnisnotFreSection').hide();
                    $('#editDNtitle').text($('#editAbexip').val());

                    //add dn
                    $('#addDnAgain').on('click', () => {
                        $('#editDNmodal').modal('hide');
                        ShowSpinner(true);

                        var formData = new FormData();
                        formData.append('fromdt', $('#dateFromDN').val());
                        if ($('#dateToDN').val() > $('#dateFromDN').val()) { formData.append('todt', $('#dateToDN').val()); }
                        else { formData.append('todt', "3000-01-01"); }

                        $.ajax({
                            type: 'POST',
                            async: true,
                            url: '/Subscribers/EditDN/'
                                + selectedExip
                                + '/' + $('#abDNPBX').val()
                                + '/?DN=' + encodeURIComponent($('#abDN').val())
                                + '&Description=' + encodeURIComponent($('#abDNDescription').val())
                                + '&FromEnable=' + $('#FromDNEnabled').prop('checked')
                                + '&ToEnable=' + $('#ToDNEnabled').prop('checked')
                                + '&Type=' + $('#ExtensionType').val(),
                            data: formData,
                            datatype: 'application/octet-stream',
                            contentType: false,
                            processData: false,
                            traditional: true,
                            success: function (response) {
                                if (response !== null && response.success === true) {
                                    ShowSpinner(false);
                                    LoadExip();
                                    UpdateFreeData();
                                }
                            }
                        });
                    });

                    //check dn
                    $('#saveDNbtn').on('click', () => {
                        $('#saveDNbtn').prop('disabled', true);

                        $.ajax({
                            type: "POST",
                            traditional: true,
                            url: '/Subscribers/IsFreeDN2/' + selectedExip + '/' + $('#abDNPBX').val() + '/?DN=' + encodeURIComponent($('#abDN').val()),
                            success: function (response) {
                                if (response !== null && response.success === true) {
                                    $('#addDnAgain').click();
                                }
                                else {
                                    $('#dnisnotFreSection').slideDown('fast');
                                }
                            }
                        });
                    });

                    $('#editDNmodal').modal('show');
                }
            }
        });
    });

    //show modal to edit address
    $('#btnSetAddress').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetDNAddress/' + selectedExip[0],
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#dn_ID').val(response.address.ID);
                    $('#dn_Name').val(response.address.Name);
                    $('#dn_City').val(response.address.City);
                    $('#dn_ZipCode').val(response.address.ZipCode);
                    $('#dn_Area').val(response.address.Area);
                    $('#dn_Street').val(response.address.Street);
                    $('#dn_Building').val(response.address.Building);
                    $('#dn_House').val(response.address.House);
                    $('#dn_Floor').val(response.address.FloorNumber);
                    $('#dn_Flat').val(response.address.Flat);

                    $('#btnSaveDNAddress').unbind();
                    $('#btnSaveDNAddress').on('click', () => {
                        ShowSpinner(true);

                        var formData = new FormData();

                        formData.append('Name', $('#dn_Name').val());
                        formData.append('City', $('#dn_City').val());
                        formData.append('ZipCode', $('#dn_ZipCode').val());
                        formData.append('Area', $('#dn_Area').val());
                        formData.append('Street', $('#dn_Street').val());
                        formData.append('Building', $('#dn_Building').val());
                        formData.append('House', $('#dn_House').val());
                        formData.append('Floor', $('#dn_Floor').val());
                        formData.append('Flat', $('#dn_Flat').val());

                        $.ajax({
                            type: "POST",
                            data: formData,
                            datatype: 'application/octet-stream',
                            contentType: false,
                            processData: false,
                            traditional: true,
                            url: '/Subscribers/UpdateAddress/' + $('#dn_ID').val(),
                            success: function (response) {
                                LoadExip();
                                ShowSpinner(false);
                            }
                        });
                    });

                    $('#DNAddressModal').modal('show');
                }
            }
        });
    });

    initdatetimepickers();
    LoadExip();
});