﻿function UpdateFreeData() {
    $('#freeAB').text('~');
    $('#countAB').text('~');

    $.ajax({
        type: "POST",
        traditional: true,
        url: '/Subscribers/GetFreeSpaceData',
        success: function (response) {
            if (response !== null && response.success === true) {
                $('#freeAB').text(((response.free * 1) < 0 ? 0 : response.free));
                $('#countAB').text(response.used);
            }
        }
    });
}

$(document).ready(() => {
    let selectedRowID = [];
    let selectedDepartment = false;
    let rowIndex;

    function RemoveFromArray(array, element) {
        //remove element form array
        const index = array.indexOf(element);

        if (index !== -1) {
            array.splice(index, 1);
        }
    }

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/Subscribers/Export/?type=' + t + '&search=' + encodeURIComponent($('#tbSearch').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/Subscribers/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function CheckForEdit() {
        if (window.location.href.includes('#')) {
            let index = window.location.href.indexOf('#') + 1;
            let id = window.location.href.substr(index, window.location.href.length - index)

            if (id || id.trim()) {
                selectedRowID.push(id);
                OpenForEditAbonent();
            }
        }
    }

    function ExpandLeftMenu() {
        try {
            if (NodeIsLoaded) {
                ShowNodes('NewNodesMenu');
                ShowNodeEntry($('#nodeID').val() + '');
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }

    }

    function UpdateButtonsTree() {

        $('#btnAdd').prop('disabled', false);
        $('#btnAddSubGroup').prop('disabled', false);
        $('#btnImport').prop('disabled', false);
        $('#btnBadDNs').prop('disabled', false);

        $('#btnAddMenu').removeClass('disDiv');
        $('#btnAddSubGroupMenu').removeClass('disDiv');
        $('#btnImportMenu').removeClass('disDiv');

        if ($('#multiselect').prop('checked')) {
            if (selectedRowID.length === 0) {
                $('#btnEdit').prop('disabled', true);
                $('#btnGeneratePassword').prop('disabled', true);
                $('#btnMove').prop('disabled', true);
                $('#btnOffAbonent').prop('disabled', true);
                $('#btnEditRestr').prop('disabled', true);
                $('#btnDelete').prop('disabled', true);
                $('#btnEditHeads').prop('disabled', true);
                $('#btnMakePublic').prop('disabled', true);
                $('#btnMakeNonPublic').prop('disabled', true);
                
                $('#btnEditMenu').addClass('disDiv');
                $('#btnGeneratePasswordMenu').addClass('disDiv');
                $('#btnMoveMenu').addClass('disDiv'); 
                $('#btnOffAbonentMenu').addClass('disDiv');
                $('#btnEditRestrMenu').addClass('disDiv');
                $('#btnDeleteMenu').addClass('disDiv');
                $('#btnEditHeadsMenu').addClass('disDiv');
                $('#btnMakePublicMenu').addClass('disDiv');
                $('#btnMakeNonPublicMenu').addClass('disDiv');
            }
            else if (selectedRowID.length === 1) {
                $('#btnEdit').prop('disabled', false);
                $('#btnGeneratePassword').prop('disabled', false);
                $('#btnMove').prop('disabled', false);
                $('#btnEditRestr').prop('disabled', false);
                $('#btnDelete').prop('disabled', false);
                $('#btnOffAbonent').prop('disabled', selectedDepartment);
                $('#btnEditHeads').prop('disabled', !selectedDepartment);
                $('#btnMakePublic').prop('disabled', !selectedDepartment);
                $('#btnMakeNonPublic').prop('disabled', !selectedDepartment);

                $('#btnEditMenu').removeClass('disDiv');
                $('#btnGeneratePasswordMenu').removeClass('disDiv');
                $('#btnMoveMenu').removeClass('disDiv');
                $('#btnEditRestrMenu').removeClass('disDiv');
                $('#btnDeleteMenu').removeClass('disDiv');

                if (selectedDepartment) {
                    $('#btnOffAbonentMenu').addClass('disDiv');
                    $('#btnEditHeadsMenu').removeClass('disDiv');
                    $('#btnMakePublicMenu').removeClass('disDiv');
                    $('#btnMakeNonPublicMenu').removeClass('disDiv');
                }
                else {
                    $('#btnOffAbonentMenu').removeClass('disDiv');
                    $('#btnEditHeadsMenu').addClass('disDiv');
                    $('#btnMakePublicMenu').addClass('disDiv');
                    $('#btnMakeNonPublicMenu').addClass('disDiv');
                }
            }
            else {
                $('#btnEdit').prop('disabled', selectedDepartment);
                $('#btnGeneratePassword').prop('disabled', selectedDepartment);
                $('#btnAdd').prop('disabled', selectedDepartment);
                $('#btnAddSubGroup').prop('disabled', selectedDepartment);
                $('#btnImport').prop('disabled', selectedDepartment);

                $('#btnMove').prop('disabled', false);
                $('#btnDelete').prop('disabled', false);

                $('#btnEditRestr').prop('disabled', true); 
                $('#btnOffAbonent').prop('disabled', true);
                $('#btnEditHeads').prop('disabled', true);
                $('#btnMakePublic').prop('disabled', true);
                $('#btnMakeNonPublic').prop('disabled', true);

                $('#btnMoveMenu').removeClass('disDiv');
                $('#btnDeleteMenu').removeClass('disDiv');

                $('#btnEditRestrMenu').addClass('disDiv'); 
                $('#btnOffAbonentMenu').addClass('disDiv');
                $('#btnEditHeadsMenu').addClass('disDiv');
                $('#btnMakePublicMenu').addClass('disDiv');
                $('#btnMakeNonPublicMenu').addClass('disDiv');

                if (selectedDepartment) {
                    $('#btnEditMenu').addClass('disDiv');
                    $('#btnGeneratePasswordMenu').addClass('disDiv');
                    $('#btnAddMenu').addClass('disDiv');
                    $('#btnAddSubGroupMenu').addClass('disDiv');
                    $('#btnImportMenu').addClass('disDiv');
                }
                else {
                    $('#btnEditMenu').removeClass('disDiv');
                    $('#btnGeneratePasswordMenu').removeClass('disDiv');
                    $('#btnAddMenu').removeClass('disDiv');
                    $('#btnAddSubGroupMenu').removeClass('disDiv');
                    $('#btnImportMenu').removeClass('disDiv');
                }
            }
        }
        else {
            if (selectedRowID.length === 0) {
                $('#btnEdit').prop('disabled', true);
                $('#btnGeneratePassword').prop('disabled', true);
                $('#btnMove').prop('disabled', true); 
                $('#btnOffAbonent').prop('disabled', true);
                $('#btnEditRestr').prop('disabled', true);
                $('#btnDelete').prop('disabled', true);
                $('#btnEditHeads').prop('disabled', true);
                $('#btnMakePublic').prop('disabled', true);
                $('#btnMakeNonPublic').prop('disabled', true);

                $('#btnEditMenu').addClass('disDiv');
                $('#btnGeneratePasswordMenu').addClass('disDiv');
                $('#btnMoveMenu').addClass('disDiv');
                $('#btnOffAbonentMenu').addClass('disDiv');
                $('#btnEditRestrMenu').addClass('disDiv');
                $('#btnDeleteMenu').addClass('disDiv');
                $('#btnEditHeadsMenu').addClass('disDiv');
                $('#btnMakePublicMenu').addClass('disDiv');
                $('#btnMakeNonPublicMenu').addClass('disDiv');
            }
            else {
                $('#btnEdit').prop('disabled', false);
                $('#btnGeneratePassword').prop('disabled', false);
                $('#btnMove').prop('disabled', false);
                $('#btnEditRestr').prop('disabled', false);
                $('#btnDelete').prop('disabled', false);
                
                $('#btnOffAbonent').prop('disabled', selectedDepartment);
                $('#btnEditHeads').prop('disabled', !selectedDepartment);
                $('#btnMakePublic').prop('disabled', !selectedDepartment);
                $('#btnMakeNonPublic').prop('disabled', !selectedDepartment);

                $('#btnEditMenu').removeClass('disDiv');
                $('#btnGeneratePasswordMenu').removeClass('disDiv');
                $('#btnMoveMenu').removeClass('disDiv');
                $('#btnEditRestrMenu').removeClass('disDiv');
                $('#btnDeleteMenu').removeClass('disDiv');

                if (selectedDepartment) {
                    $('#btnOffAbonentMenu').addClass('disDiv');
                    $('#btnEditHeadsMenu').removeClass('disDiv');
                    $('#btnMakePublicMenu').removeClass('disDiv');
                    $('#btnMakeNonPublicMenu').removeClass('disDiv');
                }
                else {
                    $('#btnOffAbonentMenu').removeClass('disDiv');
                    $('#btnEditHeadsMenu').addClass('disDiv');
                    $('#btnMakePublicMenu').addClass('disDiv');
                    $('#btnMakeNonPublicMenu').addClass('disDiv');
                }
            }
        }
    }

    //redirect to import broken DNs
    $('#btnBadDNs').on('click', () => { window.open('/Subscribers/File', '_parent'); });
    $('#btnBrokenDNsMenu').on('click', () => { window.open('/Subscribers/File', '_parent'); });
    function RowClick(e) {
        if ($('#multiselect').prop('checked')) {
            let id = e.find('td[data-name="ID"]').text();

            let isDep = e.data('d') === 1;

            if (e.hasClass('selected')) {
                e.removeClass('selected');

                RemoveFromArray(selectedRowID, id);
                selectedDepartment = isDep;
            }
            else {
                if (isDep) {
                    if (selectedDepartment !== true) {
                        selectedRowID = [];
                        $('#tariscope-subs tr.selected').removeClass('selected');
                    }

                    selectedRowID.push(id);
                    selectedDepartment = true;
                }
                else {
                    if (selectedDepartment === true) {
                        $('#tariscope-subs tr.selected').removeClass('selected');
                        selectedRowID = [];
                    }


                    selectedRowID.push(id);
                    selectedDepartment = false;
                }
                e.addClass('selected');
            }
        }
        else {
            selectedRowID = [];

            if (e.hasClass('selected')) {
                e.removeClass('selected');
                selectedDepartment = false;
            }
            else {
                selectedRowID.push(e.find('td[data-name="ID"]').text());
                selectedDepartment = e.data('d') === 1;
                $('#tariscope-subs tr.selected').removeClass('selected');
                e.addClass('selected');
            }
        }

        UpdateButtonsTree();
    }

    function RowClickScrollArea(e, g) {
        if (g.shiftKey) {//select via shift
            var newIndex = e.index();

            var table = $('#tariscope-subs');

            //init first row
            if (rowIndex === null)
                rowIndex = e.index();

            tempIndex = rowIndex;

            //clear prev selected
            selectedRowID = [];

            $('#tariscope-subs tr.selected').removeClass('selected');

            var direction = newIndex >= rowIndex;

            if (direction) {//select down
                while (tempIndex <= newIndex) {
                    tempIndex += 1;

                    var tr = $('tr:eq(' + tempIndex + ')', table);

                    if (tr.css('display') !== 'none') {
                        tr.addClass('selected');
                        RemoveFromArray(selectedRowID, tr.find('td[data-name="ID"]').text());
                        selectedRowID.push(tr.find('td[data-name="ID"]').text());
                    }
                }
            }
            else {//select up
                while (tempIndex > (newIndex - 1)) {
                    var tr2 = $('tr:eq(' + (tempIndex + 1) + ')', table);

                    if (tr2.css('display') !== 'none') {
                        tr2.addClass('selected');
                        RemoveFromArray(selectedRowID, tr2.find('td[data-name="ID"]').text());
                        selectedRowID.push(tr2.find('td[data-name="ID"]').text());
                    }

                    tempIndex -= 1;
                }
            }
        }
        else {//single select
            rowIndex = e.index();

            selectedRowID = [];

            if (e.hasClass('selected')) {
                $('#tariscope-subs tr.selected').removeClass('selected');
            }
            else {
                $('#tariscope-subs tr.selected').removeClass('selected');
                selectedRowID.push(e.data('id'));
                e.addClass('selected');
            }
        }

        UpdateButtonsTree();
    }

    function AttachEventsForAbonents() {
        var header = document.getElementById("abonentsHead");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        selectedRowID = [];
        selectedDepartment = false;

        //select
        if ($('#scrollArea').length === 0) {
            $('#mulstiselectSection').removeClass('disDiv');

            $('#tariscope-subs tbody').on('click', 'tr', function () { RowClick($(this)); });
            $('#tariscope-subs tbody').on('dblclick', 'tr', function () {
                RowClick($(this));
                if (selectedRowID.length = 1 && !selectedDepartment)
                    $('#btnEdit').click();
            });
        }
        else {
            $('#mulstiselectSection').addClass('disDiv');

            $('#contentArea').on('click', 'tr', function (e) { RowClickScrollArea($(this), e); });
            $('#contentArea').on('dblclick', 'tr', function (e) {
                RowClickScrollArea($(this), e);
                if (selectedRowID.length = 1 && !selectedDepartment)
                    $('#btnEdit').click();
            });
        }

        //move
        $('#moveSelectedbtn').on('click', () => {
            $.ajax({
                type: "POST",
                traditional: true,
                url: '/Subscribers/' + (selectedDepartment ? 'MoveDepartment' : 'MoveAbonent') + '/' + $('#departmentMoveTo').val() + '/?IDs=' + selectedRowID.join(','),
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#moveTomodal').modal('hide');
                        LoadAbonents();
                    }
                }
            });
        });

        //set sort
        $('th').on('click', function () {
            if ($(this).data('thname') !== null && $(this).data('thname') !== undefined) {
                $.ajax({
                    type: "POST",
                    url: '/Subscribers/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                    traditional: true,
                    success: function (response) {
                        if (response !== null && response.success === true) {
                            LoadAbonents();
                        }
                    }
                });
            }
        });

        UpdateButtonsTree();

        ShowSpinner(false);
        CheckForEdit();
    }

    window.LoadAbonents = () => {
        ShowSpinner(true);
        $('#subscribersTable').load("/Subscribers/Load/?Search=" + encodeURIComponent($('#tbSearch').val()), AttachEventsForAbonents);
        UpdateFreeData();
    };

    function OpenForEditAbonent() {
        if (selectedDepartment) {
            $.ajax({
                type: "POST",
                traditional: true,
                url: '/Subscribers/GetDepartment/' + selectedRowID[0],
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#emptyDepartmentName').hide();
                        $('#saveDepartmentbtn').prop('disabled', false);

                        $('#departmentNameinput').val(response.name);
                        $('#departmentDescription').val(response.desc);
                        $('#departmentAddress').val(response.addr);

                        $('#editDepartmentmodal').modal('show');
                    }
                }
            });
        }
        else {
            if (selectedRowID.length === 1) {
                ShowSpinner(true);
                $('#editSection').load('/Subscribers/EditAbonent/' + selectedRowID[0], OpenEditSection);
            }
            else if (selectedRowID.length > 1) {
                $('#additionalSection').load('/Subscribers/GetMultiEditSection/?IDs=' + selectedRowID.join(','), OpenSectionForEditMulti);
            }
        }
    }

    function OpenSectionForEditMulti() {
        $('#accountName').text($('#several').val());

        $('#editTitle').show();
        $('#accountTitle').hide();

        $('#accountsSection').slideUp('fast');
        $('#additionalSection').slideDown('fast');
    }

    function OpenEditSection() {
        ShowSpinner(false);
        $('#accountsSection').slideUp('fast');
        $('#editSection').slideDown('fast');
    }

    function LoadRestrEvents() {
        $('#accountsSection').slideUp('fast');
        $('#additionalSection').slideDown('fast');
    }

    function initdatetime() {
        //init datetimepicker
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),
            locale: $('#LocaleThread').val(),
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true,
            format: 'L'
        };

        $('#datetimepickerAddNew').datetimepicker(options);

        $('#datetimepickerAddNew').data("DateTimePicker").setDate(new Date());
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            LoadAbonents();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //set multiselect
    $('#multiselect').change(() => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/SetMultiselect/?state=' + $('#multiselect').prop('checked'),
        });
    });

    //open for edit abonent
    $('#btnEdit, #btnEditMenu').on('click', OpenForEditAbonent);

    //show an error when the department name is empty
    $('#departmentNameinput').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyDepartmentName').slideDown('fast');
            $('#saveDepartmentbtn').prop('disabled', true);
        }
        else {
            $('#emptyDepartmentName').slideUp('fast');
            $('#saveDepartmentbtn').prop('disabled', false);
        }
    });

    //save edited department
    $('#saveDepartmentbtn').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/SaveDepartment/' + selectedRowID[0]
                + '/?Name=' + encodeURIComponent($('#departmentNameinput').val())
                + '&Description=' + encodeURIComponent($('#departmentDescription').val())
                + '&Address=' + encodeURIComponent($('#departmentAddress').val()),
            success: function (response) {
                $('#editDepartmentmodal').modal('hide');

                let row = $('tr > td[data-name="ID"]:contains("' + selectedRowID[0] + '")').parent();
                row.find('span[class="descSpan"]').text($('#departmentNameinput').val());
            }
        });
    });

    //show modal for add group
    $('#btnAddSubGroup, #btnAddSubGroupMenu').on('click', () => {
        $('#emotyDepartmentName').hide();
        $('#newdepartmentName').val('');
        $('#saveNewDepartment').prop('disabled', true);
        $('#addDepartmnetmodal').modal('show');
    });

    //show error when department name field is emprt
    $('#newdepartmentName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emotyDepartmentName').slideDown('fast');
            $('#saveNewDepartment').prop('disabled', true);
        }
        else {
            $('#emotyDepartmentName').slideUp('fast');
            $('#saveNewDepartment').prop('disabled', false);
        }
    });

    //confrim add department
    $('#saveNewDepartment').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/AddDepartment/' + (selectedDepartment ? selectedRowID[0] : -1) + '/?Name=' + encodeURIComponent($('#newdepartmentName').val()),
            success: function (response) {
                $('#addDepartmnetmodal').modal('hide');
                LoadAbonents();
            }
        });
    });

    //show modal for add group
    $('#btnAdd, #btnAddMenu').on('click', () => {
        $('#emotyAbonentName').hide();
        $('#newabonentName').val('');
        $('#saveNewAbonent').prop('disabled', true);
        $('#addAbonentmodal').modal('show');
    });

    //show error when abonent name field is emprt
    $('#newabonentName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emotyAbonentName').slideDown('fast');
            $('#saveNewAbonent').prop('disabled', true);
        }
        else {
            $('#emotyAbonentName').slideUp('fast');
            $('#saveNewAbonent').prop('disabled', false);
        }
    });

    //create empty abonent
    $('#saveNewAbonent').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/AddAbonent/' + (selectedDepartment ? selectedRowID[0] : -1) + '/?Name=' + encodeURIComponent($('#newabonentName').val()),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#addAbonentmodal').modal('hide');
                    window.location = '/Subscribers/' + $('#nodeID').val() + '#' + response.id;
                    LoadAbonents();
                }
                else {
                    $('#addAbonentmodal').modal('hide');
                    $('#licenceModal').modal('show');
                }
            }
        });
    });

    //close success modal
    $('#licenceModal').on('hidden.bs.modal', function () {
        setTimeout(function () { $('body').css('padding-right', 0) }, 500);
    });

    //open buy page
    $('#openBuyPage').on('click', () => { window.open($('#buyURL').val(), '_blank'); });

    //open details license
    $('#licenseDetails').on('click', () => { window.location = '/License/CurrentKey'; });

    //show modals for delete abonent or department
    $('#btnDelete, #btnDeleteMenu').on('click', () => {
        if (selectedDepartment) {
            $('#deleteDepartmentConfirm').prop('disabled', false);
            $('#rootDepartmnetError').hide();
            $('#deleteDepartmentmodal').modal('show');
        }
        else {
            $('#deleteAbonentConfirm').prop('disabled', false);
            $('#cannotDeleteAbonent').hide();
            $('#deleteAbonentmodal').modal('show');
        }
    });

    //confimr delete abonent
    $('#deleteAbonentConfirm').on('click', () => {
        $('#deleteAbonentConfirm').prop('disabled', true);

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/DeleteAbonent/?IDs=' + selectedRowID.join(','),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#deleteAbonentmodal').modal('hide');

                    for (key in selectedRowID) {
                        $('tr > td[data-name="ID"]:contains("' + selectedRowID[key] + '")').parent().remove();
                    }

                    selectedRowID = [];
                    selectedDepartment = false;

                    UpdateButtonsTree();
                    UpdateFreeData();
                }
                else {
                    $('#deleteAbonentConfirm').prop('disabled', true);
                    $('#cannotDeleteAbonent').slideDown('fast');
                }
            }
        });
    });

    //confirm delete department
    $('#deleteDepartmentConfirm').on('click', () => {
        $('#deleteDepartmentConfirm').prop('disabled', true);

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/DeleteDepartment/?IDs=' + selectedRowID.join(','),
            success: function (response) {
                if (response !== null) {
                    for (key in selectedRowID) {
                        let row = $('tr > td[data-name="ID"]:contains("' + selectedRowID[key] + '")').parent();

                        if (row.prop('id') !== 'firstDep') {

                            if ($(row).data('opened'))
                                row.find('span[class="expandButton"]').click();

                            row.remove();
                        }
                        else {
                            row.removeClass('selected');
                        }
                    }

                    selectedRowID = [];
                    selectedDepartment = false;

                    UpdateButtonsTree();
                    UpdateFreeData();

                    if (response.success === false) {
                        $('#deleteDepartmentConfirm').prop('disabled', true);
                        $('#rootDepartmnetError').slideDown('fast');
                    }
                    else {
                        $('#deleteDepartmentmodal').modal('hide');
                    }
                }
            }
        });
    });

    //show modal for move abonent or deparmtnet
    $('#btnMove, #btnMoveMenu').on('click', () => {
        $('#departmentMoveTo').val($('option:first', $('#departmentMoveTo')).val());
        $('#moveTomodal').modal('show');
    });

    //show message what email is not configured
    $('#abonentWebMail').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#mailAbonentNotSpec').slideDown('fast');
        }
        else {
            $('#mailAbonentNotSpec').slideUp('fast');
        }
    });

    //load restriction
    $('#btnEditRestr, #btnEditRestrMenu').on('click', () => {
        $('#additionalSection').load('/Subscribers/LoadRestrictions/' + selectedRowID[0] + '/?IsDepartment=' + selectedDepartment, LoadRestrEvents);
    });

    //load free DNs
    $('#btnShowFree, #btnShowFreeMenu').on('click', () => {
        $('#additionalSection').load('/Subscribers/LoadFreeDNs/', LoadRestrEvents);
    });

    //open active directory
    $('#btnImportAD, #btnImportADMenu').on('click', () => { window.location = '/ADSync'; });

    //whom display
    $('#btnAbonents, #btnAbonentsMenu').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/WhomDisplay/',
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#viewAbonentsselect').val(response.source);
                    $('#setViewTypemodal').modal('show');
                }
            }
        });
    });

    //save whom to display
    $('#setViewTypebtn').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/SaveWhomDisplay/' + $('#viewAbonentsselect').val(),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#setViewTypemodal').modal('hide');
                    $('#typeAB').text($('#viewAbonentsselect option:selected').text().toLocaleLowerCase());
                    LoadAbonents();
                }
            }
        });
    });

    /*attach events for select column*/
    $('#MenuSelectColumn input').on('click', function (event) {
        var visible = $(event.target).prop('checked');
        var colName = $(event.target).attr('data-value');

        if (colName === 'all') {
            $('#MenuSelectColumn').find('input').each((i, e) => {
                console.log(e);
                if ($(e).data('value') !== 'name' && $(e).data('value') !== 'all')
                    $(e).prop('checked', visible);
            });

            $.ajax({
                type: "POST",
                url: '/Subscribers/SetTableColumnVisabilityForAll/?visible=' + visible,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        for (let i = 0; i < 24; i++) {

                            var header = $('#col_' + i),
                                table = header.closest("table"),
                                selector = "tbody tr td:nth-child(" + (i + 1) + ")",
                                column = table.find(selector).add(header);

                            column.attr('hidden', !response.cols[i]);
                        }
                    }
                }
            });
        }
        else {
            $.ajax({
                type: "POST",
                url: '/Subscribers/SetTableColumnVisability/?colName=' + colName + "&visible=" + visible,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        for (let i = 0; i < 24; i++) {

                            var header = $('#col_' + i),
                                table = header.closest("table"),
                                selector = "tbody tr td:nth-child(" + (i + 1) + ")",
                                column = table.find(selector).add(header);

                            column.attr('hidden', !response.cols[i]);
                        }
                    }
                }
            });
        }
    });

    //how display
    $('#btnDisplay, #btnDisplayMenu').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/HowDisplay/',
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#viewdisplayselect').val(response.source);
                    $('#setViewDisplaymodal').modal('show');
                }
            }
        });
    });

    //save how to display
    $('#setViewDisplaybtn').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/SaveHowDisplay/' + $('#viewdisplayselect').val(),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#setViewDisplaymodal').modal('hide');
                    LoadAbonents();
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL, #ExportEXCELMenu').on('click', function () { Export("xlsx"); });
    $('#ExportHTML, #ExportHTMLMenu').on('click', function () { Export("html"); });
    $('#ExportCSV, #ExportCSVMenu').on('click', function () { Export("csv"); });
    $('#ExportPDF, #ExportPDFMenu').on('click', function () { Export("pdf"); });

    //open import
    $('#btnImport, #btnImportMenu').on('click', () => {
        if (selectedDepartment) {
            window.location = '/Subscribers/Import/' + selectedRowID[0];
        }
        else {
            $('#selectDepartmentForImportmodal').modal('show');
        }
    });

    //show modal for set department heads
    $('#btnEditHeads, #btnEditHeadsMenu').on('click', () => {
        $('#departmenHeadsSelect').empty();

        let el = $('tr[data-d="0"]');
        el.map(e => {
            $('#departmenHeadsSelect').append('<option value="' + $(el[e]).find('td[data-name="ID"]').text() + '">' + $(el[e]).find('td[data-name="Name"]').text() + '</option>');
        });

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetDepartmentHeads/' + selectedRowID[0],
            success: function (response) {
                if (response !== null && response.success === true) {

                    response.heads.map(e => {
                        $("#departmenHeadsSelect option[value='" + e + "']").prop("selected", true);
                    });

                    setTimeout(() => { $('#departmenHeadsSelect').select2({ theme: "bootstrap", placeholder: $('#groupHeadsPlaceholder').val() }); }, 250);
                    $('#editDepartmentHeadsmodal').modal('show');
                }
            }
        });
    });

    //save department heads
    $('#saveDepartmentHeadsbtn').on('click', () => {
        let ids = '';

        if ($('#departmenHeadsSelect').val() !== null) {
            ids = $('#departmenHeadsSelect').val().join();
        }

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/SaveDepartmentHeads/' + selectedRowID[0] + '/?IDs=' + encodeURIComponent(ids),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#editDepartmentHeadsmodal').modal('hide');
                }
            }
        });
    });

    //show modal to disconnect an abonent
    $('#btnOffAbonent, #btnOffAbonentMenu').on('click', () => { $('#disconnectAbonentModal').modal('show'); });

    //confirm disconnect abonnent
    $('#confirmDisconnectAbonent').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/Disconnect/' + selectedRowID[0],
            success: function (response) {
                if (response !== null && response.success === true) {

                    if ($('#viewAbonentsselect').val() * 1 === 1) {
                        for (key in selectedRowID) {
                            $('tr > td[data-name="ID"]:contains("' + selectedRowID[key] + '")').parent().remove();
                        }

                        selectedRowID = [];
                        selectedDepartment = false;

                        UpdateButtonsTree();
                    } 
                }
            }
        });
    });

    //set title
    $.ajax({
        type: "POST",
        traditional: true,
        url: '/Subscribers/WhomDisplay/',
        success: function (response) {
            if (response !== null && response.success === true) {
                $('#viewAbonentsselect').val(response.source);
                $('#typeAB').text($('#viewAbonentsselect option:selected').text().toLocaleLowerCase());
            }
        }
    });

    //show modal to make public
    $('#btnMakePublic, #btnMakePublicMenu').on('click', () => { $('#makePublicModal').modal('show'); });

    //show modal to make non public
    $('#btnMakeNonPublic, #btnMakeNonPublicMenu').on('click', () => { $('#makeNonPublicModal').modal('show'); });

    //confirm make public
    $('#confirmMakePublic').on('click', () => {
        if (selectedDepartment) {
            ShowSpinner(true);
            $.ajax({
                type: "POST",
                traditional: true,
                url: `/Subscribers/ManagePublic/${selectedRowID[0]}?State=true`,
                success: function (response) {
                    ShowSpinner(false);
                }
            });
        }
    });

    //confirm make non public
    $('#confirmMakeNonPublic').on('click', () => {
        if (selectedDepartment) {
            ShowSpinner(true);
            $.ajax({
                type: "POST",
                traditional: true,
                url: `/Subscribers/ManagePublic/${selectedRowID[0]}?State=false`,
                success: function (response) {
                    ShowSpinner(false);
                }
            });
        }
    });

    //show modal to generate password
    $('#btnGeneratePassword, #btnGeneratePasswordMenu').on('click', () => {
        if (selectedDepartment) {
            $('#generatePasswordForDepratmentmodal').modal('show');
        }
        else {
            $('#generatePasswordForAbonentsmodal').modal('show');
        }
    });

    //confirm generate and send password
    $('#confirmPasswordForAbonents, #confirmPasswordForDepratment').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            traditional: true,
            url: `/Subscribers/GeneratePassword/?Ids=${selectedRowID.join(',')}&IsDepartment=${selectedDepartment}`,
            success: function (response) {
                ShowSpinner(false);
                $('#passwordGeneratedmessage').text(response.msg);
                $('#passwordGeneratedmodal').modal('show');
            }
        });
    });

    //show modal to add a new rate plan
    $('#btnAddNewPlan, #btnAddNewPlanMenu').on('click', () => { $('#addRatePlanModal').modal('show'); });

    //show modal to replace rate plan
    $('#btnReplaceCurrentPlan, #btnReplaceCurrentPlanMenu').on('click', () => { $('#replaceCurrentRatePlanModal').modal('show'); });
    
    //show modal to replace selected rate plan
    $('#btnReplaceSelectedPlan, #btnReplaceSelectedPlanMenu').on('click', () => { $('#replaceSelectedRatePlanModal').modal('show'); });

    //confirm add a new plan for all abonents
    $('#addRatePlanBtn').on('click', () => {
        $('#addRatePlanModal').modal('hide');
        ShowSpinner(true);

        var formData = new FormData();
        formData.append('dt', $('#datetimepickerAddNew').data('date'));

        $.ajax({
            type: "POST",
            url: `/Subscribers/AddPlanForAll/${$('#nodeID').val()}/${$('#AddNewPlanList').val()}`,
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    LoadAbonents();
                }
            }
        });
    });

    //confirm replace the rate for all
    $('#replaceCurrentRatePlanBtn').on('click', () => {
        $('#replaceCurrentRatePlanModal').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: `/Subscribers/ReplaceAllPlanForAll/${$('#nodeID').val()}/${$('#ReplaceAlllanList').val()}`,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    LoadAbonents();
                }
            }
        });
    });

    //confirm replace selected
    $('#replaceSelectedRatePlanBtn').on('click', () => {
        $('#replaceSelectedRatePlanModal').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: `/Subscribers/ReplaceSelectedPlanForAll/${$('#nodeID').val()}/${$('#OriginPlanList').val()}/${$('#DestinationPlanList').val()}`,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    LoadAbonents();
                }
            }
        });
    });
    
    LoadAbonents();
    ExpandLeftMenu();
    initdatetime();
});