﻿$(document).ready(function () {
    window.reqVars = null;
    var selectedCPCode = null;
    var isEditSQL = false;
    var selectedLinked = null;
    var groupedTaskToEdit = null;
    let selectedSDHidden = [];
    let LoadingHtml = `<center><i class="fas fa-circle-notch fa-spin fa-lg"></i><h4>${$('#LoadingLbl').val()}</h4></center>`

    function initDateTimePicker() {
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepicker').datetimepicker(options);
    }

    function CheckFilter1() {
        //disable if selected <no filter>
        if ($('#listFilters_Report').prop('selectedIndex') === 0)
            $('#btnExitFilter_report').hide();
        else
            $('#btnExitFilter_report').show();
    }

    function CheckFilter2() {
        //disable if selected <no filter>
        if ($('#listFilters_calls').prop('selectedIndex') === 0)
            $('#btnExitFilter_calls').hide();
        else
            $('#btnExitFilter_calls').show();
    }

    function CheckUserSeparate() {
        //check separate abonents and selectr right title for email
        $('#titleSendAdmin').attr('hidden', $('#SeparateAbonents').prop('checked'));
        $('#titleSendUser').attr('hidden', !$('#SeparateAbonents').prop('checked'));
    }

    function CheckSendFile() {
        //check send file and enable option for send to user
        if (!$('#DocumentUpload').prop('checked')) {
            $('#DocumentVisibility_container').addClass('disDiv');
            $('#SelectLinkedUser').css('opacity', 0);
        }
        else {
            $('#DocumentVisibility_container').removeClass('disDiv');

            if ($('#SeparateAbonents').prop('checked'))
                $('#SelectLinkedUser').css('opacity', 0);
            else
                $('#SelectLinkedUser').css('opacity', 1);
        }
    }

    function CheckButtonsForCP() {
        //show or hide add/edit button for currency profiler
        if ($('#listCurrencyProfiles').val() === '-1') {
            $('#editcurrencyDIV').hide();
            $('#deletecurrencyDIV').hide();
            $('#exportcurrencyDIV').hide();
            $('#nbuDIV').hide();
            $('#addcurrencyDIV').show();
            $('#importcurrencyDIV').show();
        }
        else if ($('#listCurrencyProfiles').val() === '-2') {//NBU
            $('#editcurrencyDIV').hide();
            $('#deletecurrencyDIV').hide();
            $('#exportcurrencyDIV').hide();
            $('#addcurrencyDIV').hide();
            $('#importcurrencyDIV').hide();
            $('#nbuDIV').show();
        }
        else {
            $('#addcurrencyDIV').hide();
            $('#nbuDIV').hide();
            $('#editcurrencyDIV').show();
            $('#deletecurrencyDIV').show();
            $('#exportcurrencyDIV').show();
            $('#importcurrencyDIV').show();

        }
    }

    function CheckSQLListBtn() {
        //show or hide button for edit sql list
        if ($('#listAction').val() === "0" || $('#listAction').val() === "6" || $('#listAction').val() === "9")
            $('#AbonetSelectionSection0, #AbonetSelectionSection1').slideDown('fast');
        else
            $('#AbonetSelectionSection0, #AbonetSelectionSection1').slideUp('fast');
    }

    function FixOptGroup() {
        //fix name for splitter in currency profile select
        $('optgroup[label="Microsoft.AspNetCore.Mvc.Rendering.SelectListGroup"]').attr('label', '——————————');

    }

    function ShowCurCodeTable(show) {
        //show or hide table with codes for selected currency profiler
        $('#tableWithProfiles').attr('hidden', !show);
        $('#tableWithProfilesEmpty').attr('hidden', show);
    }

    function LoadSection(e) {
        //load section by number
        $('#jobSection_0').slideUp('fast');

        if (e != 1 && e != 2)
            $('#jobSection_1_2').slideUp('fast');

        $('#jobSection_3').slideUp('fast');
        $('#jobSection_4').slideUp('fast');
        $('#jobSection_5').slideUp('fast');
        $('#jobSection_7').slideUp('fast');
        $('#jobSection_8').slideUp('fast');
        $('#jobSection_9').slideUp('fast');

        if (e == 1 || e == 2)
            $('#jobSection_1_2').slideDown('fast');
        else if (e != 6)
            $('#jobSection_' + e).slideDown('fast');
    }

    function LoadReports() {
        //load reports to combobox
        $.ajax({
            type: "POST",
            async: true,
            url: '/Reporting/GetAll',
            traditional: true,
            success: function (response) {
                $('#Reports').empty();

                for (var i = 0; i < response.reports.length; i++) {
                    $('#Reports').append(`<option value="${response.reports[i].FilePath}">${response.reports[i].Name}</option>`)
                }

                $('#Reports').val($('#ReportName').val());
                $('#selectReportmodal').modal('show');
                setTimeout(InitReportSelect, 300);
                LoadReportInfo();
            }
        });
    }

    function AddCPCodeRow(rowItem) {
        //add row with cp data
        $('#tableWithProfiles tbody').append('<tr>' +
            '<td data-name="Code">' + rowItem.CurrencyCode + '</td>' +
            '<td>' + rowItem.Url + '</td></tr>');
    }

    function LoadReportInfo() {
        if ($('#Reports').val()) {
            $('#ReportStartupSection').html(LoadingHtml)
            $('#ReportStartupSection').load('/Reporting/GetReportData/?ReportFile=' + encodeURIComponent($('#Reports').val()), () => {
                SetVariablesFromJsonString($('#SavedVars').val());
                let parts = $('#GroupOfTasks').val().split('|');
                if (parts.length == 6) {
                    $('#reportCurrentOrient').val(parts[0]);
                    $('#reportCurrentPageFormat').val(parts[1]);
                    $('#reportCurrentMarignLeft').val(parts[2]);
                    $('#reportCurrentMarignRight').val(parts[3]);
                    $('#reportCurrentMarignTop').val(parts[4]);
                    $('#reportCurrentMarignBottom').val(parts[5]);
                }

                if ($('#listTypes').val()) {
                    $('#reportCurrentType').val($('#listTypes').val())
                }

                SetButtonToValidate('modalButtonSelectReport');
            });
        }
        else {
            $('#ReportStartupSection').empty();
        }
    }

    function UpdateCodeTableButtonsUI() {
        /*update ui for buttons when not selected any cp code some buttons disabled*/
        if (selectedCPCode === null) {
            $("#btnEditCurrencyCode").attr("disabled", true);
            $("#btnDeleteCurrencyCode").attr("disabled", true);
        }
        else {
            $("#btnEditCurrencyCode").attr("disabled", false);
            $("#btnDeleteCurrencyCode").attr("disabled", false);
        }

    }

    function FillCPCodesTable(elements) {
        //filling table with cp codes
        $('#tableWithProfiles_tbody').empty();
        elements.forEach(function (e) { AddCPCodeRow(e); });
        ShowCurCodeTable(elements.length > 0);
    }

    function ShowTitle() {

        //show true title
        if ($('#jobForEditID').val() !== "0") {
            $('#add').hide();
            $('#edit').show();
            $('#lblKdb').html($('#JobsName').val());
        }
        else {
            $('#add').show();
            $('#edit').hide();
        }

    }

    function UpdateFieldsMouseOver() {
        $('.tcxField').unbind();
        $('.tcxField').mouseover(function () {
            $(this).append($('#btnsTopDown'));
        });
    }

    function LoadGroupedTasks() {
        $('#GroupOfTasks').val().split(',').forEach(x => {
            if (!(x == null || x == undefined || x == '' || x == ' ')) {
                let name = $('#TasksToAddList').find(`option[value="${x * 1}"]`)[0];

                if (!name) {
                    name = $('#UndefinedTaskLbl').val();
                }

                let task = `<div class="form-group tcxField" data-task="${x}"><label><span class='tasknum'>${$('#SelectedTasks').children().length + 1}</span>. ${$(name).text()}</label></div>`;
                $('#SelectedTasks').append(task);
            }
        });

        if ($('div[data-task]').length == 0) {
            $('#SelectedTasks').empty();
            $('#SelectedTasks').append(`<div class="well well-sm"><div class="text-center">${$('#EmptyLbl').val()}</div></div>`);
        }

        UpdateFieldsMouseOver();
    }

    function AddGroupedTask() {
        let id = $('#TasksToAddList').val();

        let name = $('#TasksToAddList option:selected').html();

        if ($('div[data-task]').length == 0) {
            $('#SelectedTasks').empty();
        }

        let task = `<div class="form-group tcxField" data-task="${id}"><label><span class='tasknum'>${$('#SelectedTasks').children().length + 1}</span>. ${name}</label></div>`;

        $('#SelectedTasks').append(task);
        UpdateFieldsMouseOver();
    }

    function EditGroupedTask() {
        let id = $('#TasksToAddList').val();

        if (id * 1 == groupedTaskToEdit * 1)
            return;

        let name = $('#TasksToAddList option:selected').html();
        let task = `<div class="form-group tcxField" data-task="${id}"><label><span class='tasknum'>${$('#SelectedTasks').children().length + 1}</span>. ${name}</label></div>`;

        let oldtask = $(`div[data-task="${groupedTaskToEdit}"]`);

        if (oldtask.length > 0) {
            oldtask.replaceWith(task);
        }
        else {
            $('#SelectedTasks').append(task);
        }

        UpdateFieldsMouseOver();
        RecalculateOrderGroupedTasks();
    }

    function RecalculateOrderGroupedTasks() {
        let els = $('#SelectedTasks').children();
        els.map(x => {
            $(els[x]).find('span[class="tasknum"]').text(x + 1);
        });
    }

    function FileInputInit() {
        //file input
        var inputs = document.querySelectorAll('.file-input')
        for (var i = 0, len = inputs.length; i < len; i++) {
            customInput(inputs[i])
        }
        function customInput(el) {
            const fileInput = el.querySelector('[type="file"]')
            const label = el.querySelector('[data-js-label]')

            fileInput.onchange = fileInput.onmouseout = function () {
                if (!fileInput.value) return

                var value = fileInput.value.replace(/^.*[\\\/]/, '')
                el.className += ' -chosen'
                label.innerText = value
            }
        }

    }

    function AttachEventsForABTable() {
        //attach event to table with abonents
        $('#tableWithJobsAbonents tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedLinked = null;
            }
            else {
                selectedLinked = $(this).find('td[data-name="ID"]').text();
                $('#tableWithJobsAbonents tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            $('#SelectLinkedAbonent').attr('disabled', (selectedLinked === null));
        });
    }

    function LoadTableWithAbonents(e) {
        //load table with aboents
        $('#AbonentsAB').load("/TariscopeTasks/SearchAbonents/?s=" + encodeURIComponent(e), function () {
            AttachEventsForABTable();
            if ($('#linked_ab').val() !== "0") {
                $($('#AbonentsAB tbody tr[data-id="' + $('#linked_ab').val() + '"]')[0]).addClass('selected');
                selectedLinked = $('#linked_ab').val();
            }
            $('#SelectLinkedAbonent').attr('disabled', (selectedLinked === null));
            ShowSpinner(false);
            $('#selectLinkedABmodal').modal('show');
        });
    }

    function UpdateSQLListButtons() {
        if ($('#AbonentListType').val() == 0) {
            $('#btnClearSource').hide();
            $('#btnEditSource').hide();
            $('#btnEditSql_report').show();
        }
        else {
            $('#btnEditSql_report').hide();
            $('#btnClearSource').show();
            $('#btnEditSource').show();
        }
    }

    function RemoveFromArray(array, element) {
        //remove element form array
        const index = array.indexOf(element);

        if (index !== -1) {
            array.splice(index, 1);
        }
    }

    function AttachEventsForSDTables() {

        if ($('#AbonentsListAlternative').val()) {
            selectedSDHidden = $('#AbonentsListAlternative').val().split(',');

            for (var i = 0; i < selectedSDHidden.length; i++) {

                var row = $('#tariscope-SDD tbody td[data-name="SDDataHidden"]').filter(function () {
                    return $(this).text() * 1 == selectedSDHidden[i];
                }).closest("tr");

                row.addClass('selected');
            }
        }
        else {
            selectedSDHidden = [];
        }

        //attach events to table with destinationa and source
        $('#tariscope-SDD tbody').on('click', 'tr', function () {
            let hidden = $(this).find('td[data-name="SDDataHidden"]').text();

            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');

                RemoveFromArray(selectedSDHidden, hidden);
            }
            else {
                if ($(this).data('name') !== 'SDDataNonSelect') {
                    selectedSDHidden.push(hidden);
                    $(this).addClass('selected');
                }
            }
        });

        let inputs = $('#tariscope-SDD').find('input');

        if (inputs.length) {
            let search = $(inputs[0]);
            search.val('');
            search.unbind();
            search.on('input', () => {
                let str = search.val();

                if (!str || !str.trim()) {
                    $('#tariscope-SDD').find('tbody').find('tr').each(function () {
                        $(this).show();
                    });
                }
                else {
                    $('#tariscope-SDD').find('tbody').find('tr').each(function () {
                        if ($(this).find('td[data-name="SDDataDisplay"]').text().toLowerCase().includes(str.toLowerCase())) {
                            $(this).show();
                        }
                        else {
                            $(this).hide();
                        }
                    });
                }
            });
        }
    }

    function LoadAbonents() {
        //load abonents
        $('#AbonentSourceTitle').text($('#txtAbonents').val());

        $('#AbonentSourceBody').load('/TariscopeViews/GetAbonents/?devices=' + encodeURIComponent($('#txtDevices').val()), function () {
            AttachEventsForSDTables();
            ShowSpinner(false);
            $('#AbonentSourceModal').modal('show');
        });
    }

    function LoadDepartments() {
        //load departments
        $('#AbonentSourceTitle').text($('#txtDepartments').val());

        $('#AbonentSourceBody').load('/TariscopeViews/GetDepartments/?devices=' + encodeURIComponent($('#txtDevices').val()), function () {
            AttachEventsForSDTables();
            ShowSpinner(false);
            $('#AbonentSourceModal').modal('show');
        });
    }

    function InitReportSelect() {
        $("#Reports").select2({
            placeholder: $('#SelectReportPlaceholder').val(),
            allowClear: false,
            tags: false,
            multiple: false
        });
    }

    function AttachEvents() {
        //load section for action type
        $('#listAction').change(function () {
            LoadSection($(this).val());
            CheckSQLListBtn();
        });

        //open modal for edit selected filter
        $('#btnExitFilter_report').on('click', function () {
            isEditSQL = false;
            $('#editFilterName').html($('#listFilters_Report').val());
            $('#editSqlmodal').modal('show');
            $('#modalEditorBody').load("/TariscopeTasks/GetSQLEditor/?filtername=" + encodeURIComponent($('#listFilters_Report').val()));
        });
        $('#btnExitFilter_calls').on('click', function () {
            $('#editFilterName').html($('#listFilters_calls').val());
            $('#editSqlmodal').modal('show');
            $('#modalEditorBody').load("/TariscopeTasks/GetSQLEditor/?filtername=" + encodeURIComponent($('#listFilters_calls').val()));
        });

        //confirm save custom filter
        $('#modalButtonSaveSqlFilter').on('click', function () {
            window.SQLEditor.save();
            if (isEditSQL) {
                isEditSQL = false;
                $('#sql_ab').val($('#CodeMirrorTextArea').val());
                $('#editSqlmodal').modal('hide');
            }
            else {
                $.ajax({
                    type: "POST",
                    async: true,
                    url: '/TariscopeTasks/SaveCustomFilter/?filter=' + encodeURIComponent($('#CodeMirrorTextArea').val()),
                    traditional: true,
                    success: function (response) {
                        $('#listFilters_Report :nth-child(2)').prop('selected', true);
                        $('#listFilters_calls :nth-child(2)').prop('selected', true);
                        $('#editSqlmodal').modal('hide');
                    }
                });
            }
        });

        //some checked update uis
        $('#listFilters_Report').change(CheckFilter1);
        $('#listFilters_calls').change(CheckFilter2);
        $('#SeparateAbonents').change(function () {
            CheckUserSeparate();
            CheckSendFile();
        });
        $('#DocumentUpload').change(CheckSendFile);

        //place selected mask into input
        $('a[id="report_mask"]').on('click', function () {
            $('#reportFileMask').val($(this).html());
        });
        $('a[id="backup_mask"]').on('click', function () {
            $('#BackupName').val($(this).html());
        });
        $('a[id="ts_archive"]').on('click', function () {
            $('#CallBackupMask').val($(this).html());
        });

        //clear or setup current time to next date field
        $('#IsActive').change(function () {
            if ($(this).prop('checked') === true) {
                try {
                    $('#datetimepicker').data("DateTimePicker").setDate(new Date());
                } catch (e) { console.log(e); }
            }
            else {
                try {
                    $('#datetimepicker').data("DateTimePicker").setDate(null);
                } catch (e) { console.log(e); }
            }

        });

        //open reports modal
        $('#selectReportBtn').on('click', LoadReports);

        //load information for selected report
        $('#Reports').change(function () {
            LoadReportInfo();
        });

        //confirm selected new report
        $('#modalButtonSelectReport').on('click', function () {
            let v = GetVariablesJsonString();
            let r = $('#Reports').val();

            $('#listTypes').val($('#reportCurrentType').val());
            $('#GroupOfTasks').val(`${$('#reportCurrentOrient').val()}|${$('#reportCurrentPageFormat').val()}|${$('#reportCurrentMarignLeft').val()}|${$('#reportCurrentMarignRight').val()}|${$('#reportCurrentMarignTop').val()}|${$('#reportCurrentMarignBottom').val()}`);

            $('#SavedVars').val(v);
            $('#ReportName').val(r);
            $('#selectReportmodal').modal('hide');
        });

        //disable or enable panel for enter proxy server
        $('#CPUseProxy').change(function () {
            if ($(this).prop('checked'))
                $('#ProxyDiv').removeClass('disDiv');
            else
                $('#ProxyDiv').addClass('disDiv');
        });

        //events for table with curency profile codes (select/unselect)
        $('#tableWithProfiles tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedCPCode = null;
            }
            else {
                selectedCPCode = $(this).find('td[data-name="Code"]').text();
                $('#tableWithProfiles tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateCodeTableButtonsUI();
        });

        //create new currency profile or load selected
        $('#editcurrency, #addcurrency').on('click', function () {
            if ($('#listCurrencyProfiles').val() === '-1') {//new
                $('#addcurrencyprofiletitle').attr('hidden', false);
                $('#editcurrencyprofiletitle').attr('hidden', true);

                //create empty currency profile
                $.ajax({
                    type: "POST",
                    async: true,
                    url: '/TariscopeTasks/CreateEmptyCurrencyProfile/',
                    traditional: true,
                    success: function (response) {
                        if (response !== null && response.success === true) {
                            $('#CPName').val("");
                            $('#CPUseProxy').prop('checked', false);
                            $('#CPProxyServer').val("");
                            $('#CPProxyServerLogin').val("");
                            $('#CPProxyServerPass').val("");
                            ShowCurCodeTable(false);

                            $('#saveCurrencyProfile').attr('disabled', true);

                            $('#EditCurrencyProfileSection').slideDown('fast');
                        }
                    }
                });


            }
            else {//edit
                $('#addcurrencyprofiletitle').attr('hidden', true);
                $('#editcurrencyprofiletitle').attr('hidden', false);

                $('#lblCurProf').html($('#listCurrencyProfiles').val());

                //load info about selected profile
                $.ajax({
                    type: "POST",
                    async: true,
                    url: '/TariscopeTasks/LoadCurrencyProfile/?name=' + $('#listCurrencyProfiles').val(),
                    traditional: true,
                    success: function (response) {
                        if (response !== null && response.success === true) {

                            $('#CPName').val($('#listCurrencyProfiles').val());
                            $('#CPUseProxy').prop('checked', response.SelectedCurrencyProfile.UseProxy);
                            $('#CPProxyServer').val(response.SelectedCurrencyProfile.ProxyURL);
                            $('#CPProxyServerLogin').val(response.SelectedCurrencyProfile.ProxyUser);
                            $('#CPProxyServerPass').val(response.SelectedCurrencyProfile.ProxyPassword);
                            FillCPCodesTable(response.SelectedCurrencyProfile.Elements);

                            $('#saveCurrencyProfile').attr('disabled', false);

                            $('#EditCurrencyProfileSection').slideDown('fast');
                        }
                    }
                });
            }
        });

        //hide section for edit if selected other profile or clicked cancel
        $('#listCurrencyProfiles').change(function () {
            selectedCPCode = null;
            UpdateCodeTableButtonsUI();
            CheckButtonsForCP();
            $('#EditCurrencyProfileSection').slideUp('fast');
        });
        $('#cancelEditCurrency').on('click', function () {
            selectedCPCode = null;
            UpdateCodeTableButtonsUI();
            $('#EditCurrencyProfileSection').slideUp('fast');
        });

        //show modal for add new code for selected profile
        $('#btnAddCurrencyCode').on('click', function () {
            $('#addCPCodeTitle').attr('hidden', false);
            $('#editCPCodeTitle').attr('hidden', true);

            $('#CPCodeName').val('NEW');
            $('#CPCodeSplitter').val('.');
            $('#CPCodeFactor').val('1');
            $('#CPCodeURL').val('');
            $('#CPCodeSK1').val('');
            $('#CPCodeSK2').val('');
            $('#CPCodeRegExp').val('');
            $('#CPCodeEK').val('');

            selectedCPCode = null;
            $('#tableWithProfiles tr.selected').removeClass('selected');
            UpdateCodeTableButtonsUI();

            $('#modalEditCPCOdeConfirm').attr('disabled', false);

            $('#editCurrencymodal').modal('show');
        });

        //show modal for edit selected cp code
        $('#btnEditCurrencyCode').on('click', function () {
            $('#addCPCodeTitle').attr('hidden', true);
            $('#editCPCodeTitle').attr('hidden', false);
            $('#lblCPCode').html(selectedCPCode);

            //load info about selected profile
            $.ajax({
                type: "POST",
                async: true,
                url: '/TariscopeTasks/LoadCurrencyProfileCode/?code=' + selectedCPCode,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#CPCodeName').val(response.element.CurrencyCode);
                        $('#CPCodeSplitter').val(response.element.FloatingPointChar);
                        $('#CPCodeFactor').val(response.element.Factor);
                        $('#CPCodeURL').val(response.element.Url);
                        $('#CPCodeSK1').val(response.element.Startkey1);
                        $('#CPCodeSK2').val(response.element.Startkey2);
                        $('#CPCodeRegExp').val(response.element.RegExMatch);
                        $('#CPCodeEK').val(response.element.EndKey);

                        $('#modalEditCPCOdeConfirm').attr('disabled', false);

                        $('#editCurrencymodal').modal('show');
                    }
                }
            });
        });

        //confirm save or add new cp code
        $('#modalEditCPCOdeConfirm').on('click', function () {
            //load info about selected profile

            var url = '?IsEdit=' + (selectedCPCode !== null) +
                '&oldCode=' + selectedCPCode + '&newCode=' + $('#CPCodeName').val() +
                '&splitter=' + encodeURIComponent($('#CPCodeSplitter').val()) +
                '&factor=' + encodeURIComponent($('#CPCodeFactor').val()) +
                '&url=' + encodeURIComponent($('#CPCodeURL').val()) +
                '&sk1=' + encodeURIComponent($('#CPCodeSK1').val()) +
                '&sk2=' + encodeURIComponent($('#CPCodeSK2').val()) +
                '&reg=' + encodeURIComponent($('#CPCodeRegExp').val()) +
                '&ek=' + encodeURIComponent($('#CPCodeEK').val());

            $.ajax({
                type: "POST",
                async: true,
                url: '/TariscopeTasks/EditCPCode/' + url,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        FillCPCodesTable(response.SelectedCurrencyProfile.Elements);

                        selectedCPCode = null;
                        UpdateCodeTableButtonsUI();

                        $('#editCurrencymodal').modal('hide');
                    }
                }
            });
        });

        //show modal for delete cp item
        $('#btnDeleteCurrencyCode').on('click', function () {
            $('#confirmDeleteCP').modal('show');
        });

        //show modal for delete profile
        $('#deletecurrency').on('click', function () {
            $('#confirmDeleteProfile').modal('show');
        });

        //confirm delete cp code
        $('#DeleteConfirmCP').on('click', function () {
            $.ajax({
                type: "POST",
                async: true,
                url: '/TariscopeTasks/DeleteCPCode/?code=' + selectedCPCode,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        FillCPCodesTable(response.SelectedCurrencyProfile.Elements);
                        selectedCPCode = null;
                        UpdateCodeTableButtonsUI();
                        $('#confirmDeleteCP').modal('hide');
                    }
                }
            });
        });

        //confirm delete selected profile
        $('#DeleteConfirmPR').on('click', function () {
            $.ajax({
                type: "POST",
                async: true,
                url: '/TariscopeTasks/DeleteCPProfile/?name=' + encodeURIComponent($('#listCurrencyProfiles').val()),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {

                        $('#listCurrencyProfiles').empty();

                        $('#listCurrencyProfiles').append('<option value="-1">' + $('#createNewCurrencyProfileText').val() + '</option>');
                        $('#listCurrencyProfiles').append('<optgroup label="——————————"></option>');

                        response.profiles.forEach(function (e) {
                            $('#listCurrencyProfiles').append('<option value="' + e + '">' + e + '</option>');
                        });

                        $('#listCurrencyProfiles').val('-1');
                        CheckButtonsForCP();

                        $('#EditCurrencyProfileSection').slideUp('fast');
                        $('#confirmDeleteProfile').modal('hide');
                    }
                }
            });
        });

        //confirm save currency profile
        $('#saveCurrencyProfile').on('click', function () {

            var url = '?name=' + encodeURIComponent($('#CPName').val()) +
                '&proxy=' + $('#CPUseProxy').prop('checked') +
                '&server=' + encodeURIComponent($('#CPProxyServer').val()) +
                '&login=' + encodeURIComponent($('#CPProxyServerLogin').val()) +
                '&password=' + encodeURIComponent($('#CPProxyServerPass').val());

            $.ajax({
                type: "POST",
                async: true,
                url: '/TariscopeTasks/SaveCPProfile/' + url,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {

                        $('#listCurrencyProfiles').empty();

                        $('#listCurrencyProfiles').append('<option value="-1">' + $('#createNewCurrencyProfileText').val() + '</option>');
                        $('#listCurrencyProfiles').append('<optgroup label="——————————"></option>');

                        response.profiles.forEach(function (e) {
                            $('#listCurrencyProfiles').append('<option value="' + e + '">' + e + '</option>');
                        });

                        $('#listCurrencyProfiles').val(response.name);
                        CheckButtonsForCP();

                        $('#EditCurrencyProfileSection').slideUp('fast');
                    }
                }
            });
        });

        //if profile name is empty disable save button and show msg
        $('#CPName').on('input', function () {
            if (!$(this).val() || !$(this).val().trim()) {
                $('#nameEmpty').slideDown('fast');
                $('#saveCurrencyProfile').attr('disabled', true);
            }
            else {
                $('#nameEmpty').slideUp('fast');
                $('#saveCurrencyProfile').attr('disabled', false);
            }
        });

        //if cp code is empty disable save button and show msg
        $('#CPCodeName').on('input', function () {
            if (!$(this).val() || !$(this).val().trim()) {
                $('#codeEmpty').slideDown('fast');
                $('#modalEditCPCOdeConfirm').attr('disabled', true);
            }
            else {
                $('#codeEmpty').slideUp('fast');
                $('#modalEditCPCOdeConfirm').attr('disabled', false);
            }
        });

        //export selected currency profile
        $('#exportcurrency').on('click', function () {
            window.open('/TariscopeTasks/ExportProfile/?name=' + $('#listCurrencyProfiles').val(), '_blank');
        });

        //show modal for import currency profile
        $('#importcurrency').on('click', function () {
            $('#emptyFile').slideUp();
            $('#importProfileModal').modal('show');
        });

        //show nbu help
        $('#nbu').on('click', () => { $('#NBUDescriptionModal').modal('show'); });

        //confirm import currency profile
        $('#ImportConfirmBtn').on('click', function () {
            var data = new FormData();
            var file = ($("#FileInput"))[0].files[0];

            if (file !== null) {
                data.append('.xml', file);
                $('#importProfileModal').modal('hide');
                ShowSpinner(true);

                $.ajax({
                    type: "POST",
                    async: true,
                    url: '/TariscopeTasks/ImportProfile/',
                    data: data,
                    datatype: 'json',
                    contentType: false,
                    processData: false,
                    traditional: true,
                    success: function (response) {
                        ShowSpinner(false);
                        if (response !== null && response.success === true) {
                            $('#listCurrencyProfiles').empty();

                            $('#listCurrencyProfiles').append('<option value="-1">' + $('#createNewCurrencyProfileText').val() + '</option>');
                            $('#listCurrencyProfiles').append('<optgroup label="——————————"></option>');

                            response.profiles.forEach(function (e) {
                                $('#listCurrencyProfiles').append('<option value="' + e + '">' + e + '</option>');
                            });

                            $('#listCurrencyProfiles').val(response.name);
                            CheckButtonsForCP();
                        }
                        else {
                            $('#importProfileModal').modal('show');
                            $('#emptyFile').slideDown('fast');
                        }
                    }
                });
            }
            else {
                $('#emptyFile').slideDown('fast');
            }
        });

        //open modal for setting print
        $('#PrintSetBtn').on('click', function () {
            $.ajax({
                type: "POST",
                async: true,
                url: '/TariscopeTasks/GetPrinterSettings/',
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#AdobeReaderPath').val(response.arcord);

                        if (!$('#AdobeReaderPath').val() || !$('#AdobeReaderPath').val().trim()) {
                            $('#SavePrinterSettingsBtn').attr('disabled', true);
                        }
                        else {
                            $('#SavePrinterSettingsBtn').attr('disabled', false);
                        }

                        $('#PrintersList').empty();
                        response.printers.forEach(function (e) {
                            $('#PrintersList').append('<option value="' + e + '">' + e + '</option>');
                        })
                        $('#PrintersList').val(response.selected);

                        $('#settingPrintmodal').modal('show');
                    }
                }
            });
        });

        //save printer settings
        $('#SavePrinterSettingsBtn').on('click', function () {
            $.ajax({
                type: "POST",
                async: true,
                url: '/TariscopeTasks/SavePrinterSettings/?path=' + encodeURIComponent($('#AdobeReaderPath').val()) + '&printer=' + encodeURIComponent($('#PrintersList').val()),
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#settingPrintmodal').modal('hide');
                    }
                }
            });
        });

        //show message if empty acrord path
        $('#AdobeReaderPath').on('input', function () {
            if (!$(this).val() || !$(this).val().trim()) {
                $('#emptyAcrord').slideDown('fast');
                $('#SavePrinterSettingsBtn').attr('disabled', true);
            }
            else {
                $('#emptyAcrord').slideUp('fast');
                $('#SavePrinterSettingsBtn').attr('disabled', false);
            }
        });

        //show modal for edit sql abonents list
        $('#btnEditSql_report').on('click', function () {
            isEditSQL = true;
            $('#editFilterName').html($('#SQLListTitle').val());
            $('#editSqlmodal').modal('show');
            $('#modalEditorBody').load("/TariscopeTasks/GetSQLEditorForGroup/?sql=" + encodeURIComponent($('#sql_ab').val()));
        });

        //show modal with abonents
        $('#SelectLinkedUser').on('click', function () {
            ShowSpinner(true);
            $('#tbSearchAB').val('');
            LoadTableWithAbonents('');
        });

        //apply selected linked abonent
        $('#SelectLinkedAbonent').on('click', function () {
            if (selectedLinked === null)
                $('#linked_ab').val('');
            else
                $('#linked_ab').val(selectedLinked);

            $('#selectLinkedABmodal').modal('hide');
        });

        //show name help
        $('#btnShowNameMaskHelp').on('click', () => { $('#NameMaskHelperModal').modal('show'); });

        //setup before functions
        var typingTimer;                //timer identifier
        var doneTypingInterval = 700;   //time in ms, 0.75 second for example
        var $input = $('#tbSearchAB');

        //on keyup, start the countdown
        $input.on('keyup', function () {
            clearTimeout(typingTimer);
            typingTimer = setTimeout(function () {
                LoadTableWithAbonents($('#tbSearchAB').val());
            }, doneTypingInterval);
        });
        //on keydown, clear the countdown
        $input.on('keydown', function () { clearTimeout(typingTimer); });

        //show modal to add a task to group
        $('#btnAddTask').on('click', () => {
            $('#TasksToAddModal').modal('show');

            //add task
            $('#ConfirmSelectedTask').unbind();
            $('#ConfirmSelectedTask').on('click', AddGroupedTask);
        });

        //move top task in group
        $('#btnMoveTcxFieldTop').on('click', function () {
            let CurrentElement = $(this).parent().parent();
            let PrevElement = $(this).parent().parent().prev();

            if (PrevElement.length > 0) {
                $(CurrentElement).insertBefore($(PrevElement));
                RecalculateOrderGroupedTasks();
            }
        });

        //mode down task in group
        $('#btnMoveTcxFieldDown').on('click', function () {
            let CurrentElement = $(this).parent().parent();
            let NextElement = $(this).parent().parent().next();

            if (NextElement.length > 0) {
                $(CurrentElement).insertAfter($(NextElement));
                RecalculateOrderGroupedTasks();
            }
        });

        //delete task from gorup
        $('#btnDeleteTcxField').on('click', function () {
            let CurrentElement = $(this).parent().parent();
            $('#TaskgroupButtonsContainer').append($(this).parent());
            CurrentElement.remove();

            if ($('div[data-task]').length == 0) {
                $('#SelectedTasks').empty();
                $('#SelectedTasks').append(`<div class="well well-sm"><div class="text-center">${$('#EmptyLbl').val()}</div></div>`);
            }

            RecalculateOrderGroupedTasks();
        });

        //show modal to update the task
        $('#btnEditTcxField').on('click', function () {
            let CurrentElement = $(this).parent().parent();
            $('#TaskgroupButtonsContainer').append($(this).parent());

            groupedTaskToEdit = CurrentElement.data('task');
            $('#TasksToAddList').val(groupedTaskToEdit);

            $('#TasksToAddModal').modal('show');

            $('#ConfirmSelectedTask').unbind();
            $('#ConfirmSelectedTask').on('click', EditGroupedTask);
        });

        //clear all tasks
        $('#btnDeleteAllTask').on('click', () => {
            $('#TaskgroupButtonsContainer').append($('#btnsTopDown'));
            $('#SelectedTasks').empty();
            $('#SelectedTasks').append(`<div class="well well-sm"><div class="text-center">${$('#EmptyLbl').val()}</div></div>`);
        });

        //validate model on server side
        $('#JobsForm').submit(function () {
            var fields = {};

            switch ($('#listAction').val() * 1) {

                case 0://report
                    fields['ReportName'] = $('#ReportName').val();
                    fields['ReportPath'] = $('#reportPath').val();
                    fields['ReportMask'] = $('#reportFileMask').val();
                    fields['IsNeedLinked'] = $('#DocumentUpload').prop('checked') && !$('#SeparateAbonents').prop('checked');
                    if (fields['IsNeedLinked'])
                        fields['LinkedAbonent'] = $('#linked_ab').val();
                    break;
                case 1://full backup
                case 2://non full backup
                    fields['BackupName'] = $('#BackupName').val();
                    fields['BackupPath'] = $('#BackupPath').val();
                    break;
                case 3://call archive
                    fields['ArchiveName'] = $('#CallBackupMask').val();
                    fields['ArchivePath'] = $('#CallBackupPath').val();
                    break;
                case 4://update currency
                    fields['Profile'] = $('#listCurrencyProfiles').val();
                    break;
                case 5://active directory
                    fields['Profile'] = $('#ADProfiles').val();
                    break;
                case 6://charger
                    //empty, dont need validation on server side
                    break;
                case 7://run app
                    fields['EXEPath'] = $('#EXEPathInput').val();
                    break;
                case 8://group
                    let tasks = [];
                    let els = $('#SelectedTasks').find('div[data-task]')
                    els.map(x => {
                        tasks.push($(els[x]).data('task'));
                    });
                    $('#GroupOfTasks').val(tasks.join(','));
                    break;
                case 9://newsletter
                    fields['SQL'] = $('#sql_ab').val();
                    fields['Source'] = $('#AbonentListType').val();
                    break;
                default:
                    break;
            }

            var res = false;

            $.ajax({
                type: "POST",
                async: false,
                url: '/TariscopeTasks/ValidateJob/?type=' + $('#listAction').val() + '&fields=' + encodeURIComponent(JSON.stringify(fields)),
                traditional: true,
                success: function (response) {
                    if (response !== null) {
                        if (!response.success) {//validation is not ok, show errors
                            $('#errors_list').empty();
                            response.Errors.forEach(function (e) {
                                $("#errors_list").append('<li>' + e + '</li>');
                            });

                            $('#validateErrorsmodal').modal('show');

                            //return false;
                        }
                    }
                    res = response.success;
                }
            });

            return res;
        });

        //update sql list buttons
        $('#AbonentListType').change(() => {
            UpdateSQLListButtons();
            $('#AbonentsListAlternative').val('');
            selectedSDHidden = [];
        });

        //show modal to select abonents or groups
        $('#btnEditSource').on('click', () => {
            ShowSpinner(true);

            let val = $('#AbonentListType').val() * 1;

            if (val == 1) {
                LoadAbonents();
            }
            else if (val == 2) {
                LoadDepartments();
            }
        });

        //clear source
        $('#btnClearSource').on('click', () => { $('#AbonentsListAlternative').val(''); });

        //apply selectd groups
        $('#AbonentSourceBtn').on('click', () => { $('#AbonentsListAlternative').val(selectedSDHidden.join()); });
    }

    ShowTitle();
    AttachEvents();
    LoadSection($('#listAction').val());
    initDateTimePicker();
    CheckFilter1();
    CheckFilter2();
    CheckUserSeparate();
    CheckSendFile();
    CheckButtonsForCP();
    CheckSQLListBtn();
    FixOptGroup();
    FileInputInit();
    LoadGroupedTasks();
    UpdateSQLListButtons();
});