﻿$(document).ready(function () {
    let SelectedView = null;
    let OwnerName = null;
    let Group = null;
    let OwnerType = null;
    let ViewType = null;
    let ViewName = null;

    let FiltersSource = 0;

    let SQLFilter = '';
    FixedHeader();


    function FixedHeader() {
        var header = document.getElementById("viewsheader");                 //for sticky header
        var sticky = header.offsetTop;
        $(window).on("scroll", function ()
        {
            //for sticky header
            if (window.pageYOffset > (sticky + 100))
            { header.classList.add("sticky"); }
            else
            { header.classList.remove("sticky"); }
        });
    }

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/TariscopeViews/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/TariscopeViews/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("The export failed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateButtons() {
        //update ui when selected or not
        $("#btnShareTo").attr("disabled", !(OwnerType === "Your" || OwnerType === "Other"));
        $("#btnShareFrom").attr("disabled", !(OwnerType === "Share"));
        $("#btnDelete").attr("disabled", !(OwnerType !== null && OwnerType !== "SoftPi"));
        $("#btnEdit").attr("disabled", !(OwnerType !== null && OwnerType !== "SoftPi"));
        $("#btnOpen").attr("disabled", (SelectedView === null));
        $("#btnMoveToGroup").attr("disabled", OwnerType !== "Your");
    }

    function RowClick(e) {
        if (e.hasClass('selected')) {
            e.removeClass('selected');
            SelectedView = null;
            OwnerName = null;
            OwnerType = null;
            ViewType = null;
            Group = null;
            ViewName = null;
        }
        else {
            var last = SelectedView;
            SelectedView = e.find('td[data-name="ID"]').text();

            if (!SelectedView || !SelectedView.trim()) {
                SelectedView = last;
            }
            else {
                OwnerName = e.find('td[data-name="Owner"]').text();
                OwnerType = e.find('td[data-name="OW"]').text();
                ViewType = e.find('td[data-name="Type"]').text();
                Group = e.find('td[data-name="GR"]').text();
                ViewName = e.find('td[data-name="Name"]').text();

                $('#tariscope-views tr.selected').removeClass('selected');
                e.addClass('selected');
            }
        }
        UpdateButtons();
    }

    function AttachEventsToTable() {
        SelectedView = null;
        OwnerName = null;
        OwnerType = null;
        ViewType = null;
        Group = null;
        ViewName = null;

        //attach events for select
        $('#tariscope-views tbody').on('click', 'tr', function () { RowClick($(this)); });
        $('#tariscope-views tbody').on('dblclick', 'tr', function () {
            RowClick($(this));
            if (SelectedView != null)
                $('#btnOpen').click();
        });

        UpdateButtons();
        ShowSpinner(false);
    }

    function LoadViews(e) {
        //load views
        if (!e || !e.trim())
            ShowSpinner(true);

        $('#viewsTable').load("TariscopeViews/Get/?search=" + encodeURIComponent(e), AttachEventsToTable);
    }

    function SetEventsForSQLEditor() {
        window.SQLEditor.on("change", () => {
            $('#btnSavefilter').show();
        });
    }

    function LoadSQLEditor() {
        //load sql for selected filter
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/GETSQLForFilter/?type=' + FiltersSource + '&name=' + encodeURIComponent($('#filtersList').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#sqlContainer').load("/TariscopeViews/GetSQLEditor/?sql=" + encodeURIComponent(response.sql), function () {
                        ShowSpinner(false);
                        SetEventsForSQLEditor();
                        $('#SQLEditor').modal('show');
                    });
                }
            }
        });
    }

    function LoadFilters() {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/GetFilters/?type=' + FiltersSource,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#filtersList').empty();

                    response.filters.map(function (e) {
                        $('#filtersList').append('<option value="' + e.Name + '">' + e.Name + '</option>');
                    });

                    $('#filtersList').val($('option:first', $('#filtersList')).val());

                    LoadSQLEditor();
                }
            }
        });
    }

    function InitTrunksSelect2() {
        $('#trunksForGraph').select2({ theme: "bootstrap", placeholder: $('#TrafficCalculateSelectRoutes').val() });
    }

    function InitViewsSelect2() {
        $('#viewsForGraph').select2({ theme: "bootstrap", placeholder: $('#TrafficCalculateSelectViews').val() });
    }

    function initDateTimepickers() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepicker').datetimepicker(daytimeOpitions);
    }

    function initDateTimepickersRecharge() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerFromBGREcharge').datetimepicker(daytimeOpitions);
        $('#datetimepickerToBGREcharge').datetimepicker(daytimeOpitions);
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            LoadViews($('#tbSearch').val());
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //add new view
    $('#btnAddCalls').on('click', function () {
        window.location.href = "TariscopeViews/NewCallsFilter/"
    });

    //open view
    $('#btnOpen').on('click', function () {
        if (ConvertViewTypeModelToInt(ViewType) == 3) {
            window.location.href = "/ProviderViews/Open?Name=" + encodeURIComponent(SelectedView) +
                '&OwnerType=' + ConvertViewOnwerModelToInt(OwnerType) +
                '&OwnerName=' + encodeURIComponent(OwnerName) +
                '&Group=' + encodeURIComponent(Group);
        }
        else {
            window.location.href = "/TariscopeViews/Open/?Name=" + encodeURIComponent(SelectedView) +
                '&Type=' + ConvertViewTypeModelToInt(ViewType) +
                '&OwnerType=' + ConvertViewOnwerModelToInt(OwnerType) +
                '&OwnerName=' + encodeURIComponent(OwnerName) +
                '&Group=' + encodeURIComponent(Group);
        }
    });

    //show dialog for delete view
    $('#btnDelete').on('click', function () {
        $('#confirmDelete').modal('show');
    });

    //confirmation of the view deletion
    $('#DeleteConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/Delete/?ViewName=' + encodeURIComponent(SelectedView) +
                '&OwnerName=' + encodeURIComponent(OwnerName) +
                '&OwnerType=' + ConvertViewOnwerModelToInt(OwnerType) +
                '&ViewType=' + ViewType +
                '&Group=' + encodeURIComponent(Group),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    var tableRow = $('td[data-name="ID"]').filter(function () { return $(this).text() === SelectedView; }).closest("tr");
                    $(tableRow).remove();
                    SelectedView = null;
                    OwnerName = null;
                    OwnerType = null;
                    ViewType = null;
                    Group = null;
                    ViewName = null;
                    UpdateButtons();
                    $('#confirmDelete').modal('hide');
                }
            }
        });
    });

    //open modal for confrim share view
    $('#btnShareTo').on('click', function () {
        $('#confirmSahre').modal('show');
    });

    //confirmation to share
    $('#ShareConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/Share/?ViewName=' + encodeURIComponent(SelectedView) +
                '&OwnerName=' + encodeURIComponent(OwnerName) +
                '&OwnerType=' + ConvertViewOnwerModelToInt(OwnerType) +
                '&ViewType=' + ViewType +
                '&Group=' + encodeURIComponent(Group),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadViews($('#tbSearch').val());
                    $('#confirmSahre').modal('hide');
                }
            }
        });
    });

    //open modal for copy from share view
    $('#btnShareFrom').on('click', function () {
        $('#emptyName').hide();
        $('#CopyShareConfirm').prop('disabled', false);
        $('#newNameForView').val(SelectedView);
        $('#copyShare').modal('show');
    });

    //show error when new name of view is empty
    $('#newNameForView').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyName').slideDown('fast');
            $('#CopyShareConfirm').attr('disabled', true);
        }
        else {
            $('#emptyName').slideUp('fast');
            $('#CopyShareConfirm').attr('disabled', false);
        }
    });

    //confirmation of copy
    $('#CopyShareConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/Copy/?ViewName=' + encodeURIComponent(SelectedView) +
                '&NewName=' + encodeURIComponent($('#newNameForView').val()) +
                '&OwnerName=' + encodeURIComponent(OwnerName) +
                '&ViewType=' + ViewType +
                '&OwnerType=' + ConvertViewOnwerModelToInt(OwnerType),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadViews($('#tbSearch').val());
                    $('#copyShare').modal('hide');
                }
            }
        });
    });

    //editing of the selected view
    $('#btnEdit').on('click', function () {
        if (ConvertViewTypeModelToInt(ViewType) == 3) {
            window.location.href = "/ProviderViews/Open?Name=" + encodeURIComponent(SelectedView) +
                '&OwnerType=' + ConvertViewOnwerModelToInt(OwnerType) +
                '&OwnerName=' + encodeURIComponent(OwnerName) +
                '&Group=' + encodeURIComponent(Group);
        }
        else {
            window.location.href = '/TariscopeViews/Edit/?ViewName=' + encodeURIComponent(SelectedView) +
                '&OwnerName=' + encodeURIComponent(OwnerName) +
                '&OwnerType=' + ConvertViewOnwerModelToInt(OwnerType) +
                '&Group=' + encodeURIComponent(Group);
        }
    });

    //open editor for services view
    $('#btnAddServices').on('click', () => { window.location.href = "TariscopeViews/NewServicesFilter/" });

    //open editor for ipv4
    $('#btnAddIPv4').on('click', () => { window.location.href = "TariscopeViews/NewIPv4Filter/" });

    //move to group open modal ===
    $('#btnMoveToGroup').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/GetGroups/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#groupsForMoving').empty();
                    $('#groupsForMoving').append($("<option value='-'>" + $('#LCWithoutGroup').val() + "</option>"));
                    $('#groupsForMoving').append($("<optgroup label='-'></optgroup>"));
                    response.groups.forEach((e) => {
                        $('#groupsForMoving').append($("<option value='" + e + "'>" + e + "</option>"));
                    });
                    $('#confirmMoveToGroup').modal('show');
                }
            }
        });
    });

    //confirm moving to group
    $('#MoveGroupConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/MoveView/?ViewName=' + encodeURIComponent(SelectedView) +
                '&OwnerName=' + encodeURIComponent(OwnerName) +
                '&OwnerType=' + ConvertViewOnwerModelToInt(OwnerType) +
                '&Group=' + encodeURIComponent(Group) +
                '&ViewType=' + ViewType +
                '&NewGroup=' + encodeURIComponent($('#groupsForMoving').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#confirmMoveToGroup').modal('hide');
                    LoadViews($('#tbSearch').val());
                }
            }
        });
    });

    //show modal for managament groups
    $('#btnGroupManagments').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/GetGroups/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#groupsForDeleting').empty();
                    $('#groupsForEditing').empty();

                    $('#groupDeleteAsk').hide();

                    response.groups.forEach((e) => {
                        $('#groupsForDeleting').append($("<option value='" + e + "'>" + e + "</option>"));
                        $('#groupsForEditing').append($("<option value='" + e + "'>" + e + "</option>"));
                    });
                    $('#managamentGroupsmodal').modal('show');
                }
            }
        });
    });

    //input new group name
    $('#AddNewGroup').on('input', function () {
        if (!$(this).val() || !$(this).val().trim() || $(this).val().indexOf('\\') > -1) {
            $('#btnAddNewgroup').addClass('disDiv');
        }
        else {
            $('#btnAddNewgroup').removeClass('disDiv');
        }
    });

    //add new group
    $('#btnAddNewgroup').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/AddGroup/?Group=' + encodeURIComponent($('#AddNewGroup').val()),
            traditional: true,
            success: function (response) {
                $('#AddNewGroup').val('');
                $('#btnAddNewgroup').addClass('disDiv');
                if (response !== null && response.success === true) {
                    $('#groupsForDeleting').append($("<option value='" + $('#AddNewGroup').val() + "'>" + $('#AddNewGroup').val() + "</option>"));
                    $('#groupsForEditing').append($("<option value='" + $('#AddNewGroup').val() + "'>" + $('#AddNewGroup').val() + "</option>"));
                    $('#groupAdded').slideDown('fast');
                    setTimeout(() => { $('#groupAdded').slideUp('fast'); }, 3000);
                }
                else {
                    $('#groupExists').slideDown('fast');
                    setTimeout(() => { $('#groupExists').slideUp('fast'); }, 3000);
                }
            }
        });
    });

    //delete selected group
    $('#btnDeletegroup').on('click', () => {
        if ($('#groupDeleteAsk').is(':visible')) {
            $.ajax({
                type: "POST",
                url: '/TariscopeViews/DeleteGroup/?Group=' + encodeURIComponent($('#groupsForDeleting').val()) + '&WithViews=' + $('#RemoveViewsTo').prop('checked'),
                traditional: true,
                success: function (response) {
                    $('#AddNewGroup').val('');
                    $('#groupDeleteAsk').slideUp('fast');

                    if (response !== null && response.success === true) {
                        $('option[value="' + $('#groupsForDeleting').val() + '"]', $('#groupsForDeleting')).remove();
                        $('#groupsForDeleting').val($('option:first', $('#groupsForDeleting')).val());

                        $('option[value="' + $('#groupsForEditing').val() + '"]', $('#groupsForEditing')).remove();
                        $('#groupsForEditing').val($('option:first', $('#groupsForEditing')).val());

                        $('#groupDeleted').slideDown('fast');
                        LoadViews($('#tbSearch').val());
                        setTimeout(() => { $('#groupDeleted').slideUp('fast'); }, 3000);
                    }
                    else {
                        $('#groupDontDeleted').slideDown('fast');
                        setTimeout(() => { $('#groupDontDeleted').slideUp('fast'); }, 3000);
                    }
                }
            });
        }
        else {
            $('#groupDeleteAsk').slideDown('fast');
        }
    });

    //show section for rename group
    $('#btnEditgroup').on('click', () => {
        if ($('#groupsForEditing').val()) {
            $('#sectionforRename').slideDown('fast');
            $('#RenameNewGroup').val($('#groupsForEditing').val());
        }
        else {
            $('#sectionforRename').slideUp('fast');
        }
    });

    //hide button for save new name for group
    $('#RenameNewGroup').on('input', function () {
        if (!$(this).val() || !$(this).val().trim() || $(this).val().indexOf('\\') > -1) {
            $('#btnRenamegroup').addClass('disDiv');
        }
        else {
            $('#btnRenamegroup').removeClass('disDiv');
        }
    });

    //confirm rename
    $('#btnRenamegroup').on('click', () => {
        $('#sectionforRename').slideUp('fast');

        let oldName = $('#groupsForEditing').val();
        let newName = $('#RenameNewGroup').val();

        if (oldName === newName) {
            $('#sectionforRename').slideUp('fast');
            $('#groupRenamed').slideDown('fast');
            setTimeout(() => { $('#groupRenamed').slideUp('fast'); }, 3000);
        }
        else {
            $.ajax({
                type: "POST",
                url: '/TariscopeViews/RenameGroup/?OldGroup=' + encodeURIComponent(oldName) + '&NewGroup=' + encodeURIComponent(newName),
                traditional: true,
                success: function (response) {
                    $('#AddNewGroup').val('');
                    if (response !== null && response.success === true) {
                        $('option[value="' + oldName + '"]', $('#groupsForDeleting')).remove();
                        $('#groupsForDeleting').append($("<option value='" + newName + "'>" + newName + "</option>"));
                        $('#groupsForDeleting').val($('option:first', $('#groupsForDeleting')).val());

                        $('option[value="' + oldName + '"]', $('#groupsForEditing')).remove();
                        $('#groupsForEditing').append($("<option value='" + newName + "'>" + newName + "</option>"));
                        $('#groupsForEditing').val(newName);

                        $('#groupRenamed').slideDown('fast');
                        LoadViews($('#tbSearch').val());
                        setTimeout(() => { $('#groupRenamed').slideUp('fast'); }, 3000);
                    }
                    else {
                        $('#groupDontRenamed').slideDown('fast');
                        setTimeout(() => { $('#groupDontRenamed').slideUp('fast'); }, 3000);
                    }
                }
            });
        }
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //swith filters
    $('#filtersList').change(function () {
        //load sql for selected filter

        $('#btnSavefilter').hide();
        $('#sqlContainer').addClass('disDiv');

        $.ajax({
            type: "POST",
            url: '/TariscopeViews/GETSQLForFilter/?type=' + FiltersSource + '&name=' + encodeURIComponent($('#filtersList').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#sqlContainer').load("/TariscopeViews/GetSQLEditor/?sql=" + encodeURIComponent(response.sql), function () {
                        SetEventsForSQLEditor();
                        $('#sqlContainer').removeClass('disDiv');
                    });
                }
            }
        });
    });

    //show calls filters
    $('#btnShowFiltersCalls').on('click', () => {
        $('#filtersModalTitle').text($('#SQLFiltersForCalls').val());
        FiltersSource = 0;
        $('#btnSavefilter').hide();
        ShowSpinner(true);
        LoadFilters();
    });

    //show services filters
    $('#btnShowFiltersServices').on('click', () => {
        $('#filtersModalTitle').text($('#SQLFiltersForServices').val());
        FiltersSource = 1;
        $('#btnSavefilter').hide();
        ShowSpinner(true);
        LoadFilters();
    });

    //show ip traffic filters
    $('#btnShowFiltersIPv4').on('click', () => {
        $('#filtersModalTitle').text($('#SQLFiltersForTraffic').val());
        FiltersSource = 2;
        $('#btnSavefilter').hide();
        ShowSpinner(true);
        LoadFilters();
    });

    //save edited filter
    $('#btnSavefilter').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/EditSQLFilter/?type=' + FiltersSource + '&Name=' + encodeURIComponent($('#filtersList').val()),
            traditional: true,
            data: { SQL: window.SQLEditor.getValue() },
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#filterSavedLbl').slideDown('fast');
                    setTimeout(() => { $('#filterSavedLbl').slideUp('fast'); }, 2500);
                    $('#btnSavefilter').hide();
                }
            }
        });
    });

    //open modal for find dublicates
    $('#btnFindDouble').on('click', () => {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/AccountSummary/GetNodesAndFilters',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#fdFilterSource').val('0');

                    $('#fdViewNotSelected').hide();
                    $('#fdViewSelected').hide();
                    $('#fdOtherFilterSection').hide();

                    $('#fdNodes').empty();
                    for (key in response.nodes) {
                        $('#fdNodes').append('<option value="' + key + '">' + response.nodes[key] + '</option>');
                    }

                    $('#fdFilterOther').empty();
                    for (key in response.filters) {
                        $('#fdFilterOther').append('<option value="' + response.filters[key].Name + '">' + response.filters[key].Name + '</option>');
                    }

                    let dt = new Date();
                    $('#fdYearSelect').val(dt.getFullYear() + '');
                    $('#fdMonthSelect').val(dt.getMonth() + 1 + '');

                    $("#fdAbonents").empty();
                    for (key in response.abonents) {
                        $('#fdAbonents').append('<option value="' + key + '">' + response.abonents[key] + '</option>');
                    }

                    $('#fdEnableMonth').prop('checked', false);
                    $('#fdMonthSection').addClass('disDiv');

                    setTimeout(() => { $("#fdAbonents").select2({ theme: "bootstrap" }); }, 300);

                    ShowSpinner(false);
                    $('#findDublicatesmodal').modal('show');
                }
            }
        });

    });

    //change filter source for find dublicates
    $('#fdFilterSource').change(function () {
        let index = $(this).val() * 1;

        switch (index) {

            case 0:
            default:
                $('#fdViewNotSelected').hide();
                $('#fdViewSelected').hide();
                $('#fdOtherFilterSection').hide();
                break;
            case 1:
                if (SelectedView === null || ViewType !== 'Calls') {
                    $('#fdViewNotSelected').slideDown('fast');
                    $('#fdViewSelected').hide();
                }
                else {
                    $('#fdselectedViewName').text(ViewName);
                    $('#fdViewNotSelected').hide();
                    $('#fdViewSelected').slideDown('fast');
                }
                $('#fdOtherFilterSection').hide();
                break;
            case 2:
                $('#fdViewNotSelected').hide();
                $('#fdViewSelected').hide();
                $('#fdOtherFilterSection').slideDown('fast');
                break;
        }


    });

    //enable/disable month for find dublicates
    $('#fdEnableMonth').change(function () {
        if ($(this).prop('checked') === true) {
            $('#fdMonthSection').removeClass('disDiv');
        }
        else {
            $('#fdMonthSection').addClass('disDiv');
        }
    });

    //start finding dublicates
    $('#btnFindDublicates').on('click', () => {
        $('#findDublicatesmodal').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            timeout: 6000000,
            url: '/AccountSummary/FindDublicates/' + $('#fdYearSelect').val() + '/' + $('#fdMonthSelect').val() + '/' + $('#fdNodes').val() +
                '/' + $('#fdAbonents').val() + '/' + $('#fdFilterSource').val() + '/?EnableMonth=' + $('#fdEnableMonth').prop('checked') +
                '&SelectedView=' + (SelectedView !== null && ViewType === 'Calls') + '&Filter=' + encodeURIComponent($('#fdFilterOther').val()) +
                '&ViewName=' + encodeURIComponent(SelectedView) + '&OwnerName=' + encodeURIComponent(OwnerName) +
                '&OwnerType=' + ConvertViewOnwerModelToInt(OwnerType) + '&Group=' + encodeURIComponent(Group),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    if (response.finded === true) {
                        SQLFilter = response.sql;
                        $('#pError').text(response.message);
                        ShowSpinner(false);
                        $('#ErrordDublicatesmodal').modal('show');
                    }
                    else {
                        $('#pSuccess').text(response.message);
                        ShowSpinner(false);
                        $('#SuccessdDublicatesmodal').modal('show');
                    }
                }
            }
        });
    });

    //delete dublicates
    $('#btnDeleteDublicates').on('click', () => {
        $('#ErrordDublicatesmodal').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            timeout: 6000000,
            url: '/AccountSummary/DeleteDublicates/?sql=' + encodeURIComponent(SQLFilter),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#pSuccess').text(response.message);
                    ShowSpinner(false);
                    $('#SuccessdDublicatesmodal').modal('show');
                }
            }
        });
    });

    //open modal for build graph
    $('#btnTrafficCalc').on('click', () => {

        initDateTimepickers();
        try { $('#datetimepicker').data("DateTimePicker").setDate(new Date()); } catch (e) { console.log(e); }

        $('#periodForGraph').val('2');
        $('#trunksForGraph').val('');
        $('#viewsForGraphSection').hide();
        $('#viewNotSelectedForGraph').hide();
        $('#viewSelectedForGraph').hide();
        $('#buildTraffCalc').prop('disabled', true);
        $('#opt2').prop('checked', false);
        $('#opt3').prop('checked', false);
        $('#buildTrafficCalc').modal('show');
        setTimeout(InitTrunksSelect2, 150);
    });

    //traffic calc logic modal
    $('#opt2, #opt3').change(function () {
        if ($(this).prop("id") === 'opt2') {
            $('#viewsForGraphSection').slideUp();
            if (SelectedView === null) {//view not selected
                $('#viewNotSelectedForGraph').slideDown('fast');
                $('#buildTraffCalc').prop('disabled', true);
            }
            else {//view selected
                $('#viewSelectedForGraphName').text(SelectedView);
                $('#viewSelectedForGraph').slideDown('fast');
                $('#buildTraffCalc').prop('disabled', false);
            }
        }
        else {
            $('#viewsForGraph').val('');
            $('#viewNotSelectedForGraph').hide();
            $('#viewSelectedForGraph').hide();
            $('#viewsForGraphSection').slideDown('fast');
            setTimeout(InitViewsSelect2, 150);
            $('#buildTraffCalc').prop('disabled', true);
        }
    });

    //select other views
    $('#viewsForGraph').change(() => {
        $('#buildTraffCalc').prop('disabled', !$('#viewsForGraph').val());
    });

    //send data for build traffic
    $('#buildTraffCalc').on('click', () => {
        $('#buildTrafficCalc').modal('hide');
        ShowSpinner(true);

        let model = new FormData();
        model.append("Period", $('#periodForGraph').val());
        model.append("Begin", $('#datetimepicker').data('date'));
        model.append("Views", $('#opt2').prop('checked') === true ? OwnerName + "/" + (!Group ? "" : Group) + "/" + SelectedView : $("#viewsForGraph").val().join('‣'));
        model.append("RoutesIDs", $("#trunksForGraph").val() === null ? "" : $("#trunksForGraph").val());

        $.ajax({
            type: "POST",
            url: '/TariscopeViews/TrafficCalculation/Setup/',
            data: model,
            processData: false,
            contentType: false,
            traditional: true,
            success: r => {
                if (r !== null && r.success === true) {
                    window.location = "/TariscopeViews/TrafficCalculation";
                }
                else {
                    ShowSpinner(false);
                }
            }
        });
    });

    //open a new provider detalization view
    $('#btnAddPDView').on('click', () => { window.location.href = "/ProviderViews/New/" });

    //===================bg recharge=================================================
    //hide show button for carousel for archive calls
    $("#BGREchargeCallsCarousel").on('slid.bs.carousel', function () {
        let slideNum = $('#BGREchargeCallsCarousel').find('div.active').index();

        if (slideNum > 0) $('#BGREchargeCallsCarouselPrevBtn').show();
        else $('#BGREchargeCallsCarouselPrevBtn').hide();

        if (slideNum >= 2) $('#BGREchargeCallsCarouselNextBtn').hide();
        else $('#BGREchargeCallsCarouselNextBtn').show();
    });

    //show modal for delete calls
    $('#btnRechargeCalls').on('click', () => {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            async: true,
            url: '/Database/IsCanRecharge',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);

                    if (!response.isrunning) {
                        $('#deviceConcentratorForBGRecharge').load('/TariscopeViews/CallsTransfer/SelectDevice', () => {
                            $('#BGREchargeCallsCarousel').carousel(0);
                            $('#BGREchargeCallsCarouselPrevBtn').hide();
                            $('#BGREchargeCallsCarouselNextBtn').show();
                            $('#CustomBGRechargePeriodSection').hide();

                            $('#BGrechargePeriodSelect').val('0');

                            initDateTimepickersRecharge();

                            try {
                                $('#datetimepickerFromBGREcharge').data("DateTimePicker").setDate(new Date());
                                $('#datetimepickerToBGREcharge').data("DateTimePicker").setDate(new Date());
                            } catch (e) { console.log(e); }

                            $('#FromEnabledBGREcharge').prop('checked', true);
                            $('#ToEnabledBGREcharge').prop('checked', true);

                            $('#BGREchargeCallsmodal').modal('show');
                        });
                    }
                    else if (response.ismy) {
                        $('#runningRechargemodal').modal('show');
                    }
                    else {
                        $('#notmyRechargemodal').modal('show');
                    }
                }
            }
        });



    });

    //show or hide custom period
    $('#BGrechargePeriodSelect').change(function () {
        if ($(this).val() * 1 === 2)
            $('#CustomBGRechargePeriodSection').slideDown('fast');
        else
            $('#CustomBGRechargePeriodSection').slideUp('fast');
    });

    //bg recharge
    $('#ArchiveCallsCarouselBGREchargeBtn').on('click', () => {
        let devElements = $('#deviceConcentratorForBGRecharge input[id^="SelectedDevice"');
        let devices = [];

        devElements.map((e) => {
            if ($(devElements[e]).prop('checked') === true)
                devices.push($(devElements[e]).attr('data-device') * 1);
        });

        if (devices.length === 0) {
            $('#zeroBGrechargeDeviceError').slideDown('fast');
            setTimeout(() => { $('#zeroBGrechargeDeviceError').slideUp('fast'); }, 2500);
            //show error here
        }
        else {
            $('#BGREchargeCallsmodal').modal('hide');
            ShowSpinner(true);

            let from = $('#FromEnabledBGREcharge').prop('checked') === true ? $('#datetimepickerFromBGREcharge').data('date') : '';
            let to = $('#ToEnabledBGREcharge').prop('checked') === true ? $('#datetimepickerToBGREcharge').data('date') : '';

            $.ajax({
                type: "POST",
                async: true,
                url: '/Database/GoRecharge/?Devices=' + encodeURIComponent(devices.join(',')) +
                    '&PeriodType=' + $('#BGrechargePeriodSelect').val() +
                    '&From=' + from +
                    '&To=' + to,
                traditional: true,
                success: function (response) {
                    ShowSpinner(false);
                    if (response !== null && response.success === true) {
                        $('#rechargestartedmodal').modal('show');
                    }
                    else {
                        $('#notmyRechargemodal').modal('show');
                    }
                }
            });
        }
    });

    //clear loaded devices
    $('#BGREchargeCallsmodal').on('hidden.bs.modal', function () {
        $('#deviceConcentratorForBGRecharge').empty();
    });

    LoadViews('');
    initDateTimepickersRecharge();
});