﻿let selectedCodes = [];
let rowIndex;
let header;
let sticky;

function RemoveFromArray(array, element) {
    //remove element form array
    const index = array.indexOf(element);

    if (index !== -1) {
        array.splice(index, 1);
    }
}

function AttachEventsToTable() {
    $('#tariscope-tlphc tbody').on('click', 'tr', function (e) {
        if ($('#multiselect').prop('checked')) {
            if (e.shiftKey) {//select via shift

                let newIndex = $('tr[data-id="' + $(this).data('id') + '"]').index();
                let table = $('#tariscope-tlphc');

                //init first row
                if (rowIndex === null)
                    rowIndex = $('tr[data-id="' + $(this).data('id') + '"]').index();

                tempIndex = rowIndex;

                //clear prev selected
                selectedCodes = [];

                $('#tariscope-tlphc tr.selected').removeClass('selected');

                let direction = newIndex >= rowIndex;

                if (direction) {//select down
                    while (tempIndex <= newIndex) {
                        tempIndex += 1;

                        let tr = $('tr:eq(' + tempIndex + ')', table);
                        let code = $(tr).find('td[data-name="Code"]').text();

                        if (tr.css('display') !== 'none' && (!code.startsWith('k') && code.trim())) {
                            tr.addClass('selected');
                            RemoveFromArray(selectedCodes, tr.find('td[data-name="ID"]').text());
                            selectedCodes.push(tr.find('td[data-name="ID"]').text());
                        }
                    }
                }
                else {//select up
                    while (tempIndex > (newIndex - 1)) {
                        var tr2 = $('tr:eq(' + (tempIndex + 1) + ')', table);
                        let code = $(tr2).find('td[data-name="Code"]').text();

                        if (tr2.css('display') !== 'none' && (!code.startsWith('k') && code.trim())) {
                            tr2.addClass('selected');
                            RemoveFromArray(selectedCodes, tr2.find('td[data-name="ID"]').text());
                            selectedCodes.push(tr2.find('td[data-name="ID"]').text());
                        }

                        tempIndex -= 1;
                    }
                }
            }
            else {//single select
                rowIndex = $('tr[data-id="' + $(this).data('id') + '"]').index();

                if ($(this).hasClass('selected')) {
                    $(this).removeClass('selected');
                    RemoveFromArray(selectedCodes, $(this).find('td[data-name="ID"]').text());
                }
                else {
                    let code = $(this).find('td[data-name="Code"]').text();
                    if (!code.startsWith('k') && code.trim()) {
                        selectedCodes.push($(this).find('td[data-name="ID"]').text());
                        $(this).addClass('selected');
                    }
                }
            }
        }
        else {
            selectedCodes = [];

            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            }
            else {
                let code = $(this).find('td[data-name="Code"]').text();
                if (!code.startsWith('k') && code.trim()) {
                    selectedCodes.push($(this).find('td[data-name="ID"]').text());
                    $('#tariscope-tlphc tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            }
        }

        UpdateButtons();
    });


    $('#tcodesTable th').on('click', function () {
         $.ajax({
             type: "POST",
             url: '/TelephoneCodes/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
             traditional: true,
             success: function (response) {
                 if (response !== null && response.success === true) {
                     $('#SortCol').val(response.CurrentSortColumnName);
                     Load();
                 }
             }
         });
     });

    $('#tcodesTable').removeClass('disDiv');
}

function GetBackSelected() {
    for (let i = 0; i < selectedCodes.length; i++) {
        try {
            $('tr[data-id="' + selectedCodes[i] + '"]').addClass('selected');
        } catch (e) { console.log(e); }
    }
}

function IsTreeCodesView() {
    if ($('#tbSearch').val() !== "" || $('#SortCol').val() !== "")
        return false;

    return !$('#DisableTree').prop('checked');
}

function Load() {
    selectedCodes = [];
    UpdateButtons();
    $('#tcodesTable').addClass('disDiv');

    if (IsTreeCodesView()) {
        $('#tcodesTable').load("/TelephoneCodes/Tree/?ProviderID=" + $('#CallProviderID').val(), AttachEventsToTable);
        SetSticky();
    }
    else
        $('#tcodesTable').load("/TelephoneCodes/Table/0/50/?Search=" + encodeURIComponent($('#tbSearch').val()) + '&ProviderID=' + $('#CallProviderID').val());
}

function SetSticky() {
    header = document.getElementById("headRow");                 //for sticky head
    sticky = header.offsetTop;                                   //for sticky head

    //animate scroll top
    $('.go-top').on('click', function (event) {
        event.preventDefault();
        $('html, body').animate({ scrollTop: 0 }, 300);
    });

    //event for show go top button
    $(window).on("scroll", function () {
        //for go top button
        if ($(this).scrollTop() > 200) {
            $('.go-top').fadeIn(200);
        } else {
            $('.go-top').fadeOut(200);
        }

        //for sticky head
        if (window.pageYOffset > (sticky + 100)) {
            header.classList.add("sticky");
            $('#headRow').width($('#tcodesTable').width());
        } else {
            header.classList.remove("sticky");
        }
    });
}