﻿let notInstalled = '<span class="mutedText">' + $('#notInstalledLabel').val() + '</span>';
let notOverride = '<span class="mutedText">' + $('#notOverrideLabel').val() + '</span>';

function UpdateButtons() {
    if (selectedCodes.length === 0) {
        $("#btnSetup").attr("disabled", true);
        $("#btnClean").attr("disabled", true);
        $("#btnResetSelection").attr("disabled", true);

        $("#btnSetupMenu").addClass("disDiv");
        $("#btnCleanMenu").addClass("disDiv");
        $("#btnResetSelectionMenu").addClass("disDiv");
    }
    else {
        $("#btnSetup").attr("disabled", false);
        $("#btnClean").attr("disabled", false);
        $("#btnResetSelection").attr("disabled", false);

        $("#btnSetupMenu").removeClass("disDiv");
        $("#btnCleanMenu").removeClass("disDiv");
        $("#btnResetSelectionMenu").removeClass("disDiv");
    }
}

$(document).ready(() => {

    function ExpandLeftMenu() {
        try {
            if (providerIsLoaded) {
                ShowProvider($('#CallProviderID').val());
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }

    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 700;   //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            Load();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //show modal to edit tariff
    $('#btnSetup, #btnSetupMenu').on('click', () => {
        if (selectedCodes.length === 1) {
            $.ajax({
                type: "POST",
                url: '/TelephoneCodes/GetTariff/' + selectedCodes[0] + '/' + $('#CallProviderID').val(),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        if (response.tariff === null) {
                            $('#adcCallType').val($('option:first', '#adcCallType').val());
                            $('#adcCategory').val($('option:first', '#adcCategory').val());
                            $('#selectedTariff').val($('option:first', '#selectedTariff').val());
                        }
                        else {
                            $('#adcCallType').val(response.tariff.CallType);
                            $('#adcCategory').val(response.tariff.CategoryID);
                            $('#selectedTariff').val(response.tariff.TariffID);
                        }

                        
                        let row = $(`tr[data-id="${selectedCodes[0]}"]`);

                        let n = $(row.find('td[data-name="Name"]').find('span[data-n="1"]')[0]).text();
                        let c = $(row.find('td[data-name="Code"]')[0]).text();

                        if (!n)
                            n = row.find('td[data-name="Name"]').text();

                        $('#currentCode').text(`${n} (${c})`);
                        $('#editTariffmodal').modal('show');
                    }
                }
            });
        }
        else {
            $('#adcCallType').val($('option:first', '#adcCallType').val());
            $('#adcCategory').val($('option:first', '#adcCategory').val());
            $('#selectedTariff').val($('option:first', '#selectedTariff').val());
            $('#editTariffmodal').modal('show');
        }
    });

    //show modal with info
    $('#btnInfo, #btnInfoMenu').on('click', () => { $('#codesInfomodal').modal('show'); });

    //reset selection
    $('#btnResetSelection, #btnResetSelectionMenu').on('click', () => {
        selectedCodes = [];
        $('#tariscope-tlphc tr.selected').removeClass('selected');
        UpdateButtons();
    });

    //save state of multiselect option to cockie
    $('#switchMultiselect').on('click', function () {

        var state = !$('#multiselect').is(':checked') ? 'checked' : 'e';

        $.ajax({
            type: "POST",
            async: true,
            url: '/TelephoneCodes/SaveMultiselectState/?state=' + state,
            traditional: true
        });
    });

    //setup tarifs for selected
    $('#saveTariff').on('click', () => {
        $('#editTariffmodal').modal('hide');
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/TelephoneCodes/SetTariff/' + $('#selectedTariff').val() + '/' + $('#CallProviderID').val() +
                '/' + $('#adcCategory').val() + '/' + $('#adcCallType').val() + '/?IDs=' + encodeURIComponent(selectedCodes.join(',')) + '&ToAll=' + $('#ApplyForAll').prop('checked'),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    for (let i = 0; i < selectedCodes.length; i++) {
                        let tr = $('tr[data-id="' + selectedCodes[i] + '"]');
                        let rate = tr.find('td[data-name="Tariff"]');
                        if (rate.length === 0) {
                            rate = tr.find('td[colspan="3"]');
                            rate.removeAttr('colspan');
                            rate.attr('data-name', 'Tariff');
                            rate.after('<td data-name="CallType"></td>');
                            rate.after('<td data-name="Category"></td>');
                        }

                        rate.html($("#selectedTariff option:selected").text());
                        if ($('#adcCategory').val() * 1 !== 1) tr.find('td[data-name="Category"]').html($('#adcCategory option:selected').text());
                        else tr.find('td[data-name="Category"]').html(notOverride);
                        if ($('#adcCallType').val() * 1 !== -1) tr.find('td[data-name="CallType"]').html($('#adcCallType option:selected').text());
                        else tr.find('td[data-name="CallType"]').html(notOverride);

                        if ($('tbody[id="contentArea"]').length > 0) {//non tree
                            window.clusterize.updateRow(window.clusterize.findIndex((element, index, array) => {
                                return element.includes('data-id="' + selectedCodes[i] + '"');
                            }), '<tr data-id="' + selectedCodes[i] + '">' + tr.html() + '</tr>');
                        }
                    }

                    ShowSpinner(false);
                }
            }
        });
    });

    //show modal to remove tariffs
    $('#btnClean, #btnCleanMenu').on('click', () => { $('#clearTariffsmodal').modal('show'); });

    //confirm clean tariffs
    $('#confirmClearCodes, #confirmClearCodesToAll').on('click', function () {
        let toAll = $(this).prop('id') === 'confirmClearCodesToAll';

        $('#clearTariffsmodal').modal('hide');
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/TelephoneCodes/DeleteTariff/' + $('#CallProviderID').val() + '/?IDs=' + encodeURIComponent(selectedCodes.join(',')) + '&ToAll=' + toAll,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    for (let i = 0; i < selectedCodes.length; i++) {
                        let tr = $('tr[data-id="' + selectedCodes[i] + '"]');
                        let rate = tr.find('td[data-name="Tariff"]');

                        if (rate.length !== 0) {
                            rate.attr('colspan', 3);
                            rate.removeAttr('data-name', 3);

                            rate.html(notInstalled);

                            tr.find('td[data-name="Category"]').remove();
                            tr.find('td[data-name="CallType"]').remove();
                        }

                        if ($('tbody[id="contentArea"]').length > 0) {//non tree
                            window.clusterize.updateRow(window.clusterize.findIndex((element, index, array) => {
                                return element.includes('data-id="' + selectedCodes[i] + '"');
                            }), '<tr data-id="' + selectedCodes[i] + '">' + tr.html() + '</tr>');
                        }
                    }

                    ShowSpinner(false);
                }
            }
        });
    });

    //disable tree
    $('#DisableTree').change(() => {
        Load();
        var state = $('#DisableTree').is(':checked') ? 'checked' : 'e';
        $.ajax({
            type: "POST",
            async: true,
            url: '/TelephoneCodes/SaveDisTree/?state=' + state,
            traditional: true
        });
    });

    Load();
    ExpandLeftMenu();
});