﻿$(document).ready(function () {
    var viewId = $(location).attr('search').replace('?id=', '');

    $.SoftPi.DataGrid.Create({
        url: '/api/dataviews/' + viewId,
        id: 'view',
        scrollX: true,
        tableClasses: 'table table-bordered data-grid'
    });

    $.ajax({
        type: 'GET',
        url: '/api/dataviews/descriptions/' + viewId,
        contentType: 'application/json',
        success: function (description) {
            _setDescription(description);
        },
        dataType: 'json'
    });

    function _setDescription(description) {
        var header$ = $('section.content-header');
        $(header$).find('h1').text(description.Name);
        $(header$).find('li.active').text(description.Name);
        var boxHeader$ = $('section.content div.box-header');
        $(boxHeader$).find('h3:first span').text(description.ViewType);
        $(boxHeader$).find('h3:last span').text(description.Owner);
        var title = $('head title', window.parent.document).text().split('-')[1];
        $('head title', window.parent.document).text(description.Name + ' - ' + title);
    };
});