﻿$(document).ready(function () {
    var selectedDic = null;

    function Export(t) {
        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/Dictionary/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/Dictionary/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }

                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    };

    function LoadValues() {
        //load table with dictionary values
        $('#DicValuesContent').load('Dictionary/GetValues/?type=' + encodeURIComponent($('#dicList').val()), AttachEventsForTable);
    }

    function LoadNamesToSelect(select = null) {
        //load dictionary names to select
        $.ajax({
            type: "POST",
            async: true,
            url: '/Dictionary/GetNames/',
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#dicList').empty();
                    $('#dicList').append('<option value="%%-1%%">' + $('#FirstIndexInDicsList').val() + '</option>');
                    $('#dicList').append('<optgroup label="——————————"></option>');
                    response.names.forEach(function (e) {
                        $('#dicList').append('<option value="' + e + '">' + e + '</option>');
                    });

                    if (select !== null) {
                        $('#dicList').val(select);
                        LoadValues();
                        UpdateButtons(true);
                    }
                }
            }
        });
    };

    function UpdateButtons(show) {
        //update general buttons
        $('#btnAddValue').prop('disabled', !show);
        $('#btnRename').prop('disabled', !show);
        $('#btnDelete').prop('disabled', !show);
    }

    function UpdateButtonsValuesUI() {
        /*update ui for buttons when not selected any var some buttons disabled*/
        if (selectedDic == null) {
            $("#btnEditValue").attr("disabled", true);
            $("#btnDeleteValue").attr("disabled", true);
        }
        else {
            $("#btnEditValue").attr("disabled", false);
            $("#btnDeleteValue").attr("disabled", false);
        }
    };

    function AttachEventsForTable() {
        //update buttons for values of dictonary
        $('#tariscope-dc tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedDic = null;
            }
            else {
                selectedDic = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-dc tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtonsValuesUI();
        });


        $('#DicValuesContent').slideDown('fast');
    }

    //chnaged dictionary and need to show values of this dic
    $('#dicList').change(function () {
        if ($(this).val() !== '%%-1%%')
            LoadValues();
        else
            $('#DicValuesContent').slideUp('fast');

        selectedDic = null;
        UpdateButtonsValuesUI();
        UpdateButtons($(this).val() !== '%%-1%%');
    });

    //show error when name is empty
    $('#DicName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyName').slideDown('fast');
            $('#wrongName').slideUp('fast');
            $('#saveDictionary').prop('disabled', true);
        }
        else {
            $('#emptyName').slideUp('fast');
            $('#wrongName').slideUp('fast');
            $('#saveDictionary').prop('disabled', false);
        }
    });

    //show modal for add new dic
    $('#btnAdd').on('click', function () {
        $('#add').prop('hidden', false);
        $('#rename').prop('hidden', true);
        $('#emptyName').slideUp();
        $('#wrongName').slideUp();
        $('#saveDictionary').prop('disabled', true);
        $('#DicName').val('');

        $('#addeditModal').modal('show');
    });

    //open modal for rename selected dictionary
    $('#btnRename').on('click', function () {
        $('#add').prop('hidden', true);
        $('#rename').prop('hidden', false);
        $('#emptyName').slideUp();
        $('#wrongName').slideUp();
        $('#saveDictionary').prop('disabled', true);
        $('#DicName').val($('#dicList').val());
        $('#editedName').html($('#dicList').val());

        $('#addeditModal').modal('show');
    });

    //add new dictionary or rename existing
    $('#saveDictionary').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Dictionary/EditDictionary/?type=' + encodeURIComponent($('#DicName').val()) + '&IsEdit=' + $('#add').prop('hidden') + '&oldtype=' + encodeURIComponent($('#dicList').val()),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    LoadNamesToSelect($('#DicName').val());
                    $('#addeditModal').modal('hide');
                }
                else if (response != null && response.isfree == false) {
                    $('#wrongName').slideDown('fast');
                    $('#saveDictionary').prop('disabled', true);
                }
                else {
                    $('#addeditModal').modal('hide');
                }
            }
        });
    });

    //show modal for delete selected dictionary
    $('#btnDelete').on('click', function () {
        $('#confirmDelete').modal('show');
    });

    //confirm delete selected dictionary
    $('#DeleteConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Dictionary/DeleteDictionary/?type=' + encodeURIComponent($('#dicList').val()),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    LoadNamesToSelect();
                    $('#DicValuesContent').slideUp('fast');

                    selectedDic = null;
                    UpdateButtons(false);
                    UpdateButtonsValuesUI();

                    $('#confirmDelete').modal('hide');
                }
            }
        });
    });

    //show modal for add value into dictionary
    $('#btnAddValue').on('click', function () {
        selectedDic = null;
        $('#addValue').prop('hidden', false);
        $('#editValue').prop('hidden', true);
        $('#DicValue').val('');
        $('#addeditValueModal').modal('show');
    });

    //show modal for edit selected value
    $('#btnEditValue').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Dictionary/GetValue/' + selectedDic,
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    console.log(response);
                    $('#addValue').prop('hidden', true);
                    $('#editValue').prop('hidden', false);
                    $('#editedValue').text(response.value);
                    if (response.isempty == false)
                        $('#DicValue').val(response.value);
                    $('#addeditValueModal').modal('show');
                }
            }
        });
    });

    //confirm add or edit dictionary value
    $('#saveDictionaryValue').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Dictionary/EditValue/' + (selectedDic === null ? 0 : selectedDic) + '/?type=' + encodeURIComponent($('#dicList').val()) + '&value=' + encodeURIComponent($('#DicValue').val()),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    selectedDic = null;
                    LoadValues();
                    $('#addeditValueModal').modal('hide');
                }
            }
        });
    });

    //open modal for delete selected dictionary value
    $('#btnDeleteValue').on('click', function () {
        $('#warningDeleteValue').slideUp();
        $('#confirmValueDelete').modal('show');
    });

    //confirm delete selected value
    $('#DeleteValueConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Dictionary/DeleteValue/' + selectedDic + '/?confirm=' + $('#warningDeleteValue').is(":visible"),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    selectedDic = null;
                    if (response.islast == true) {
                        LoadNamesToSelect();
                        $('#DicValuesContent').slideUp('fast');
                        UpdateButtons(false);
                        UpdateButtonsValuesUI();
                    }
                    else {
                        LoadValues();
                    }
                    $('#confirmValueDelete').modal('hide');
                }
                else if (response != null && response.islast == true) {
                    $('#warningDeleteValue').slideDown('fast');
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    LoadNamesToSelect();
});