﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using SoftPi.Tariscope.Common;
using System.Net;
//using System.Net.Http;
//using System.Text.Json;
using System.IO;
using System.Threading.Tasks;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;
using SoftPi.Tariscope.DAL;
using SoftPi.Tariscope;
using Microsoft.Data.SqlClient;
using Npgsql;

public class SetCos3cxV18Script : IScript
{
    private IScriptHost _host;

        //You should take values of the constants from the 3CXPhoneSystem.ini file, the CtgServerProfile section and change for the following constants.
		
        const string DBHost = "127.0.0.1";              //IP address of PostgreSQL server
        const string DBPort = "5432";               	//IP port of PostgreSQL server
        const string MasterDBUser = "phonesystem";          //Database username
        const string MasterDBPassword = "pLvjPg8IKUo";  //Database username password
		
    public void Init(IScriptHost host)
    {
        this._host = host;
        _host.Close += OnClose;
    }
    private void OnClose(ref bool Cancel)
    {
        return;
    }
    public void Main(object Parameters)
    {
        try
        {
            SubscriberLimitingActionParameters ActionParameters = (SubscriberLimitingActionParameters)Parameters;

            _host.AddEvent(string.Format("Restrict subscriber:{0} Cos:{1}, Category: {2}", ActionParameters.Abonent.AbonentName, ActionParameters.CosValue, ActionParameters.Credit.CategoryID));
            _host.AddEvent(ActionParameters.ActionType.ToString());
//			            
			_host.AddEvent(string.Format("---Parameters-------------------"));
            _host.AddEvent(string.Format("Restriction group: {0}, Restriction class: {1}, Credit = {2}, Debit = {3}", ActionParameters.Abonent.RestrictionGroup, ActionParameters.Credit.RestrictClass, ActionParameters.Credit.Credit, ActionParameters.Credit.Debit));
            _host.AddEvent(string.Format("--------------------------------"));
//
            string CategoryName;
            List<DN> Dns;

            using (SqlConnection cn = new SqlConnection(_host.DatabaseConnectionString))
            {
                cn.Open();
                Dns = DNs.Instance(cn).Load(ActionParameters.Abonent.ID).Where(x => DateTime.Now > x.FromDateValue && DateTime.Now < x.ToDateValue).ToList();
                if (ActionParameters.Credit.CategoryID.HasValue)
                    CategoryName = new Categories(cn).Details(ActionParameters.Credit.CategoryID.Value).Name;
                else
                    CategoryName = "All categories";
            }
//
			_host.AddEvent(string.Format("Restriction category: {0}", CategoryName));
//

            bool extensionState = true;
            if (ActionParameters.ActionType == RestrictStatus.QueueUnrestrict) 
			{
				extensionState = false;
				_host.AddEvent(string.Format("DN is in the queue for unrestriction"));
			}
			else
			{
				_host.AddEvent(string.Format("DN is in the queue for restriction"));
			}
//
			_host.AddEvent(string.Format("PostgreSQL connection parameters"));
			_host.AddEvent(string.Format("DBHost: {0}, DBPort: {1}, MasterDBUser: {2}, MasterDBPassword: {3} ", DBHost, DBPort, MasterDBUser, MasterDBPassword));
//
//			ActionParameters.Result = MediationActionResult.Success;
			DateTime cDate = DateTime.Now;
            foreach (DN CurrentDN in Dns)
            {
                _host.AddEvent("DN " + CurrentDN.DN);

				var connString = string.Format("Host = {0}; Username = {1}; " +
                "Password = {2}; Database = ts_restrictions", DBHost, MasterDBUser, MasterDBPassword);
				try
				{
					using var conn = new NpgsqlConnection(connString);
					conn.Open();
					using var command = new NpgsqlCommand($"INSERT INTO restrictions (request_date, extension, disable_external) VALUES ('" + cDate + "','" + CurrentDN + "','" + extensionState + "')", conn);
					command.ExecuteNonQuery();
					_host.AddEvent(string.Format("The request was sent to change DN status into the database"));
				}
				catch (Exception ex)
				{
					_host.AddEvent("Failed to write data to the database: " + ex);
//					ActionParameters.Result = MediationActionResult.Fail;
				}
            }
        }
        catch (Exception ex)
        {
            _host.AddEvent(ex.ToString());
//			ActionParameters.Result = MediationActionResult.Fail;
        }
    }
}
