﻿using Microsoft.Data.SqlClient;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;
using System;
using SoftPi.Tariscope.DAL;

public class FraudScanner : IScript
{
    private IScriptHost Host;
    private bool NeedFinish = false;

    // 
    // ******************************************************************************************************************
    // 
    private int MAX_CALL_DURATION_S = 150;

    private int CALLTYPE_INTERNATIONAL = 5;

    private TimeSpan BEGINNING_OF_WORK = TimeSpan.Parse("08:00:00");
    private TimeSpan END_OF_WORK = TimeSpan.Parse("19:00:00");


    // 
    // ******************************************************************************************************************
    // 


    public void Init(IScriptHost host)
    {
        this.Host = host;
        host.Close += OnClose;
        NeedFinish = false;
    }
    private void OnClose(ref bool Cancel)
    {
        return;
    }
    public void Main(object Parameters)
    {
        NewCallActionParameters actionParameters = (NewCallActionParameters)Parameters;

        try
        {
            this.Host.AddEvent("New call processing, ID=" + actionParameters.Id);

            using (SqlConnection cn = new SqlConnection(this.Host.DatabaseConnectionString))
            {
                cn.Open();
                CallItems CallItems = CallItems.Instance(cn);
                SqlCommand cmd = CallItems.GetCommand("SELECT ID, Originator, Terminator, CallDateTime, CallSeconds, CallType FROM viCalls WHERE ID=@callid");
                cmd.Parameters.AddWithValue("@callid", actionParameters.Id);
                using (SqlDataReader rs = cmd.ExecuteReader())
                {
                    if (rs.Read())
                    {
                        if (rs.GetInt16(5) == CALLTYPE_INTERNATIONAL && rs.GetInt32(4) > MAX_CALL_DURATION_S && (rs.GetDateTime(3).TimeOfDay > END_OF_WORK || rs.GetDateTime(3).TimeOfDay < BEGINNING_OF_WORK) && (rs.GetDateTime(3).DayOfWeek == DayOfWeek.Sunday || rs.GetDateTime(3).DayOfWeek == DayOfWeek.Saturday))
                            this.Host.SendMail("", "Fraud Detection system", "Suspicious call detected. ID=" + actionParameters.Id + " CallDateTime=" + rs.GetDateTime(3) + " Call duration=" + rs.GetInt32(4));
                    }
                }
            }
        }
        catch (Exception ex)
        {
            this.Host.AddEvent("Error running script:" + ex.ToString());
        }
    }
}
