﻿$(document).ready(() => {
    let selectedProfile;

    function ShowImportSpinner(show) {
        /*
         * function for showing spinner message when load edit preview
         * sometimes it is to long
         */
        if (show) {
            $("#loadMeInformation").modal({
                backdrop: "static",
                keyboard: false,
                show: true
            });
        }
        else {
            $("#loadMeInformation").modal('hide');

            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();

            setTimeout(function () { $('body').css('padding-right', 0); }, 1000);
        }
    }

    //Export the AD profiles table into an external file
    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/ADSync/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/ADSync/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }
    //Updating status of toolbar icons
    function UpdateButtonsUI() {
        if (selectedProfile === null) {
            $('#btnDelete').prop('disabled', true);
            $('#btnStartImport').prop('disabled', true);
            $('#btnEdit').prop('disabled', true);
        }
        else {
            $('#btnDelete').prop('disabled', false);
            $('#btnStartImport').prop('disabled', false);
            $('#btnEdit').prop('disabled', false);
        }
    }

    //Choice of AD profile
    function AttachEvents() {
        selectedProfile = null;

        $('#tariscope-profiles tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedProfile = null;
            }
            else {
                selectedProfile = $(this).find('td[data-name="Name"]').text();
                $('#tariscope-profiles tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtonsUI();
        });

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/ADSync/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        LoadProf();
                    }
                }
            });
        });

        UpdateButtonsUI();
    }

    //Clicking on the Edit icon
    //$('#btnEdit').on('click', function () {
    //    $.ajax({
    //        type: "GET",
    //        url: '/ADSync/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
    //        traditional: true,
    //        success: function (response) {
    //            if (response !== null && response.success === true) {
    //                LoadProf();
    //            }
    //        }
    //    });
    //});
    $('#btnEdit').on('click', () => { window.location = '/ADSync/Edit?profileName=' + selectedProfile; });

    //AD profiles loading
    function LoadProf() {
        $('#ldapsTable').load('/ADSync/GetProfiles/?s=' + encodeURIComponent($('#tbSearch').val()), AttachEvents);
    }

    //Import from AD
    function IfNeedImport() {
        if ($('#NeedImport').val() * 1 === 1) {
            ShowImportSpinner(true);
            $.ajax({
                type: "POST",
                url: '/ADSync/ImportFrom',
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        ShowImportSpinner(false);
                        $('#pSuccess').text(response.message);
                        $('#Successdmodal').modal('show');
                    }
                }
            });
        }
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            LoadProf();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //go to create new profile
    $('#btnAdd').on('click', () => { window.location = "/ADSync/Add"; });

    //show modal for delete selected profile
    $('#btnDelete').on('click', () => { $('#confirmDelete').modal('show'); });

    //confirm delete profile
    $('#DeleteConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/ADSync/Delete/?Name=' + encodeURIComponent(selectedProfile),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#confirmDelete').modal('hide');
                    LoadProf();
                }
            }
        });
    });

    //Start of import from AD
    $('#btnStartImport').on('click', () => {
        ShowImportSpinner(true);
        $.ajax({
            type: "POST",
            url: '/ADSync/Import/?Name=' + encodeURIComponent(selectedProfile),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowImportSpinner(false);
                    $('#pSuccess').text(response.message);
                    $('#Successdmodal').modal('show');
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //fix right padding
    $('#Successdmodal').on('hidden.bs.modal', function () {
        setTimeout(function () { $('body').css('padding-right', 0); }, 1000);
    });

    LoadProf();
    IfNeedImport();
});