﻿function ShowSavedLabel() {
    $('#saveLabel').slideDown('fast');
    setInterval(() => { $('#saveLabel').slideUp('fast'); }, 2500);
}

$(document).ready(() => {


    function initTypeSelect() {
        $('#pbxTypes').prepend('<optgroup label="Name~Suportet hardwares"></optgroup>');

        //types
        $('#pbxTypes').select2({
            theme: "bootstrap",
            templateResult: function (data) {
                let r = data.text.split('~');
                var $result = $(
                    '<div class="row" style="width: 90%;">' +
                    '<div class="col-md-4">' + r[0] + '</div>' +
                    '<div class="col-md-8">' + r[1] + '</div>' +
                    '</div>'
                );
                return $result;
            },
            templateSelection: function (data) {
                var r = data.text.split('~');
                var $result = $('<p style="margin-top: 5px;">' + r[0] + '</p>');
                return $result;
            }
        });

        //country codes
        $('#CountryCodes').select2({
            theme: "bootstrap",
            templateSelection: function (data) {
                var $result = $('<p style="margin-top: 5px;">' + data.text + '</p>');
                return $result;
            },
            tags: true
        });

        let cCode = $('#cCode').val();
        if ($('#CountryCodes').find("option[value='" + cCode + "']").length) {
            $('#CountryCodes').val(cCode).trigger('change');
        } else {
            $('#CountryCodes').append(new Option(cCode, cCode, true, true)).trigger('change');
        }
    }

    function SetActivityForPlanes() {
        $('#AutoPlane').prop('disabled', !$('#AutoCreateAbonents').prop('checked'));
    }

    function ExpandLeftMenu() {
        try {
            if (NodeIsLoaded) {
                ShowNodes('NewNodesMenu');
                ShowNodeEntry($('#nodeID').val() + '');
                ShowDevices('CNode_' + $('#nodeID').val() + '');
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }

    }

    function UpdatePBXSupportInfo() {
        if ($('#pbxTypes').val().includes('NetFlow sensor')) {
            $('#observerHasAlert').hide();
        }
        else {
            $('#observerHasAlert').show();
        }

        $.ajax({
            type: "POST",
            url: '/Devices/PBXInfo/?Name=' + encodeURIComponent($('#pbxTypes').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    if (response.ismsg) {
                        $('#pbxSupport').show();
                        $('#pbxSupport').text(response.msg);
                    }
                    else { $('#pbxSupport').hide(); }

                    if (response.config) {
                        $('#PBXConfigBtn').show();
                        $('#PBXExportConfig').show();
                        $('#PBXImportConfig').show();
                    }
                    else {
                        $('#PBXConfigBtn').hide();
                        $('#PBXExportConfig').hide();
                        $('#PBXImportConfig').hide();
                    }

                    if (response.realtime) { $('#PBXRealtimeBtn').show(); }
                    else { $('#PBXRealtimeBtn').hide(); }
                }
            }
        });
    }

    function SetupBalanceThreshold() {
        if ($('#LimitSubscribersByBalance').prop('checked'))
            $('#BalanceThreshold').removeClass('disDiv');
        else
            $('#BalanceThreshold').addClass('disDiv');
    }

    document.getElementById("Name").onkeypress = function (e) {
        var chr = String.fromCharCode(e.which);
        if ('(),.-_></\[];:`~%^&*#"'.indexOf(chr) >= 0)
            return false;
    };

    //disable/enable auto plane select
    $('#AutoCreateAbonents').change(SetActivityForPlanes);

    //pbx type was changed
    $('#pbxTypes').change(UpdatePBXSupportInfo);

    //show configurations
    $('#PBXConfigBtn').on('click', () => {
        $('#parserConfig').load('/Devices/Configuration/' + $('#parserID').val() + '/?Name=' + encodeURIComponent($('#pbxTypes').val()), () => { $('#parserConfigModal').modal('show'); });
    });

    //clear configuraiton form section
    $('#parserConfigModal').on('hidden.bs.modal', function () {
        $('#parserConfig').empty();
    });

    //show modal for setup ts profile forrealtime events
    $('#PBXRealtimeBtn').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Devices/TsProfile',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#DropCallDurationThreshold').val(response.config.DropCallDurationThreshold);
                    $('#DropCallCostThreshold').val(response.config.DropCallCostThreshold);
                    $('#DropCallRulesNumberPattern').val(response.config.DropCallRulesNumberPattern);
                    $('#BalanceThreshold').val(response.config.BalanceThreshold);
                    $('#LimitSubscribersByBalance').prop('checked', response.config.LimitSubscribersByBalance);

                    SetupBalanceThreshold();

                    $('#dropCallsTsprofile').modal('show');
                }
            }
        });
    });

    //change balance limiting
    $('#LimitSubscribersByBalance').change(SetupBalanceThreshold);

    //save ts realtime profile
    $('#saveTsProfile').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Devices/SaveTsProfile/' + $('#DropCallDurationThreshold').val()
                + '/' + $('#DropCallCostThreshold').val()
                + '/' + $('#BalanceThreshold').val()
                + '/?Pattern=' + encodeURIComponent($('#DropCallRulesNumberPattern').val())
                + '&Limiting=' + $('#LimitSubscribersByBalance').prop('checked'),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#dropCallsTsprofile').modal('hide');
                    setTimeout(() => { $('#restartMain3cxmodal').modal('show'); }, 750);
                }
            }
        });
    });

    //show modal for ask about import
    $('#PBXImportConfig').on('click', () => { $('#importConfigmodal').modal('show'); });

    //show dialog for select config file
    $('#importConfigconfig').on('click', () => {
        $('#importConfigmodal').modal('hide');
        $('#FileInputConfiguration').click();
    });

    //uploading file into server
    $("#FileInputConfiguration").change(function () {

        var formData = new FormData();
        Array.from(document.getElementById("FileInputConfiguration").files).forEach(e => {
            formData.append(e.name, e);
        });

        $.ajax({
            type: 'POST',
            async: true,
            url: '/Devices/Configuration/Upload/' + $('#parserID').val(),
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            success: function (response) {
                if (response.success === true) {
                    ShowSavedLabel();
                }
            }
        });
    });

    //export config
    $('#PBXExportConfig').on('click', () => {
        window.open('/Devices/Configuration/Download/' + $('#parserID').val() + '/?Name=' + encodeURIComponent($('#Name').val()), '_blank');
    });

    initTypeSelect();
    SetActivityForPlanes();
    UpdatePBXSupportInfo();
    ExpandLeftMenu();
});