﻿$(document).ready(() => {
    let selectedPrefix = null;

    function initdatetime() {
        //init datetimepicker
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),
            locale: $('#LocaleThread').val(),
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerTo').datetimepicker(options);
        $('#datetimepickerFrom').datetimepicker(options);
    }

    function ExpandLeftMenu() {
        try {
            if (NodeIsLoaded) {
                ShowNodes('NewNodesMenu');
                ShowNodeEntry($('#nodeID').val() + '');
                ShowDevices('CNode_' + $('#nodeID').val() + '');
                ShowDeviceContent('CNode_' + $('#nodeID').val() + 'CSelectedDevice_' + $('#deviceID').val());
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }
    }

    function UpdateButtons() {
        if (selectedPrefix === null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
        }
    }

    function AttachEventsToTable() {
        selectedPrefix = null;

        $('#tariscope-preff tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedPrefix = null;
            }
            else {
                selectedPrefix = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-preff tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtons();
        });

        UpdateButtons();
    }

    function Load() {
        $('#prefixTable').load('/Devices/Prefixes/Load/' + $('#deviceID').val(), AttachEventsToTable);
    }

    //show modal for delete dn range
    $('#btnDelete').on('click', () => { $('#deletePrefixmodal').modal('show'); });

    //confirm delete dn range
    $('#deletePrefixconfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Devices/Prefixes/Delete/' + selectedPrefix,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#deletePrefixmodal').modal('hide');
                    Load();
                }
            }
        });
    });

    //show modal for add new prefix
    $('#btnAdd').on('click', () => {
        $('#btnSavePrefix').unbind();

        $('#emptyName').hide();
        $('#editPrefixTitle').text($('#addTitle').val());

        $('#prefixSaveChanged').prop('checked', false);
        $('#prefixIsPattern').prop('checked', false);
        $('#prefixNumberLenght').prop('checked', false);
        $('#FromEnabled').prop('checked', false);
        $('#ToEnabled').prop('checked', false);

        $('#prefixNumberLenghtinput').addClass('disDiv');
        $('#datetimepickerTo').addClass('disDiv');
        $('#datetimepickerFrom').addClass('disDiv');

        $('#prefixName').val('');
        $('#prefixcode').val('');
        $('#prefixNumberLenghtinput').val('');
        $('#prefixReplaseTo').val('');

        $('#prefixProvider').val(0);
        $('#prefixCallDir').val(0);

        $('#btnSavePrefix').prop('disabled', true);


        //save prefix
        $('#btnSavePrefix').on('click', () => {
            var formData = new FormData();

            formData.append('from', $('#datetimepickerFrom').data('date'));
            formData.append('to', $('#datetimepickerTo').data('date'));

            formData.append('name', $('#prefixName').val());
            formData.append('code', $('#prefixcode').val());
            formData.append('replace', $('#prefixReplaseTo').val());
            formData.append('lenght', $('#prefixNumberLenghtinput').val());

            formData.append('provider', $('#prefixProvider').val());
            formData.append('direction', $('#prefixCallDir').val());

            formData.append('fromenabled', $('#FromEnabled').prop('checked'));
            formData.append('toenabled', $('#ToEnabled').prop('checked'));
            formData.append('lenghtenabled', $('#prefixNumberLenght').prop('checked'));
            formData.append('save', $('#prefixSaveChanged').prop('checked'));
            formData.append('ismask', $('#prefixIsPattern').prop('checked'));


            $.ajax({
                type: "POST",
                data: formData,
                datatype: 'application/octet-stream',
                contentType: false,
                processData: false,
                traditional: true,
                url: '/Devices/Prefixes/Add/' + $('#deviceID').val(),
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#editPrefixmodal').modal('hide');
                        Load();
                    }
                }
            });
        });

        if ($('#prefixSaveChanged').prop('checked')) {
            $('#NotSaveAlert').slideUp('fast');
        }
        else {
            $('#NotSaveAlert').slideDown('fast');
        }


        $('#editPrefixmodal').modal('show');
    });

    //show error when empty prefix name
    $('#prefixName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyName').slideDown('fast');
            $('#btnSavePrefix').prop('disabled', true);
        }
        else {
            $('#emptyName').slideUp('fast');
            $('#btnSavePrefix').prop('disabled', false);
        }
    });

    //checkpoxes
    $('#FromEnabled').change(() => {
        if ($('#FromEnabled').prop('checked') === true) {
            $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date());
            $('#datetimepickerFrom').removeClass('disDiv');
        }
        else {
            $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date(1900, 0));
            $('#datetimepickerFrom').addClass('disDiv');
        }
    });
    $('#ToEnabled').change(() => {
        if ($('#ToEnabled').prop('checked') === true) {
            $('#datetimepickerTo').data("DateTimePicker").setDate(new Date());
            $('#datetimepickerTo').removeClass('disDiv');
        }
        else {
            $('#datetimepickerTo').data("DateTimePicker").setDate(new Date(3000, 0));
            $('#datetimepickerTo').addClass('disDiv');
        }
    });
    $('#prefixNumberLenght').change(() => {
        if ($('#prefixNumberLenght').prop('checked') === true) {
            $('#prefixNumberLenghtinput').removeClass('disDiv');
        }
        else {
            $('#prefixNumberLenghtinput').addClass('disDiv');
        }
    });
    $('#prefixSaveChanged').change(() => {
        if ($('#prefixSaveChanged').prop('checked')) {
            $('#NotSaveAlert').slideUp('fast');
        }
        else {
            $('#NotSaveAlert').slideDown('fast');
        }
    });

    //show modal for edit prefix
    $('#btnEdit').on('click', () => {
        $('#btnSavePrefix').unbind();
        $('#emptyName').hide();
        $('#btnSavePrefix').prop('disabled', false);
        $('#editPrefixTitle').text($('#editTitle').val());

        $.ajax({
            type: "POST",
            url: '/Devices/Prefixes/Get/' + selectedPrefix,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    console.log(response.prefix);

                    $('#prefixID').val(response.prefix.ID);
                    $('#prefixName').val(response.prefix.Name);
                    $('#prefixcode').val(response.prefix.Code);
                    $('#prefixNumberLenghtinput').val(response.prefix.NumberLength == -1 ? '' : response.prefix.NumberLength);
                    $('#prefixReplaseTo').val(response.prefix.ReplaceTo);

                    $('#prefixProvider').val(response.prefix.ProviderID);
                    $('#prefixCallDir').val(response.prefix.IsIncoming ? 1 : 0);

                    $('#prefixSaveChanged').prop('checked', response.prefix.IsSaved);
                    $('#prefixIsPattern').prop('checked', response.prefix.IsMask);

                    if (response.prefix.NumberLength == -1) {
                        $('#prefixNumberLenghtinput').addClass('disDiv');
                        $('#prefixNumberLenght').prop('checked', false);
                    }
                    else {
                        $('#prefixNumberLenght').prop('checked', true);
                    }

                    $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date(response.prefix.FromDate));
                    $('#datetimepickerTo').data("DateTimePicker").setDate(new Date(response.prefix.ToDate));

                    if (new Date(response.prefix.FromDate).getTime() === new Date(1900, 0).getTime()) {
                        $('#datetimepickerFrom').addClass('disDiv');
                    }
                    else {
                        $('#datetimepickerFrom').removeClass('disDiv');
                    }

                    if (new Date(response.prefix.ToDate).getTime() === new Date(3000, 0).getTime()) {
                        $('#datetimepickerTo').addClass('disDiv');
                    }
                    else {
                        $('#datetimepickerTo').removeClass('disDiv');
                    }

                    //save prefix
                    $('#btnSavePrefix').on('click', () => {
                        var formData = new FormData();

                        formData.append('from', $('#datetimepickerFrom').data('date'));
                        formData.append('to', $('#datetimepickerTo').data('date'));

                        formData.append('name', $('#prefixName').val());
                        formData.append('code', $('#prefixcode').val());
                        formData.append('replace', $('#prefixReplaseTo').val());
                        formData.append('lenght', $('#prefixNumberLenghtinput').val());

                        formData.append('provider', $('#prefixProvider').val());
                        formData.append('direction', $('#prefixCallDir').val());

                        formData.append('fromenabled', $('#FromEnabled').prop('checked'));
                        formData.append('toenabled', $('#ToEnabled').prop('checked'));
                        formData.append('lenghtenabled', $('#prefixNumberLenght').prop('checked'));
                        formData.append('save', $('#prefixSaveChanged').prop('checked'));
                        formData.append('ismask', $('#prefixIsPattern').prop('checked'));


                        $.ajax({
                            type: "POST",
                            data: formData,
                            datatype: 'application/octet-stream',
                            contentType: false,
                            processData: false,
                            traditional: true,
                            url: '/Devices/Prefixes/Edit/' + $('#prefixID').val(),
                            success: function (response) {
                                if (response !== null && response.success === true) {
                                    $('#editPrefixmodal').modal('hide');
                                    Load();
                                }
                            }
                        });
                    });

                    if ($('#prefixSaveChanged').prop('checked')) {
                        $('#NotSaveAlert').slideUp('fast');
                    }
                    else {
                        $('#NotSaveAlert').slideDown('fast');
                    }

                    $('#editPrefixmodal').modal('show');
                }
            }
        });
    });

    Load();
    initdatetime();
    ExpandLeftMenu();
});