﻿$(document).ready(() => {
    function ExpandLeftMenu() {
        try {
            if (ObserversIsLoaded) {
                ShowObservers('ObserverMenu', true);
                ShowObserversContent('ObserverMenu_' + $('#ProfileName').val().replace(' ', '_'));
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }
    }

    function SetDevice(id) {
        $.ajax({
            type: "POST",
            url: '/Observers/SetDevice/' + id,
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {

                    try {
                        deviceID = response.device.ID;

                        $('#EquipmentId').val(deviceID);

                        $('#nonelectedDevice').hide();
                        $('#selectedDevice').show();

                        $('#deviceName').text(response.device.Name);
                        $('#deviceType').text(response.device.Type);

                        $('#btnRun').prop('disabled', false);

                        $('#selectdevicemodal').modal('hide');
                    } catch (e) { console.log(e); }
                }
            }
        });
    }

    //show modal for select device
    $('#selectdeviceLink, #btnShowEquipmentSelect').on('click', () => {
        $('#modalContainer').load('/Observers/SelectDevice', () => {
            //attach events to checkboxes
            $('input[id^="SelectedDevice_"]').change(function () {
                $('input[id^="SelectedDevice_"').prop('checked', false);
                $(this).prop('checked', true);
            });

            //show modal
            $('#selectdevicemodal').modal('show');
        });
    });

    //get information about selected device
    $('#btnSelect').on('click', () => {
        SetDevice($('input[id^="SelectedDevice_"]:checked').attr('data-device'));
    });

    //show configurations
    $('#ObserverConfigBtn').on('click', () => {
        $('#dsConfig').load('/Observers/Configuration/' + encodeURIComponent($('#DataSourceType').val()) + '/' + encodeURIComponent($('#ProfileName').val()), () => { $('#dsConfigModal').modal('show'); });
    });

    //setup device
    if ($('#EquipmentId').val() !== undefined && $('#EquipmentId').val() != null) {
        SetDevice($('#EquipmentId').val());
    }

    //show message when dont selected equipment
    $("#ObserverEditFrom").submit(function (e) {
        if ($('#EquipmentId').val() === undefined || $('#EquipmentId').val() === null || $('#EquipmentId').val() * 1 === -1) {
            e.preventDefault();
            $('#notSelectedPBXmodal').modal('show');
        }
    });

    ExpandLeftMenu();
});