﻿var NeedSetSize = true;

window.DeleteBranch = function (id, single = false) {
    //Deleting branch and children in tree table view
    if (!single)
        CloseChildren(id);
    var parent = $('#tableWithDestinationCodes tr[data-id="' + id + '"]')[0];
    $(parent).remove();
}

window.AddRow = function (data, hd) {
    var tr = document.createElement('tr');
    tr.setAttribute('data-id', data.ID);
    tr.setAttribute('data-opened', 'false');
    tr.setAttribute('data-loaded', 'false');
    tr.setAttribute('data-parentID', data.ParentID);

    var tdDesc = document.createElement('td');
    tdDesc.setAttribute('data-name', 'Description');

    var span2 = document.createElement('span');
    span2.className = 'descSpan';
    span2.innerHTML = data.Description;

    //row description
    tdDesc.appendChild(span2);

    tr.appendChild(tdDesc);
    tr.appendChild(createTD('ID', data.ID, hd[1]));
    tr.appendChild(createTD('Code', data.Code, hd[2]));
    tr.appendChild(createTD('CategoryID', window.GetDesciption('TableCategoryList', data.CategoryID), hd[3]));
    tr.appendChild(createTD('CallType', window.GetDesciption('TableCallTypeListList', data.CallType), hd[4]));
    tr.appendChild(createTD('Latitude', data.Latitude, hd[5]));
    tr.appendChild(createTD('Longitude', data.Longitude, hd[6]));
    tr.appendChild(createTD('Distance', 0, hd[7]));
    tr.appendChild(createTD('Rate', window.GetDesciption('TableRateList', data.RateID), hd[8]));
    tr.appendChild(createTD('FromDate', data.FromDate, hd[9]));
    tr.appendChild(createTD('ToDate', data.ToDate, hd[10]));

    $(tr).prependTo("#tableWithDestinationCodes > tbody");
}

window.GetDesciption = function (tableName, rowId) {
    return $('#' + tableName + ' td[id=' + rowId + ']').html();
}

function createTD(dt, ht, hd) {
    //create cell
    var td = document.createElement('td');
    td.setAttribute('data-name', dt);
    td.innerText = ht;

    if (!hd)
        td.setAttribute('hidden', 'hidden');

    return td;
}

function LoadChunk() {
    //load chunk of destination codes
    $.ajax({
        type: "POST",
        async: true,
        url: '/DestinationCodes/GetChunk/',
        traditional: true,
        success: function (response) {
            if (response != null && response.success == true) {
                response.list.forEach(function (code) {

                    var tr = document.createElement('tr');
                    tr.setAttribute('data-id', code.ID);
                    tr.setAttribute('data-opened', 'false');
                    tr.setAttribute('data-loaded', 'false');
                    tr.setAttribute('data-parentID', code.ParentID);

                    var tdDesc = document.createElement('td');
                    tdDesc.setAttribute('data-name', 'Description');

                    var span2 = document.createElement('span');
                    span2.className = 'descSpan';
                    span2.innerHTML = code.Description;

                    //row description
                    tdDesc.appendChild(span2);

                    tr.appendChild(tdDesc);
                    tr.appendChild(createTD('ID', code.ID, response.hd[1]));
                    tr.appendChild(createTD('Code', code.Code, response.hd[2]));
                    tr.appendChild(createTD('CategoryID', window.GetDesciption('TableCategoryList', code.CategoryID), response.hd[3]));
                    tr.appendChild(createTD('CallType', window.GetDesciption('TableCallTypeListList', code.CallType), response.hd[4]));
                    tr.appendChild(createTD('Latitude', code.Latitude, response.hd[5]));
                    tr.appendChild(createTD('Longitude', code.Longitude, response.hd[6]));
                    tr.appendChild(createTD('Distance', code.Distance, response.hd[7]));
                    tr.appendChild(createTD('Rate', window.GetDesciption('TableRateList', code.RateID), response.hd[8]));
                    tr.appendChild(createTD('FromDate', code.FromDate, response.hd[9]));
                    tr.appendChild(createTD('ToDate', code.ToDate, response.hd[10]));

                    $('#tableWithDestinationCodes tr:last')[0].closest('tr').after(tr);
                });
            }
            window.IsLoading = false;
            NeedSetSize = true;
        }
    });
}

function LoadChildren(e, async) {
    //load children of selected branch
    window.IsBussy = true;
    $.ajax({
        type: "POST",
        async: async,
        url: '/DestinationCodes/GetChildren/' + e,
        traditional: true,
        success: function (response) {
            if (response != null && response.success == true) {
                var left = GetIcon(e).css('margin-left').replace('px', '');
                var table = document.getElementById("tableWithDestinationCodes");
                var ed = e;

                response.list.forEach(function (code) {

                    var tr = document.createElement('tr');
                    tr.setAttribute('data-id', code.ID);
                    tr.setAttribute('data-opened', 'false');
                    tr.setAttribute('data-loaded', 'false');
                    tr.setAttribute('data-parentID', code.ParentID);

                    var tdDesc = document.createElement('td');
                    tdDesc.setAttribute('data-name', 'Description');
                    tdDesc.className = code.HasChildren ? 'Tree WithtParent WithtChildren' : 'Tree WithtParent WithoutChildren';

                    var span1 = document.createElement('span');
                    span1.setAttribute('id', code.ID);
                    span1.className = 'expandButton';
                    span1.innerHTML = '<i class="fa fa-plus"></i>';
                    span1.style.marginLeft = (left * 1 + 10) + 'px';


                    //event for open next children
                    if (code.HasChildren) {
                        $(span1).on('click', function () {
                            ExpandChildren(code.ID);
                        });
                    }

                    var span2 = document.createElement('span');
                    span2.className = 'descSpan';
                    span2.innerHTML = code.Description;
                    span2.style.marginLeft = (left * 1 + 28) + 'px';

                    //row description
                    tdDesc.appendChild(span1);
                    tdDesc.appendChild(span2);

                    tr.appendChild(tdDesc);
                    tr.appendChild(createTD('ID', code.ID, response.hd[1]));
                    tr.appendChild(createTD('Code', code.Code, response.hd[2]));
                    tr.appendChild(createTD('CategoryID', window.GetDesciption('TableCategoryList', code.CategoryID), response.hd[3]));
                    tr.appendChild(createTD('CallType', window.GetDesciption('TableCallTypeListList', code.CallType), response.hd[4]));
                    tr.appendChild(createTD('Latitude', code.Latitude, response.hd[5]));
                    tr.appendChild(createTD('Longitude', code.Longitude, response.hd[6]));
                    tr.appendChild(createTD('Distance', code.Distance, response.hd[7]));
                    tr.appendChild(createTD('Rate', window.GetDesciption('TableRateList', code.RateID), response.hd[8]));
                    tr.appendChild(createTD('FromDate', code.FromDate, response.hd[9]));
                    tr.appendChild(createTD('ToDate', code.ToDate, response.hd[10]));

                    tr.style.display = 'none';

                    $('#tableWithDestinationCodes tr[data-id="' + ed + '"]')[0].closest('tr').after(tr);
                    ed = code.ID;
                });
            }

            OpenChildren(response.id);
            window.IsBussy = false;
            NeedSetSize = true;
        }
    });
}

function OpenChildren(id) {
    $('#tableWithDestinationCodes tr[data-parentID="' + id + '"]').show();
}

function CloseChildren(id) {
    //close openen children
    var collection = $('#tableWithDestinationCodes tr[data-parentid="' + id + '"]');
    $(collection).hide();

    collection.each(function (index) {

        if ($(collection[index]).attr('data-opened') == 'true') {
            CloseChildren($(collection[index]).attr('data-id'));
        }
        
        $($('#tableWithDestinationCodes tr[data-id="' + (id + '') + '"]')[0]).attr('data-opened', false);
        GetIcon(id).css('transform', 'rotate(0)');
    });
}

function GetIcon(id) {
    //get icon for animate
    var element = $($("td").filter(function () { return $(this).text() == id; }).closest("tr")[0].children[0].children[0]);
    return element;
}

function ExpandChildren(id, async = true) {
    var ID = id + ''; //always must be string

    var parent = $('#tableWithDestinationCodes tr[data-id="' + ID + '"]')[0];
    //load
    if ($(parent).attr('data-opened') == 'false' && $(parent).attr('data-loaded') == 'false') {
        LoadChildren(ID, async)

        $(parent).attr('data-opened', true);
        $(parent).attr('data-loaded', true);
        GetIcon(ID).css('transform', 'rotate(45deg)');
    }
    //open children
    else if ($(parent).attr('data-opened') == 'false' && $(parent).attr('data-loaded') == 'true') {
        OpenChildren(ID);
        $(parent).attr('data-opened', true);
        GetIcon(ID).css('transform', 'rotate(45deg)');
    }
    //hide children
    else {
        CloseChildren(ID);
    }
}

function SticyTableHead() {
    $('#tableWithDestinationCodesHead').addClass('visHead');

    if (NeedSetSize) {
        for (var i = 0; i < 11; i++) {
            var row = $('#col_' + i);
            if (row.attr('hidden') != 'hidden')
                $('#col_0' + i).width(row.width());
        }
        NeedSetSize = false;
    }

}

$(document).ready(function () {

    var header = document.getElementById("destinationHeader");       //for sticky head
    var sticky = header.offsetTop;                                   //for sticky head

    window.IsLoading = false;

    //attach event for first root elements
    var buttons = document.getElementsByClassName("expandButton");
    for (let item of buttons) {
        $(item).on('click', function () {
            ExpandChildren($(this).attr('id'));
        });
    }

    //animate scroll top
    $('.go-top').on('click', function (event) {
        event.preventDefault();
        $('html, body').animate({ scrollTop: 0 }, 300);
    });

    //scroll spy
    //load new chunk of codes if scroll in bottom
    if ($('#tableWithDestinationCodes').hasClass('NotTree'))
        $(window).on("scroll", function () {
            var scrollHeight = $(document).height();
            var scrollPosition = $(window).height() + $(window).scrollTop();
            if ((scrollHeight - scrollPosition) / scrollHeight < 0.35) {
                if (!window.IsLoading) {
                    window.IsLoading = true;
                    LoadChunk();
                }
            }

            //for sticky head
            if (window.pageYOffset > sticky) {
                header.classList.add("sticky");
                SticyTableHead();
            } else {
                header.classList.remove("sticky");
                $('#tableWithDestinationCodes').removeClass('stickyTB');
                $('#tableWithDestinationCodesHead').removeClass('visHead');
            }

            //for go top button
            if ($(this).scrollTop() > 200) {
                $('.go-top').fadeIn(200);
            } else {
                $('.go-top').fadeOut(200);
            }
        });
    else {
        $(window).unbind('scroll');
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > sticky) {
                header.classList.add("sticky");
                SticyTableHead();
            } else {
                header.classList.remove("sticky");
                $('#tableWithDestinationCodes').removeClass('stickyTB');
                $('#tableWithDestinationCodesHead').removeClass('visHead');
            }

            //for go top button
            if ($(this).scrollTop() > 200) {
                $('.go-top').fadeIn(200);
            } else {
                $('.go-top').fadeOut(200);
            }
        });
    }

    //expand to new add/edit/copy
    if (window.ExpandID != null) {
        window.ExpandID.forEach(async function (e) {
            ExpandChildren(e, false);
        });
        window.ExpandID = null;
    }

    //make selected new Add/Edit/Copy
    if (window.SelectCallback != null) {
        window.SelectCallback();
        window.SelectCallback = null;
    }
});