﻿$(document).ready(() => {
    let selectedAux = null;

    function UpdateAuxButtonUI() {
        if (selectedAux === null) {
            $('#btnEditAux').prop('disabled', true);
            $('#btnDeleteAux').prop('disabled', true);
        }
        else {
            $('#btnEditAux').prop('disabled', false);
            $('#btnDeleteAux').prop('disabled', false);
        }
    }

    function AttachEventsToAux() {
        selectedAux = null;

        $('#tariscope-abonent-aux tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedAux = null;
            }
            else {
                selectedAux = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-abonent-aux tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateAuxButtonUI();
        });

        UpdateAuxButtonUI();
    }

    function LoadAuxIDs() {
        $('#auxsTable').load('/Subscribers/LoadAuxIDs/' + $('#AbonentID').val(), AttachEventsToAux);
    }

    //back to abonent
    $('#btnBackToAbonentFromAux').on('click', () => {
        $('#additionalSection').slideUp('fast');
        $('#editSection').slideDown('fast');

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetAux/' + $('#AbonentID').val(),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#AbonentAux').val(response.a);
                }
            }
        });
    });

    //show modal for delete abonent contact
    $('#btnDeleteAux').on('click', () => { $('#deleteAbonentAuxmodal').modal('show'); });

    //confirm delete ccontact
    $('#deleteAbonentAuxConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/DeleteAuxID/' + selectedAux,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#deleteAbonentAuxmodal').modal('hide');
                    LoadAuxIDs();
                }
            }
        });
    });

    //show modal for add abonent contact
    $('#btnAddAux').on('click', () => {
        $('#abAuxID').val(0);
        $('#abAux').val('');
        $('#abAuxType').val('');
        $('#aAuxDescription').val('');

        $('#abauxRequired').hide();
        $('#editAbonentAuxtitle').text($('#newAbaux').val());
        $('#saveAbaux').prop('disabled', true);

        $('#editAbonentAuxmodal').modal('show');
    });

    //show error when contact field is emprt
    $('#abAux').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#abauxRequired').slideDown('fast');
            $('#saveAbaux').prop('disabled', true);
        }
        else {
            $('#abauxRequired').slideUp('fast');
            $('#saveAbaux').prop('disabled', false);
        }
    });

    //save abonent contact
    $('#saveAbaux').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/SaveAuxID/' + $('#abAuxID').val()
                + '/' + $('#AbonentID').val()
                + '/' + $('#abAuxPBX').val()
                + '/?AuxID=' + encodeURIComponent($('#abAux').val())
                + '&Type=' + encodeURIComponent($('#abAuxType').val())
                + '&Description=' + encodeURIComponent($('#aAuxDescription').val()),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#editAbonentAuxmodal').modal('hide');
                    LoadAuxIDs();
                }
            }
        });
    });

    //show modal for edit contact
    $('#btnEditAux').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetAuxID/' + selectedAux,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#abAuxID').val(response.aux.ID);
                    $('#abAuxPBX').val(response.aux.PBXID);
                    $('#abAux').val(response.aux.AuxID);
                    $('#abAuxType').val(response.aux.TelephoneType);
                    $('#aAuxDescription').val(response.aux.Description);

                    $('#abauxRequired').hide();
                    $('#editAbonentAuxtitle').text($('#editAbaux').val());
                    $('#saveAbaux').prop('disabled', false);

                    $('#editAbonentAuxmodal').modal('show');
                }
            }
        });
    });

    LoadAuxIDs();
});