﻿let isProvider = $('#CallProviderID').val() !== "";
let providerID = $('#CallProviderID').val();
let curentLang = getCookie('CurrentLanguage');
let chunk = null;

$(document).ready(() => {
    let ClasterSize = 50;
    let LoadSize = ClasterSize;
    let lastScrollProgres = 0;

    function InitTable() {
        window.clusterize = new Clusterize({
            scrollId: 'scrollArea',
            contentId: 'contentArea',
            rows_in_block: ClasterSize,
            callbacks: {
                scrollingProgress: function (progress) {
                    if ((lastScrollProgres < progress) && progress > 30) {
                        LoadChunk();
                    }
                    lastScrollProgres = progress;
                },
                clusterChanged: function () { GetBackSelected(); }
            }

        });

        AttachEventsToTable();
    }

    function SetHeight() {
        windowHeight = window.innerHeight -
            $('.main-header').outerHeight() -
            $('.content-header').outerHeight() -
            $('.box-header').outerHeight() -
            $('#totalData').outerHeight() -
            $('.main-footer').outerHeight();

        if (windowHeight < 400)
            windowHeight = 400;

        $('.clusterize-scroll').css('max-height', windowHeight + 'px');
        window.clusterize.refresh();
    }

    function LoadChunk() {
        if (chunk === null) {
            chunk = $.ajax({
                type: "POST",
                url: '/TelephoneCodes/GetRows/' + window.clusterize.getRowsAmount() + '/' + LoadSize + '/?Search=' + encodeURIComponent($('#tbSearch').val()) + '&ProviderID=' + providerID,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        let rows = [];
                        response.rows.map(i => {
                            rows.push(GetRow(i, false));
                        });

                        window.clusterize.append(rows);

                        chunk = null;
                    }
                }
            });
        }
    }

    //resize window
    $(window).resize(SetHeight);

    InitTable();
    SetHeight();
    LoadChunk();
});