﻿$(document).ready(function () {
    var updateInterval = 2000;
    var currentEquipment = null;

    $('#ok-modal-equipment-selection').prop("disabled", true);

    UpdateProfile();
    FillProfile();

    function MapModelData(data) {
        data.forEach((ev, i, arr) => {
            let event = observerScriptsData.events.find(e => e.name === ev.EventName);
            event.script.name = ev.Script.FileName;

            if (event.name === 'SubscriberCosChanged' || event.name === 'DepartmentCosChanged') {
                event.interval = ev.Interval;
                event.autoConnectionDate = ev.AutoconnectionDate;
            }
            else if (event.name === "PeriodicAction") {
                event.interval = ev.Interval;
            }
        });
    }

    function FillProfile() {
        $.ajax({
            type: "GET",
            url: "/api/datasources/" + GetProfileName() + "/configuration",
            contentType: "application/json",
            success: function (model) {
                MapModelData(model.Scripts);

                var operationType = $('#operation-type').val();

                if (model.Equipment !== null || currentEquipment !== null) {
                    FillDatasourceConfig(model);
                } else {
                    set_cookie("emptyEquipment", "true");
                    $('.dialogEquipmentSelection').click();
                }
            },
            dataType: "json"
        });
    }

    function UpdateProfile() {
        $.ajax({
            type: "GET",
            url: "/api/tariscopeservices/" + GetProfileName() + "/running",
            contentType: "application/json",
            success: function (running) {
                console.log("STATUS");
                console.log(running);

                ChangeToolsButtonsState(running);
                setTimeout(UpdateProfile, updateInterval);
            },
            dataType: "json"
        });
    };

    $("#testclick").click(function () {
        var nodeSelect = $("#testclick");

        console.log(nodeSelect.attr("disabled"));

        if (nodeSelect.attr("disabled") === "disabled") {
            console.log("Service is running");
            return false;
        }
    })

    function ChangeToolsButtonsState(running) {
        $('#start-datasource-config').attr('disabled', running);
        $('#stop-datasource-config').attr('disabled', !running);

        $('#testclick').attr('disabled', running);
        $('#save-datasource-config').attr('disabled', running);

        $.each($("#datasources-radio input, #datasources-radio select"), function (index, value) {
            $(this).prop("disabled", running);
        });

        $.each($("#datasource-configuration input, #datasource-configuration select"), function (index, value) {
            $(this).prop("disabled", running);
        });

        $("#datasource-scripts").prop("disabled", running);
    }

    function EnableConfigBoxTools(enable) {
        $('#datasource-configuration .box-tools button').attr('disabled', !enable);
    }

    function FillDatasourceConfig(model) {
        ShowDatasource(model.DatasourceType);

        if (model.Equipment !== null) {
            AddEquipment(model.Equipment.Name, model.Equipment.PBXType, model.PbxId);
        }
        else if (currentEquipment !== null) {
            AddEquipment(currentEquipment.Name, currentEquipment.PBXType, currentEquipment.PbxId);
        }
        else {
            return;
        }

        EnableConfigBoxTools(true);

        var config = model.DatasourceConfiguration;
        var config$ = $('#datasource-configuration .box-body').children('div:not(:hidden)');

        $.each($(config$).find('input[type="text"], input[type="password"]'), function (index, input) {
            $.each(config, function (key, val) {
                if ($(input).data('name') === key) {
                    inputVal = val;

                    if (key === 'RefreshInterval') {
                        inputVal = ConvertTimeSpanToSeconds(val);
                    } else if (key === 'LastDate') {
                        inputVal = val.replace('T', ' ');
                    }
                    $(input).val(inputVal);
                }
            });
        });

        $.each($(config$).find('input[type="checkbox"]'), function (index, input) {
            $.each(config, function (key, val) {

                if ($(input).data('name') === key) {
                    $(input).prop('checked', val);
                }
            });
        });

        $.each($(config$).find('select'), function (index, input) {
            $.each(config, function (key, val) {
                if ($(input).data('name') === key) {
                    $(input).val(val);
                }
            });
        });

        $.ajax({
            type: "GET",
            url: "/api/datasources",
            contentType: "application/json",
            success: function (datasources) {
                var radios = '';

                $.each(datasources, function (key, description) {
                    radios +=
                        '<div class="radio">'
                            + '<label>'
                                + '<input type="radio" name="datasources" value="' + description + '">'
                                + description
                            + '</label>'
                        + '</div>'
                });

                $('#datasources-radio').html(radios);
                $('input[type="radio"][name="datasources"][value="' + model.DatasourceType + '"]').attr('checked', true);
            },
            dataType: "json"
        });

        $.each($('#configuration-cdr-storage').find('input[type=text], select'), function (index, input) {
            $.each(model, function (key, val) {
                if ($(input).data('name') === key) {
                    $(input).val(val);
                }
            });
        });
    };

    $('#datasources-radio').on('change', 'input[type=radio][name=datasources]', function () {
        $('#datasource-configuration').find('h3').html($(this).closest('label').text());
        $('#datasource-configuration .box-body').children().attr('hidden', 'hidden');
        $('#configuration-cdr-storage').children().removeAttr('hidden');
        EnableConfigBoxTools(true);
        ShowDatasource($(this).val());
    });

    function ShowDatasource(datasourceName) {
        switch (datasourceName) {
            case "Asterisk AMI":
                $('#asterisk-ami').removeAttr('hidden');
                break;
            case "Microsoft Lync":
                $('#microsoft-lync').removeAttr('hidden');
                break;
            case "MsSql":
                $('#ms-sql-server-database').removeAttr('hidden');
                break;
            case "MySql":
                $('#mysql-server-database').removeAttr('hidden');
                break;
            case "SFTP Client":
                $('#sftp-client').removeAttr('hidden');
                break;
            case "SFTP Server":
                $('#sftp-server').removeAttr('hidden');
                break;
            case "SSH Client":
                $('#ssh-client').removeAttr('hidden');
                break;
            case "Rlogin client":
                $('#rlogin-client').removeAttr('hidden');
                break;
            case "UDP":
                $('#udp-server').removeAttr('hidden');
                break;
            case "FTP Server":
                $('#ftp-server').removeAttr('hidden');
                break;
            case "FTP Client":
                $('#ftp-client').removeAttr('hidden');
                break;
            case "File":
                $('#folder-file').removeAttr('hidden');
                break;
            case "Serial port":
                $('#serial-port').removeAttr('hidden');
                break;
            case "TCP Client":
                $('#tcp-client').removeAttr('hidden');
                break;
            case "TCP":
                $('#tcp-ip-server').removeAttr('hidden');
                break;
            default:
                EnableConfigBoxTools(false);
                break;
        }
    };

    $('#datasource-configuration').on('click', '#save-datasource-config', function () {
        SaveProfile();
    });

    function SaveProfile() {
        var config = {};
        var config$ = $('#datasource-configuration .box-body').children('div:not(:hidden)');
        var datasourceType = $('#datasources-radio input[type=radio]:checked').val();

        $.each($(config$).find('input[type="text"], input[type="password"]'), function (index, value) {
            var inputVal = $(this).val();

            if ($(this).data('name') === 'RefreshInterval') {
                inputVal = ConvertSecondsToTimeSpan($(this).val());
            }

            config[$(this).data('name')] = inputVal
        });

        $.each($(config$).find('input[type="checkbox"]'), function (index, value) {
            config[$(this).data('name')] = $(this).is(':checked');
        });

        $.each($(config$).find('select'), function (index, value) {
            config[$(this).data('name')] = $(this).val();
        });

        var observerConfig = {};

        $.each($('#configuration-cdr-storage').find('input[type=text], select'), function (index, value) {
            observerConfig[$(this).data('name')] = $(this).val();
        });

        observerConfig['DatasourceConfiguration'] = config;
        observerConfig['DatasourceType'] = datasourceType;
        observerConfig['PbxId'] = $('section.content-header small a').data('pbx-id');
        observerConfig['Scripts'] = Map(observerScriptsData.events);

        var lastProfileName = GetLastProfileName();
        var profileName = GetProfileName();

        $.ajax({
            type: "PUT",
            async: false,
            url: "/api/tariscopeservices/" + lastProfileName + "/delete",
            contentType: "application/json",
            dataType: "json"
        });

        $.ajax({
            type: "POST",
            async: false,
            url: "/api/datasources/" + profileName + "/configuration",
            contentType: "application/json",
            data: JSON.stringify(observerConfig),
            dataType: "json"
        });
    }

    function Map(events) {
        let mappedEvents = [];

        events.forEach((ev, i, arr) => {
            let dt = Date.parse(ev.autoConnectionDate) || 0;
            let event = {
                EventName: ev.name,
                Script: {
                    FileName: ev.script.name,
                    Content: ev.script.content
                },
                Interval: ev.interval,
                AutoconnectionDate: new Date(dt)
            };

            mappedEvents.push(event);
        });

        return mappedEvents;
    }

    $('#datasource-configuration').on('click', '#start-datasource-config', function () {
        SaveProfile();

        $.ajax({
            type: "PUT",
            url: "/api/tariscopeservices/" + GetProfileName() + "/start",
            contentType: "application/json",
            dataType: "json"
        });
    });

    $('#datasource-configuration').on('click', '#stop-datasource-config', function () {
        $.ajax({
            type: "PUT",
            url: "/api/tariscopeservices/" + GetProfileName() + "/stop",
            contentType: "application/json",
            dataType: "json"
        });
    });

    $('#datasource-configuration').on('click', '.dialogEditConnectionString', function (e) {
        e.preventDefault();

        $.get(this.href, function (data) {
            $('#dialogEditConnectionString').html(data);
            $('#modEditConnectionString').modal('show');
            var isMySql = false;

            if ($('#datasources-radio input[type=radio]:checked').val() === "MySql") {
                isMySql = true;
            }

            FillConnectionStringForm(GetSelectedConnectionString(), isMySql);
        });
    });

    $('#datasource-configuration').on('click', '.dialogEditConnection', function (e) {
        e.preventDefault();

        $.get(this.href, function (data) {
            $('#dialogEditConnection').html(data);
            $('#modEditConnection').modal('show');
        });
    });


    $(document).on('click', '.dialogEquipmentSelection', function (e) {
        e.preventDefault();

        $.get(this.href, function (data) {
            $('#dialogEquipmentSelection').html(data);

            $('#ok-modal-equipment-selection').prop("disabled", true);
            $('#modEquipmentSelection').modal('show');
        });
    });

    $(document).on('click', '#equipment-selection-tree tbody tr', function () {
        var selectedEquipment = $.BlackGrid.GetSelectedObject('equipment-selection-tree');

        var buttonOk = $('#ok-modal-equipment-selection');

        if (selectedEquipment.parentId === null) {
            buttonOk.prop("disabled", true);
        }
        else {
            buttonOk.prop("disabled", false);
        }
    });

    $(document).on('click', '#ok-modal-equipment-selection', function () {
        var selectedEquipment = $.BlackGrid.GetSelectedObject('equipment-selection-tree');

        if (selectedEquipment.type !== "") {
            AddEquipment(selectedEquipment.name, selectedEquipment.type, selectedEquipment.displayId);

            currentEquipment = {};
            currentEquipment.Name = selectedEquipment.name;
            currentEquipment.PBXType = selectedEquipment.type;
            currentEquipment.PbxId = selectedEquipment.displayId;

            $('#modEquipmentSelection').modal('hide');

            if (get_cookie("mode") === "add") {
                set_cookie("mode", "edit");
                set_cookie("profileName", GetProfileName());
                FillProfile();
            }

            if (get_cookie("emptyEquipment") === "true") {
                set_cookie("emptyEquipment", "false");
                FillProfile();
            }
        }
    });

    $(document).on('click', '#close-modal-equipment-selection', function () {
        var selectedEquipment = $('section.content-header small').text();

        if (selectedEquipment === "") {
            window.top.close();
        }
    });

    function AddEquipment(name, type, pbxId) {
        var headerText = 'Equipment: ' + '<a href="/Equipments/EquipmentSelectionTree" class="dialogEquipmentSelection" data-pbx-id="' + pbxId + '">' + name + '</a>. Type: ' + type + '.';
        $('section.content-header small').html(headerText);
    }

    $(document).on('click', '#ok-modal-change-connection-string', function () {
        var connectionString = '';
        var authentication = $('#change-connection-string select[data-name="authentication"]').val();
        var serverName = $('#change-connection-string input[data-name="serverName"]').val();
        var databaseName = $('#change-connection-string input[data-name="databaseName"]').val();
        var login = $('#change-connection-string input[data-name="login"]').val();
        var password = $('#change-connection-string input[data-name="password"]').val();

        var isMySql = false;

        if ($('#datasources-radio input[type=radio]:checked').val() === "MySql") {
            isMySql = true;
        }

        if (!isMySql) {
            if (authentication === "windows") {
                connectionString = 'Data Source=' + serverName + ';Initial Catalog=' + databaseName + ';Integrated Security=true;Asynchronous Processing=true';
            } else {
                connectionString = 'Data Source=' + serverName + ';Initial Catalog=' + databaseName + ';Integrated Security=false;User ID=' + login + ';Password=' + password + ';Asynchronous Processing=true';
            }
        }
        else {
            if (authentication === "windows") {
                connectionString = 'Server=' + serverName + ';Database=' + databaseName + ';Integrated Security=true';
            } else {
                connectionString = 'Server=' + serverName + ';Database=' + databaseName + ';Integrated Security=false;User ID=' + login + ';Password=' + password;
            }
        }

        ChangeSelectedConnectionString(connectionString);
        $('#modEditConnectionString').modal('hide');
    });

    function GetSelectedConnectionString() {
        var config$ = $('#datasource-configuration .box-body').children('div:not(:hidden)');
        var cn = $(config$).find('input[data-name="ConnectionString"]').val();
        return cn;
    };

    function ChangeSelectedConnectionString(connectionString) {
        $('#datasource-configuration .box-body').children('div:not(:hidden)').find('input[data-name="ConnectionString"]').val(connectionString);
    };

    function FillConnectionStringForm(connectionString, isMySql) {
        var server = "";
        var database = "";
        var login = "";
        var password = "";
        var isIntegratedSecurity = "false";
        var cnStr = connectionString.split(';');

        if (cnStr.length === 0) return;

        if (isMySql) {

            for (let i = 0; i < cnStr.length; i++) {
                if (cnStr[i].indexOf("Server=") !== -1) server = cnStr[i].trim().replace("Server=", "");
                else if (cnStr[i].indexOf("Database=") !== -1) database = cnStr[i].trim().replace("Database=", "");
                else if (cnStr[i].indexOf("User ID=") !== -1) login = cnStr[i].trim().replace("User ID=", "");
                else if (cnStr[i].indexOf("Password=") !== -1) password = cnStr[i].trim().replace("Password=", "");
                else if (cnStr[i].indexOf("Integrated Security=") !== -1) isIntegratedSecurity = cnStr[i].trim().replace("Integrated Security=", "");
            }

        } else {
            for (let i = 0; i < cnStr.length; i++) {
                if (cnStr[i].indexOf("Data Source=") !== -1) server = cnStr[i].trim().replace("Data Source=", "");
                else if (cnStr[i].indexOf("Initial Catalog=") !== -1) database = cnStr[i].trim().replace("Initial Catalog=", "");
                else if (cnStr[i].indexOf("User ID=") !== -1) login = cnStr[i].trim().replace("User ID=", "");
                else if (cnStr[i].indexOf("Password=") !== -1) password = cnStr[i].trim().replace("Password=", "");
                else if (cnStr[i].indexOf("Integrated Security=") !== -1) isIntegratedSecurity = cnStr[i].trim().replace("Integrated Security=", "");
            }

            if (isIntegratedSecurity.toLowerCase() === "true") {
                $('#change-connection-string select[data-name="authentication"] option[value=windiws]').prop('selected', true);

                $('#change-connection-string input[data-name="login"]').prop("disabled", true);
                $('#change-connection-string input[data-name="password"]').prop("disabled", true);
            }
            else {
                $('#change-connection-string select[data-name="authentication"] option[value=sql]').prop('selected', true);

                $('#change-connection-string input[data-name="login"]').prop("disabled", false);
                $('#change-connection-string input[data-name="password"]').prop("disabled", false);

                $('#change-connection-string input[data-name="login"]').val(login);
                $('#change-connection-string input[data-name="password"]').val(password);
            }
        }

        $('#change-connection-string #serverName').val(server);
        $('#change-connection-string #databaseName').val(database);
    };

    function ConvertTimeSpanToSeconds(time) {
        var s = time.split(':');
        var seconds = (+s[0]) * 60 * 60 + (+s[1]) * 60 + (+s[2]);
        return seconds;
    }

    function ConvertSecondsToTimeSpan(seconds) {
        var sec_num = parseInt(seconds);
        var hours = Math.floor(sec_num / 3600);
        var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
        var seconds = sec_num - (hours * 3600) - (minutes * 60);

        if (hours < 10) { hours = "0" + hours; }
        if (minutes < 10) { minutes = "0" + minutes; }
        if (seconds < 10) { seconds = "0" + seconds; }
        var time = hours + ':' + minutes + ':' + seconds;
        return time;
    }

    function GetLastProfileName() {
        return get_cookie("profileName");
    };

    function GetProfileName() {
        return $('section.content-header h1 input').val();
    };
});