﻿$(document).ready(() => {
    let graph = null;

    function initDateTimepickers() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepicker').datetimepicker(daytimeOpitions);
        $('#datetimepickerPeriod').datetimepicker(daytimeOpitions);
    }

    function Resize() {
        let windowHeight = window.innerHeight -
            $('.main-header').outerHeight() -
            $('.content-header').outerHeight() -
            $('.box-header').outerHeight() -
            $('.main-footer').outerHeight() - 90;

        if (windowHeight < 300)
            windowHeight = 300;

        $('#graph').css('height', windowHeight + 'px');
    }

    function ShowLoader() {
        $('.graphLoader').show();
        $('.graphLoader').animate({ opacity: 1 }, 500);
    }

    function HideLoader() {
        $('.graphLoader').animate({ opacity: 0 }, 500, () => { $('.graphLoader').hide(); });
    }

    function DrawChart(container, dataForGraph, date) {
        let TITLE = $('#LblPeriod').val() +
            ' (' + dataForGraph.PeriodName + '): ' +
            dataForGraph.Period + ', ' +
            $('#LblTotalCalls').val() + ': ' +
            dataForGraph.Calls;

        let CALLS = $('#LblCalls').val();
        let FROM = $('#LblFrom').val();
        let TO = $('#LblTo').val();

        //ticks
        let ticks = [];
        for (tick in dataForGraph.Ticks) {
            ticks.push([tick * 1, dataForGraph.Ticks[tick] + '']);
        }

        //views
        let views = [];
        dataForGraph.Views.forEach(e => {
            //data here
            let values = [];
            for (value in e.Data) {
                values.push([value * 1, e.Data[value] * 1]);
            }
            views.push({ data: values, label: e.Name });
        });

        graph = Flotr.draw(container, views, {
            HtmlText: false,
            bars: {
                show: true,
                lineWidth: 1,
                barWidth: 0.7,
                shadow: 0,
                shadowSize: 0,
                fill: true,
                fillColor: null,
                fillOpacity: 0.8,
                horizontal: false,
                stacked: false,
                centered: true,
                topPadding: 0.1,
                grouped: false
            },
            mouse: {
                track: true,
                trackFormatter: function (e) {
                    let prefix = views.length > 1 ? '[' + e.series.label + '] ' : '';


                    switch (dataForGraph.MaskNum) {
                        case 0:
                            return prefix + FROM + ' ' +
                                date.getHours() + ':' +
                                date.getMinutes() + ':' +
                                ticks[e.x - 1][1] + ':000 ' + TO + ' ' +
                                date.getHours() + ':' +
                                date.getMinutes() + ':' +
                                ticks[e.x - 1][1].split(':')[0] +
                                ':999, ' + CALLS + ': ' + e.y;
                        case 1:
                            return prefix + FROM + ' ' +
                                date.getHours() + ':' +
                                ticks[e.x - 1][1] + ' ' + TO + ' ' +
                                date.getHours() + ':' +
                                ticks[e.x - 1][1].split(':')[0] +
                                ':59, ' + CALLS + ': ' + e.y;
                        case 2:
                            return prefix + FROM + ' ' + ticks[e.x - 1][1] + ' ' +
                                TO + ' ' + ticks[e.x - 1][1].split(':')[0] +
                                ':59, ' + CALLS + ': ' + e.y;
                        case 3:
                        case 5:
                            return prefix + ticks[e.x - 1][1] + ', ' + CALLS + ': ' + e.y;
                        case 4:
                            return prefix + ticks[e.x - 1][1] + ' ' + dataForGraph.AdditionalData + ', ' + CALLS + ': ' + e.y;
                        default:
                            return "";
                    }
                },
                trackDecimals: 0,
                relative: false,
                position: 'ne',
                lineColor: '#ffff00',
                sensibility: 2,
                trackY: true,
                radius: 3,
                margin: 5,
                mouseTextColor: '#ffffff',
                mouseBGColor: '#000000',
                boxAlpha: '0.8',
                fillColor: null,
                fillOpacity: 0.8
            },
            yaxis: {
                min: 0,
                max: dataForGraph.Max + 5,
                noTicks: dataForGraph.Max < 5 ? 5 : (dataForGraph.Max < 20 ? 10 : 20),
                title: $('#LblCallsLeft').val()
            },
            xaxis: {
                mode: 'normal',
                noTicks: ticks.length,
                ticks: ticks,
                labelsAngle: ticks.length < 32 ? 0 : (ticks.length < 90) ? 45 : 90,
                title: $('#LblTime').val()
            },
            title: TITLE,
            legend: {
                position: 'nw'
            }
        });

        HideLoader();
    }

    function StartDraw(date) {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/TrafficCalculation/Get/?Begin=' + encodeURIComponent(date.toISOString()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    DrawChart(document.getElementById('graph'), response.cdm, date);
                }
            }
        });
    }

    function AttachEvents() {
        //date was changed, redraw graph
        $('#datetimepicker').on('dp.change', function (e) {
            ShowLoader();

            StartDraw(new Date(e.date));
        });

        //refresh graph
        $('#btnRefresh').on('click', () => {
            ShowLoader();
            StartDraw($('#datetimepicker').data('DateTimePicker').date.toDate());
        });

        //next chank of period
        $('#btnNext').on('click', () => {
            ShowLoader();
            $.ajax({
                type: "POST",
                async: true,
                url: '/TariscopeViews/TrafficCalculation/GetNext/?Begin=' + encodeURIComponent($('#datetimepicker').data('DateTimePicker').date.toDate().toISOString()),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        let dt = new Date(response.date);
                        try { $('#datetimepicker').data("DateTimePicker").setDate(dt); } catch (e) { console.log(e); }
                    }
                }
            });
        });

        //prev chank of period
        $('#btnPrev').on('click', () => {
            ShowLoader();
            $.ajax({
                type: "POST",
                async: true,
                url: '/TariscopeViews/TrafficCalculation/GetPrev/?Begin=' + encodeURIComponent($('#datetimepicker').data('DateTimePicker').date.toDate().toISOString()),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        let dt = new Date(response.date);
                        try { $('#datetimepicker').data("DateTimePicker").setDate(dt); } catch (e) { console.log(e); }
                    }
                }
            });
        });

        //open modal for chnage period
        $('#btnSetPeriod').on('click', () => {
            $.ajax({
                type: "POST",
                async: true,
                url: '/TariscopeViews/TrafficCalculation/GetGrafInfo/',
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {

                        let dt = new Date(response.date);
                        try { $('#datetimepickerPeriod').data("DateTimePicker").setDate(dt); } catch (e) { console.log(e); }

                        $('#periodForGraph').val(response.period);

                        $('#changePeriodmodal').modal('show');
                    }
                }
            });
        });

        //update period
        $('#changePeriodBtn').on('click', () => {
            $.ajax({
                type: "POST",
                async: true,
                url: '/TariscopeViews/TrafficCalculation/SetPeriod/?Begin=' + encodeURIComponent($('#datetimepickerPeriod').data('DateTimePicker').date.toDate().toISOString()) +
                    '&Period=' + $('#periodForGraph').val(),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        let dt = new Date(response.date);
                        try { $('#datetimepicker').data("DateTimePicker").setDate(dt); } catch (e) { console.log(e); }

                        if ($('.graphLoader').css('opacity') * 1 <= 0) {
                            ShowLoader();
                            StartDraw(dt);
                        }

                        $('#changePeriodmodal').modal('hide');
                    }
                }
            });
        });

        //download graph as img
        $('.SaveGraph').on('click', function () {
            graph.download.saveImage($(this).data('extension'), null, null, true)
            $('#chartDownloadLink').prop('href', $('#graph > img').prop('src').replace(/^data:image\/[^;]+/, 'data:application/octet-stream'))
            $('#chartDownloadLink').prop('download', graph.options.title + '.' + $(this).data('extension'));
            graph.download.restoreCanvas();
            $('#downloadImg').modal('show');
        });
    }

    function Start() {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/TrafficCalculation/GetStart/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    initDateTimepickers();
                    let dt = new Date(response.date);
                    try { $('#datetimepicker').data("DateTimePicker").setDate(dt); } catch (e) { console.log(e); }
                    AttachEvents();
                    StartDraw(dt);
                }
            }
        });
    }

    //resize
    $(window).resize(() => {
        if (graph !== null) {
            Resize();
        }
    });

    Resize();
    Start();
});