﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using SoftPi.Tariscope.Common;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using Microsoft.Data.SqlClient;
using SoftPi.Tariscope.DAL;

/// <summary>

/// ''' Limiting script for Nortel/Avaya CS1000

/// ''' </summary>

/// ''' <remarks></remarks>
public class SetCosCS1000Script : IScript
{
    private IScriptHost _host;

    const string PBX_LOGIN = "admin";
    const string PBX_PASSWORD = "0000";
    const int PBXTYPE = 0;                     // if =1 - full TN format (loop,shelf,card,unit),else - reduced format (c,u)


    public void Init(IScriptHost host)
    {
        _host = host;
        host.Close += OnClose;
    }
    private void OnClose(ref bool Cancel)
    {
        return;
    }
    public void Main(object Parameters)
    {
        try
        {
            SubscriberLimitingActionParameters ActionParameters = (SubscriberLimitingActionParameters)Parameters;

            _host.AddEvent(string.Format("Restrict subscriber:{0} Cos:{1}, Category: {2}", ActionParameters.Abonent.AbonentName, ActionParameters.CosValue, ActionParameters.Credit.CategoryID));
            _host.AddEvent(ActionParameters.ActionType.ToString());

            string CategoryName;
            List<DN> Dns;
            List<AuxID> Tns;
            using (SqlConnection cn = new SqlConnection(_host.DatabaseConnectionString))
            {
                cn.Open();
                if (ActionParameters.Credit.CategoryID.HasValue)
                    CategoryName = new Categories(cn).Details(ActionParameters.Credit.CategoryID.Value).Name;
                else
                    CategoryName = "All categories";
                Dns = DNs.Instance(cn).Load(ActionParameters.Abonent.ID).Where(x => DateTime.Now > x.FromDateValue && DateTime.Now < x.ToDateValue).ToList();
                Tns = AuxIDs.Instance(cn).Load(ActionParameters.Abonent.ID).ToList();
            }


            _host.Send("****"); // Do logout
            _host.Wait(100);
            _host.Send("LOGO" + Convert.ToChar(13).ToString()); // Do logout
            _host.Wait(100);
            _host.Send(Convert.ToChar(13).ToString()); // Request response
            _host.WaitFor("OVL");
            _host.Wait(100); // wait some time
            if (PBX_LOGIN.Length > 0)
                _host.Send("LOGI " + PBX_LOGIN + Convert.ToChar(13).ToString());
            else
                _host.Send("LOGI" + Convert.ToChar(13).ToString());
            _host.WaitFor("PASS?");

            _host.Send(PBX_PASSWORD + Convert.ToChar(13).ToString());
            _host.WaitFor(">");

            _host.Send("LD 10" + Convert.ToChar(13).ToString());
            _host.WaitFor("REQ");
            // '-------------------------------login end
            foreach (AuxID CurrentTn in Tns)
            {
                string CurrentAuxId = CurrentTn.AuxID;
                if (PBXTYPE != 1)
                    ;// CurrentAuxId = Strings.Left(CurrentAuxId, Strings.InStr(CurrentAuxId, ".") - 1) + " " + Strings.Mid(CurrentAuxId, Strings.InStrRev(CurrentAuxId, ".") + 1);
                string[] CosValues = (ActionParameters.CosValue + " ").Split(" ");
                _host.Send("CHG" + Convert.ToChar(13).ToString());
                _host.WaitFor("TYPE");
                _host.Send(CurrentTn.TelephoneType + Convert.ToChar(13).ToString());
                _host.WaitFor("TN");


                _host.Send(CurrentAuxId.Replace(".", " ") + Convert.ToChar(13).ToString());
                _host.WaitFor("ECHG");

                _host.Send("YES" + Convert.ToChar(13).ToString());
                _host.WaitFor("ITEM");

                _host.Send("TGAR " + CosValues[0] + Convert.ToChar(13).ToString());
                _host.WaitFor("ITEM");
                _host.Send("NCOS " + CosValues[1] + Convert.ToChar(13).ToString());
                _host.WaitFor("ITEM");
                _host.Send(Convert.ToChar(13).ToString());
                _host.WaitFor("REQ");
            }


            if (ActionParameters.ActionType == RestrictStatus.QueueRestrict)
            {
                var MessageText = string.Format("Restrict subscriber:{0}, Cos:{1}, Category: {2}, Limit: {3}, Charged: {4}", ActionParameters.Abonent.AbonentName, ActionParameters.CosValue, CategoryName, ActionParameters.Credit.Credit, ActionParameters.Credit.Debit);
                _host.SendMail("", "Tariscope limiting notification", MessageText);

                _host.Wait(5000);

                var MessageText2 = string.Format("Dear {0}!     You limit exceeded for category: {1}. Limit: {2}, Charged: {3}", ActionParameters.Abonent.AbonentName, CategoryName, ActionParameters.Credit.Credit, ActionParameters.Credit.Debit);
                _host.SendMail(ActionParameters.Abonent.EMail, "Telephony limiting", MessageText2);
                _host.Wait(5000);
            }
            else if (ActionParameters.ActionType == RestrictStatus.QueueUnrestrict)
            {
                var MessageText = string.Format("Unrestrict subscriber:{0}, Cos:{1}, Category: {2}", ActionParameters.Abonent.AbonentName, ActionParameters.CosValue, CategoryName);
                _host.SendMail("", "Tariscope limiting notification (Unrestrict)", MessageText);

                _host.Wait(5000);
            }
            ActionParameters.Result = MediationActionResult.Success;
        }
        catch (Exception ex)
        {
            _host.AddEvent(ex.ToString());
        }
    }
}
