﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using SoftPi.Tariscope.Common;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;
using SoftPi.Tariscope.DAL;
using Microsoft.Data.SqlClient;

public class CucmLimitingSsh : IScript
{
    private IScriptHost _host;


    public const string CUCM_HOST = "10.10.1.101";
    public const string CUCM_LOGIN = "admin";
    public const string CUCM_PASSWORD = "your-password";

    public void Init(IScriptHost host)
    {
        _host = host;
        _host.Close += OnClose;
    }
    private void OnClose(ref bool Cancel)
    {
        return;
    }

    public void Main(object Parameters)
    {
        SubscriberLimitingActionParameters actionParameters = (SubscriberLimitingActionParameters)Parameters;

        _host.AddEvent(string.Format("Restrict subscriber:{0} Cos:{1}, Category: {2}", actionParameters.Abonent.AbonentName, actionParameters.CosValue, actionParameters.Credit.CategoryID));

        try
        {
            string categoryName;
            List<DN> dns;
            using (SqlConnection cn = new SqlConnection(_host.DatabaseConnectionString))
            {
                cn.Open();
                if (actionParameters.Credit.CategoryID.HasValue)
                    categoryName = new Categories(cn).Details(actionParameters.Credit.CategoryID.Value).Name;
                else
                    categoryName = "All categories";
                dns = DNs.Instance(cn).Load(actionParameters.Abonent.ID).Where(x => PBXs.Instance(cn).Details(x.PbxId).PBXType == "Cisco CallManager" && DateTime.Now > x.FromDateValue && DateTime.Now < x.ToDateValue).ToList();
            }


            SoftPi.Shared.DataSources.SshClientSource sshConnector = new SoftPi.Shared.DataSources.SshClientSource();
            sshConnector.Configuration = string.Format(sshConf, CUCM_HOST, CUCM_LOGIN, CUCM_PASSWORD);
            sshConnector.ReceiveData += receiveData;
            sshConnector.Open();
            WaitFor(CUCM_LOGIN + ":");
            foreach (DN dn in dns)
            {
                sshConnector.Send(string.Format(sqlText, dn, actionParameters.CosValue) + Convert.ToChar(13));
                WaitFor(CUCM_LOGIN + ":");
                string response = _textEncoding.GetString(_receivedData.ToArray());
                if (!response.Contains("Rows: 1"))
                    throw new Exception("Failed to execute SQL");
            }
            sshConnector.Close();
            actionParameters.Result = MediationActionResult.Success;
        }
        catch (Exception ex)
        {
            actionParameters.Result = MediationActionResult.Fail;
            _host.AddEvent("Failed to perform restriction action on CUCM:" + ex.Message);
        }
    }

    private void receiveData(object sender, SoftPi.Shared.DataSources.DataSourceReceiveEventArgs e)
    {
        if (_waitInputStream)
        {
            lock (_receiveLock)
            {
                if (_receivedData != null)
                    _receivedData.AddRange(e.Data);
            }
        }
    }


    private bool WaitFor(string nail = "", int timeout = -1)
    {
        if (timeout == -1)
            timeout = 30000;

        lock (_receiveLock)
        {
            _waitInputStream = true;
            _receivedData = new List<byte>();
        }

        int Ticks = Environment.TickCount;
        byte[] searchfor = _textEncoding.GetBytes(nail);
        try
        {
            while (true)
            {
                lock (_receiveLock)
                {
                    if ((searchfor.Length > 0 && LocateFirst(_receivedData, searchfor) >= 0) || (searchfor.Length == 0 && _receivedData.Count > 0))
                        break;
                }
                System.Threading.Thread.Sleep(40);
                if (timeout > 0 && Environment.TickCount > Ticks + timeout)
                    return false;
            }
            return true;
        }
        catch
        {
            return false;
        }
        finally
        {
            lock (_receiveLock)
                _waitInputStream = false;
        }
    }
    private int LocateFirst(List<byte> self, byte[] candidate)
    {
        byte[] SelfArray = self.ToArray();
        if (IsEmptyLocate(SelfArray, candidate))
            return -1;
        for (int i = 0; i <= SelfArray.Length - 1; i++)
        {
            if (!IsMatch(SelfArray, i, candidate))
                continue;

            return i;
        }
        return -1;
    }
    private bool IsMatch(byte[] array, int position, byte[] candidate)
    {
        if (candidate.Length > (array.Length - position))
            return false;
        for (int i = 0; i <= candidate.Length - 1; i++)
        {
            if (array[position + i] != candidate[i])
                return false;
        }

        return true;
    }

    private bool IsEmptyLocate(byte[] array, byte[] candidate)
    {
        return array == null || candidate == null || array.Length == 0 || candidate.Length == 0 || candidate.Length > array.Length;
    }

    private System.Text.Encoding _textEncoding = System.Text.Encoding.Default;

    /// <summary>
    ///     ''' Flag if now in waiting state
    ///     ''' </summary>
    ///     ''' <remarks></remarks>
    private bool _waitInputStream = false;

    /// <summary>
    ///     ''' Buffer with received bytes
    ///     ''' </summary>
    ///     ''' <remarks></remarks>
    private List<byte> _receivedData = null;

    /// <summary>
    ///     ''' Thread syncronization object
    ///     ''' </summary>
    ///     ''' <remarks></remarks>
    private readonly object _receiveLock = new object();


    private const string sshConf = "<?xml version=\"1.0\" encoding=\"utf-8\"?><SSHClientSourceSettings xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"><Host>{0}</Host><Port>22</Port><Login>{1}</Login><Password>{2}</Password></SSHClientSourceSettings>";
    /// <summary>
    ///     ''' SQL Command template to change calling space
    ///     ''' </summary>
    ///     ''' <example>
    ///     ''' run sql select dnorpattern from numplan                (get all DNs registered on CUCM)
    ///     ''' 
    ///     ''' </example>
    private const string sqlText = "run sql update numplan set fkcallingsearchspace_sharedlineappear=(SELECT pkid FROM callingsearchspace WHERE name='{1}') WHERE dnorpattern='{0}'";
}
