﻿$(document).ready(() => {
    let groupId = null;

    function PanelIsVisible(name) {
        //return true if panel opened
        return $('#' + name + '_body').is(':visible') === true;
    }

    function PanelControll(name, show) {
        //open and close panels
        if (show === true) {
            $('#' + name + '_body').slideDown('fast');
            $('#' + name + '_icon').css('transform', 'rotate(180deg)');
        }
        else {
            $('#' + name + '_body').slideUp('fast');
            $('#' + name + '_icon').css('transform', 'rotate(0deg)');
        }
    }

    function AddEventsToGroupsList() {
        $('.panel-controll').each(function () {
            PanelControll($(this).prop('id'), false);
        });

        $('.groupshead').each(function () {
            $(this).hover(function () {
                $(this).find('.panel-rename').css("opacity", 1);
            }, function () {
                $(this).find('.panel-rename').css("opacity", 0);
            });
        });

        //load abonents
        $('.panel-controll').on('click', function () {
            let id = $(this).prop('id');
            let loaded = $(this).data('loaded') * 1 > 0;

            if (!loaded) {
                $(`#${id}_body`).load(`/AI/Groups/AbonentsTable/${$(this).data('link')}`, () => {
                    $(this).data('loaded', 1);
                });
            }

            PanelControll(id, !PanelIsVisible(id));
        });

        //rename groups
        $('.panel-rename').on('click', function () {
            groupId = $(this).data('link');
            $('#renameGroupInput').val($(`#Group_${groupId}_name`).text().trim());
            $('#renameGroup').modal('show');
        });
    }

    function LoadGroups() {
        ShowSpinner(true);
        $('#GroupsBody').load('/AI/Groups/Table', () => {
            ShowSpinner(false);
            AddEventsToGroupsList();
        });
    }

    //open settings wizard
    $('#btnSettings').on('click', () => { window.open('/AI/Groups/Settigns', '_parent'); });

    //clear grouping
    $('#btnClear').on('click', () => { $('#ClearGroupsModal').modal('show'); });
    $('#ClearGroupingBtn').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            async: true,
            url: '/AI/Groups/ClearGrouping',
            traditional: true,
            success: function (response) {
                LoadGroups();
            }
        });
    });

    //rename group
    $('#renameGroupBtn').on('click', () => {
        $('#renameGroup').modal('hide');
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            async: true,
            url: `/AI/Groups/RenameGroup/${groupId}/?Name=${encodeURIComponent($('#renameGroupInput').val())}`,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                $(`#Group_${groupId}_name`).text(response.name);
            }
        });
    });

    //load groups
    LoadGroups();
});