﻿$(document).ready(() => {
    let summaryAjax = null;
    let lockedAjax = null;
    let selectedCustomService = null;
    let selectedCustomServiceFee = null;

    let cleanMode = -1;

    let selectedMonthDetail = null;
    let selectedMonthDetailIsPayment = false;
    let selectedMonthDetailIsCost = 0;
    let selectedMonthDetailIsdesc = '';
    let selectedMonthDetailBank = '';
    let selectedMonthDetailPay = 0;

    let isEditPayment = false;

    function UpdateButtons() {
        //enable/disable edit/delete buttons for month details
        if (selectedMonthDetail === null) {
            $("#btnMonthDetEdit").attr("disabled", true);
            $("#btnMonthDetDelete").attr("disabled", true);
            $("#btnClearSameToSelectedInvocies").attr("disabled", true);
            $("#btnClearSelectedInvoice").attr("disabled", true);
        }
        else {
            $("#btnMonthDetEdit").attr("disabled", false);
            $("#btnMonthDetDelete").attr("disabled", false);
            $("#btnClearSameToSelectedInvocies").attr("disabled", false);
            $("#btnClearSelectedInvoice").attr("disabled", false);
        }

    }

    function AttachEventsToMonthDetails() {
        //events to table with month details
        selectedMonthDetail = null;
        selectedMonthDetailIsPayment = false;
        selectedMonthDetailPay = 0;
        selectedMonthDetailIsCost = 0;
        selectedMonthDetailIsdesc = '';
        selectedMonthDetailBank = '';

        $('#tariscope-monthDetails tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedMonthDetail = null;
                selectedMonthDetailIsPayment = false;
            }
            else {
                selectedMonthDetail = $(this).find('td[data-name="ID"]').text();
                selectedMonthDetailPay = $(this).find('td[data-name="PAY"]').text().replace(',', '.') * 1;
                selectedMonthDetailIsPayment = selectedMonthDetailPay > 0;
                selectedMonthDetailIsCost = $(this).find('td[data-name="COST"]').text().replace(',', '.') * 1;
                selectedMonthDetailIsdesc = $(this).find('td[data-name="DESC"]').text();
                selectedMonthDetailBank = $(this).find('td[data-name="BANK"]').text();

                $('#tariscope-monthDetails tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtons();
        });

        UpdateButtons();
        PlayLoadAnimation('MonthDetails', false);
    }

    function initDateTimepicker() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: true,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepicker').datetimepicker(daytimeOpitions);

        try {
            $('#datetimepicker').data("DateTimePicker").setDate(new Date());
        } catch (e) { console.log(e); }
    }

    function initDateTimepicker2() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: true,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerPay').datetimepicker(daytimeOpitions);

        try {
            $('#datetimepickerPay').data("DateTimePicker").setDate(new Date());
        } catch (e) { console.log(e); }
    }

    function PanelIsVisible(name) {
        //return true if panel opened
        return $('#' + name + '_body').is(':visible') === true;
    }

    function PanelControll(name, show) {
        //open and close panels
        if (show === true) {
            $('#' + name + '_body').slideDown('fast');
            $('#' + name + '_icon').css('transform', 'rotate(180deg)');
        }
        else {
            $('#' + name + '_body').slideUp('fast');
            $('#' + name + '_icon').css('transform', 'rotate(0deg)');
        }
    }

    function PlayLoadAnimation(name, show) {
        //show load anim,ation
        if (show === true) {
            $('#' + name + '_body').addClass('disDiv');
            $('#' + name + '_load').show();
        }
        else {
            $('#' + name + '_body').removeClass('disDiv');
            $('#' + name + '_load').hide();
        }
    }

    function LoadSummary(url) {
        //load summary for period
        if (summaryAjax !== null)
            summaryAjax.abort();

        PlayLoadAnimation('AccountStatus', true);

        summaryAjax = $.ajax({
            type: "POST",
            url: '/AccountSummary/GetAccountSummary/' + url,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#StartDebt').val(response.summary.StartDebt.toFixed(2));
                    $('#EndDebt').val(response.summary.EndDebt.toFixed(2));
                    $('#MonthCharges').val(response.summary.MonthCharges.toFixed(2));
                    $('#MonthPayments').val(response.summary.MonthPayments.toFixed(2));
                    $('#PredictedCharges').val(response.summary.PredictedCharges.toFixed(2));

                    PlayLoadAnimation('AccountStatus', false);
                }
            }
        });
    }

    function LoadMonthSummaryCharges(url) {
        //load summary for period
        PlayLoadAnimation('MonthSummary', true);
        $('#MonthSummary_body').load('/AccountSummary/GetMonthSummaryCharges/' + url, () => { PlayLoadAnimation('MonthSummary', false); });
    }

    function LoadMonthDetails(url) {
        //load summary for period
        PlayLoadAnimation('MonthDetails', true);
        $('#MonthDetails_body').load('/AccountSummary/GetMonthDetails/' + url, AttachEventsToMonthDetails);
    }

    function LoadCallAndTraffic(url) {
        //load summary for period
        PlayLoadAnimation('CallsAndTraffic', true);
        $('#CallsAndTraffic_body').load('/AccountSummary/GetCallsAndTraffic/' + url, () => { PlayLoadAnimation('CallsAndTraffic', false); });
    }

    function GetIsLocked(url) {
        //load locked period info
        if (lockedAjax !== null)
            lockedAjax.abort();

        PlayLoadAnimation('AccountStatus', true);

        lockedAjax = $.ajax({
            type: "POST",
            url: '/AccountSummary/IsLockedPeriod/' + url,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    if (response.locked === true) {
                        $('#btnLock').prop('disabled', true);
                        $('#btnUnlock').prop('disabled', false);
                    }
                    else {
                        $('#btnLock').prop('disabled', false);
                        $('#btnUnlock').prop('disabled', true);
                    }
                }
            }
        });
    }

    function Init() {
        let dt = new Date();

        //setup current period on start
        $('#PeriodYear').val(dt.getFullYear() + '');
        $('#PeriodMonth').val((dt.getMonth() + 1) + '');

        PanelControll('AbonentInfo', false);
        PanelControll('AccountStatus', true);
        PanelControll('MonthSummary', true);
        PanelControll('MonthDetails', false);
        PanelControll('CallsAndTraffic', true);

        $('#accountName').text($('#AbonentName').val());
    }

    function GetData() {
        //load data for selected period
        let url = $('#AbonentID').val() + '/' + $('#PeriodYear').val() + '/' + $('#PeriodMonth').val();

        GetIsLocked(url);
        LoadSummary(url);
        LoadMonthSummaryCharges(url);
        LoadMonthDetails(url);
        LoadCallAndTraffic(url);
    }

    function AttachEventsToCustomServicesTable() {
        $('#tariscope-services tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedCustomService = null;
                selectedCustomServiceFee = null;
            }
            else {
                selectedCustomService = $(this).find('td[data-name="ID"]').text();
                selectedCustomServiceFee = $(this).find('td[data-name="FeeAmount"]').text();
                $('#tariscope-services tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            $('#ChargeCustomConfirm').prop('disabled', selectedCustomService === null);
            $('#customSvcCost').val(selectedCustomServiceFee.replace(',', '.') * 1);
        });

        $('#customSvcCost').val('0');
        $('#customSvcCount').val('1');
        $('#customSvcDescription').val('');

        ShowSpinner(false);
        initDateTimepicker();
        $('#chargeCustomModal').modal('show');
    }

    //event for buttons for open or close panel
    $('button[id="btnControllPanel"]').on('click', function () {
        let name = $(this).data('name');
        PanelControll(name, !PanelIsVisible(name));
    });

    //when changed period by select
    $('#PeriodYear').change(GetData);
    $('#PeriodMonth').change(GetData);

    //changed period by buttons (back)
    $('#btnLeft').on('click', () => {
        let year = $('#PeriodYear').val() * 1;
        let month = $('#PeriodMonth').val() * 1;

        month--;

        if (month === 0) {
            $('#PeriodYear').val(year - 1);
            $('#PeriodMonth').val(12);
        }
        else {
            $('#PeriodMonth').val(month);
        }

        GetData();
    });

    //changed period by buttons (forward)
    $('#btnRight').on('click', () => {
        let year = $('#PeriodYear').val() * 1;
        let month = $('#PeriodMonth').val() * 1;

        month++;

        if (month > 12) {
            $('#PeriodYear').val(year + 1);
            $('#PeriodMonth').val(1);
        }
        else {
            $('#PeriodMonth').val(month);
        }

        GetData();
    });

    //show modal for lock period
    $('#btnLock').on('click', () => { $('#confirmLock').modal('show'); });

    //confirm lock period
    $('#LockConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/AccountSummary/LockedPeriod/' + $('#PeriodYear').val() + '/' + $('#PeriodMonth').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#btnLock').prop('disabled', true);
                    $('#btnUnlock').prop('disabled', false);
                    $('#confirmLock').modal('hide');
                }
            }
        });
    });

    //unlock period
    $('#btnUnlock').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/AccountSummary/UnLockedPeriod/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#btnLock').prop('disabled', false);
                    $('#btnUnlock').prop('disabled', true);
                }
            }
        });
    });

    //redirect to reports
    $('#btnReport').on('click', () => { window.open('/Reporting', '_blank'); });

    //open view with calls for selected abonent and selected period
    $('#btnCallsForMonth').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/SaveCallsView/?Name=' + $('#AbonentName').val() + '&ID=' + $('#AbonentID').val() + '&Year=' + $('#PeriodYear').val() + '&Month=' + $('#PeriodMonth').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    window.open('/TariscopeViews/Open/?Name=' + response.ViewName + '&Type=0&OwnerType=1&OwnerName=&Group=', '_blank');
                }
            }
        });
    });

    //open view with ip traffic for selected abonent and selected period
    $('#btnIpForMonth').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/SaveIPView/?Name=' + $('#AbonentName').val() + '&ID=' + $('#AbonentID').val() + '&Year=' + $('#PeriodYear').val() + '&Month=' + $('#PeriodMonth').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    window.open('/TariscopeViews/Open/?Name=' + response.ViewName + '&Type=2&OwnerType=1&OwnerName=&Group=', '_blank');
                }
            }
        });
    });

    //recharge month
    $('#btnRechargeMonth').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/AccountSummary/RechargeMonthAbonent/' + $('#AbonentID').val() + '/' + $('#PeriodYear').val() + '/' + $('#PeriodMonth').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    GetData();
                }
            }
        });
    });

    //recharge month
    $('#btnChargePeriodic').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/AccountSummary/ChargeServices/' + $('#AbonentID').val() + '/' + $('#PeriodYear').val() + '/' + $('#PeriodMonth').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    GetData();
                }
            }
        });
    });

    //open modal for charge custom services
    $('#btnChargeCustom').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/AccountSummary/GetDNs/' + $('#AbonentID').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#subsNumbers').empty();

                    $($('#subsNumbers')).append('<option value="-1"></option>');
                    for (var key in response.numbers) {
                        $($('#subsNumbers')).append('<option value="' + key + '">' + response.numbers[key] + '</option>');
                    }

                    $('#ChargeCustomConfirm').prop('disabled', true);
                    $('#customServiceConcentrator').load('/AccountSummary/GetCustomServices', AttachEventsToCustomServicesTable);
                }
            }
        });
    });

    //charge cusotm service
    $('#ChargeCustomConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/AccountSummary/ChargeCustomService/' + $('#AbonentID').val() + '/' + selectedCustomService +
                '/?dnid=' + $('#subsNumbers').val() +
                '&cost=' + encodeURIComponent($('#customSvcCost').val()) +
                '&count=' + encodeURIComponent($('#customSvcCount').val()) +
                '&dt=' + encodeURIComponent($('#datetimepicker').data('date')) +
                '&description=' + encodeURIComponent($('#customSvcDescription').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#chargeCustomModal').modal('hide');
                    ShowSpinner(false);
                    GetData();
                }
            }
        });
    });

    //show modal for add payment
    $('#btnAddPayment').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/AccountSummary/GetBanks/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#bankList').empty();

                    response.list.map((e) => {
                        $($('#bankList')).append('<option value="' + e.Value + '" />');
                    });

                    $('#paydateSection').show();
                    initDateTimepicker2();

                    $('#paycost').val('0');
                    $('#paymentType').val('0');
                    $('#paymentDescription').val('');
                    $('#payBank').val('');
                    $('#payModal').modal('show');
                }
            }
        });
    });

    //when select pay type
    $('#paymentType').on('click', () => {
        $('#payBank').val($('#paymentType option[value="' + $('#paymentType').val() + '"]').text());
    });

    //add payment confirm
    $('#AddPaymentConfirm').on('click', () => {
        if (isEditPayment === true) {//edit payment
            $.ajax({
                type: "POST",
                url: '/AccountSummary/EditPay/' + $('#AbonentID').val() + '/' + selectedMonthDetail +
                    '/?cost=' + $('#paycost').val() +
                    '&type=' + $('#paymentType').val() +
                    '&description=' + $('#paymentDescription').val() +
                    '&bank=' + $('#payBank').val(),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#payModal').modal('hide');
                        ShowSpinner(false);
                        GetData();
                    }
                }
            });
        }
        else {//add payment
            $.ajax({
                type: "POST",
                url: '/AccountSummary/AddPay/' + $('#AbonentID').val() +
                    '/?cost=' + $('#paycost').val() +
                    '&dt=' + encodeURIComponent($('#datetimepickerPay').data('date')) +
                    '&type=' + $('#paymentType').val() +
                    '&description=' + $('#paymentDescription').val() +
                    '&bank=' + $('#payBank').val(),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#payModal').modal('hide');
                        ShowSpinner(false);
                        GetData();
                    }
                }
            });
        }
    });

    //show modal for clean (all)
    $('#btnCleanMonthAll').on('click', () => {
        cleanMode = 1;
        $('#confirmClean').modal('show');
    });

    //show modal for clean (service only)
    $('#btnCleanMonthSvc').on('click', () => {
        cleanMode = 2;
        $('#confirmClean').modal('show');
    });

    //show modal for clean (service only)
    $('#btnCleanMonthInvoices').on('click', () => {
        cleanMode = 3;
        $('#confirmClean').modal('show');
    });

    //clean month
    $('#CleanConfirm').on('click', () => {
        $('#confirmClean').modal('hide');
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/AccountSummary/CleanMonth/' + $('#AbonentID').val() + '/' + $('#PeriodYear').val() + '/' + $('#PeriodMonth').val() + '/' + cleanMode,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    GetData();
                }
            }
        });
    });

    //show modal for confirm delete charge
    $('#btnMonthDetDelete').on('click', () => { $('#confirmDelete').modal('show'); });

    //confirm delete charge
    $('#DeleteConfirm').on('click', () => {
        $('#confirmDelete').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/AccountSummary/DeleteCharge/' + selectedMonthDetail + '/' + $('#PeriodYear').val() + '/' + $('#PeriodMonth').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    GetData();
                }
            }
        });
    });

    //show modals for edit svc or payment
    $('#btnMonthDetEdit').on('click', () => {
        if (selectedMonthDetailIsPayment === true) {
            isEditPayment = true;

            $.ajax({
                type: "POST",
                url: '/AccountSummary/GetBanks/',
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {

                        $('#bankList').empty();

                        response.list.map((e) => {
                            $($('#bankList')).append('<option value="' + e.Value + '" />');
                        });

                        $('#paydateSection').hide();
                        
                        $('#paycost').val(selectedMonthDetailPay);
                        $('#paymentType').val($('#tariscope-monthDetails').find(`td[data-name="ID"]`).filter(function () { return $(this).text() === `${selectedMonthDetail}` }).parent().find('td[data-name="PTYPE"]').text());
                        $('#paymentDescription').val(selectedMonthDetailIsdesc);
                        $('#payBank').val(selectedMonthDetailBank);

                        $('#payModal').modal('show');
                    }
                }
            });
        }
        else {
            $('#editSvcCost').val(selectedMonthDetailIsCost);
            $('#editSvcDescription').val(selectedMonthDetailIsdesc);

            $('#editSvcmodal').modal('show');
        }
    });

    //confirm save edited service
    $('#SaveEditedSvc').on('click', () => {
        $('#editSvcmodal').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/AccountSummary/EditCharge/' + selectedMonthDetail + '/' + $('#PeriodYear').val() + '/' + $('#PeriodMonth').val() + '/?Cost=' + $('#editSvcCost').val() + '&Description=' + encodeURIComponent($('#editSvcDescription').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    GetData();
                }
            }
        });
    });
    $('#payModal').on('hidden.bs.modal', () => { isEditPayment = false; });

    //show modal to clear selected invoice
    $('#btnClearSelectedInvoice').on('click', () => { $('#CleanSelectedInvoiceModal').modal('show'); });

    //show modal to clear same to selected invoice
    $('#btnClearSameToSelectedInvocies').on('click', () => { $('#CleanSameSelectedInvoiceModal').modal('show'); });

    //clear for selected service
    $('#CleanSelectedInvoiceConfirm').on('click', () => {
        $('#CleanSelectedInvoiceModal').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/AccountSummary/DeleteInvoice/' + selectedMonthDetail + '/' + $('#PeriodYear').val() + '/' + $('#PeriodMonth').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    GetData();
                }
            }
        });
    });

    //clear for all same to selected service
    $('#CleanSameSelectedInvoiceConfirm').on('click', () => {
        $('#CleanSameSelectedInvoiceModal').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/AccountSummary/DeleteInvoices/' + $('#AbonentID').val() + '/' + $('#PeriodYear').val() + '/' + $('#PeriodMonth').val() + '/' + selectedMonthDetail,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    GetData();
                }
            }
        });
    });

    Init();
    GetData();
});