﻿$(document).ready(() => {
    let SelectedNode = null;

    function LoadNodes() {
        $('#NextStep').prop('disabled', true);
        $('#NodesBody').load('/CommunicationNodes/Get', () => {
            $('#tableWithNodes tbody').on('click', 'tr', function () {
                if ($(this).hasClass('selected')) {
                    $(this).removeClass('selected');
                    SelectedNode = null;
                }
                else {
                    SelectedNode = $(this).find('td[data-name="ID"]').text();
                    $('#tableWithNodes tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
                $('#NextStep').prop('disabled', SelectedNode == null);
            });
        });
    }

    function SendData() {
        ShowSpinner(true);

        var formData = new FormData();

        formData.append('SelectedNode', SelectedNode);

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: '/DeviceWizard/Step1_v/',
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#NodeID').val(response.ID);
                    GoNext();
                }
                else { ShowError(response.Errors); }
            }
        });
    }

    //setup current step
    $('#CurrentStep').val(1);

    //go to the next step
    $('#NextStep').on('click', SendData);

    //show modal to add new node
    $('#AddNode').on('click', () => {
        $('#emptyNewName').hide();
        $('#NewNodeName').val('');
        $('#saveNewNode').prop('disabled', true);
        $('#addNodemodal').modal('show');
    });

    //show error when empty node name
    $('#NewNodeName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyNewName').slideDown('fast');
            $('#saveNewNode').prop('disabled', true);
        }
        else {
            $('#emptyNewName').slideUp('fast');
            $('#saveNewNode').prop('disabled', false);
        }
    });

    //add confirm
    $('#saveNewNode').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/CommunicationNodes/Add/?Name=' + encodeURIComponent($('#NewNodeName').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    AddNewNode(response.node, response.restr);
                    LoadNodes();
                    $('#addNodemodal').modal('hide');
                }
            }
        });
    });

    //show cancel modal
    $('#CancelWizard').on('click', () => { $('#CancelWizardmodal').modal('show'); });

    LoadNodes();
});