﻿$(document).ready(() => {
    let selectedDN = null;

    function ExpandLeftMenu() {
        try {
            if (NodeIsLoaded) {
                ShowNodes('NewNodesMenu');
                ShowNodeEntry($('#nodeID').val() + '');
                ShowDevices('CNode_' + $('#nodeID').val() + '');
                ShowDeviceContent('CNode_' + $('#nodeID').val() + 'CSelectedDevice_' + $('#deviceID').val());
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }
    }

    function UpdateButtons() {
        if (selectedDN === null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
        }
    }

    function AttachEventsToTable() {
        selectedDN = null;

        $('#tariscope-dn tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedDN = null;
            }
            else {
                selectedDN = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-dn tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtons();
        });

        UpdateButtons();
    }

    function Load() {
        $('#dnpTable').load('/Devices/DNPlans/Load/' + $('#deviceID').val(), AttachEventsToTable);
    }

    function ValidateIPaddress(inputText) {
        var ipformat = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
        if (inputText.match(ipformat)) {
            return true;
        }
        else {
            return false;
        }
    }

    function ValidateName(source) {
        if (!$('#rangeName').val() || !$('#rangeName').val().trim()) {
            if (source === 0)
                $('#emptyName').slideDown('fast');
            return false;
        }
        else {
            if (source === 0)
                $('#emptyName').slideUp('fast');
            return true;
        }
    }

    function ValidateIP(source) {
        console.log('validate ip');

        let from = false, to = false;

        if (!ValidateIPaddress($('#rangeFrom').val())) {

            if (source === 0)
                $('#emptyFrom').slideDown('fast');
            from = false;
        }
        else {
            if (source === 0)
                $('#emptyFrom').slideUp('fast');
            from = true;
        }

        if (!ValidateIPaddress($('#rangeTo').val())) {
            if (source === 1)
                $('#emptyTo').slideDown('fast');
            to = false;
        }
        else {
            if (source === 1)
                $('#emptyTo').slideUp('fast');
            to = true;
        }

        return (from + to) > 1;
    }

    function ValidateTel(source) {
        let from = false, to = false;

        if (!$('#rangeFrom').val() || !$('#rangeFrom').val().trim()) {

            if (source === 0)
                $('#emptyFrom').slideDown('fast');

            from = false;
        }
        else {
            if (source === 0)
                $('#emptyFrom').slideUp('fast');

            from = true;
        }

        if (!$('#rangeTo').val() || !$('#rangeTo').val().trim()) {
            if (source === 1)
                $('#emptyTo').slideDown('fast');

            to = false;
        }
        else {
            if (source === 1)
                $('#emptyTo').slideUp('fast');

            to = true;
        }

        return (from + to) > 1;
    }

    //show modal for delete dn range
    $('#btnDelete').on('click', () => { $('#deleteDNplanemodal').modal('show'); });

    //confirm delete dn range
    $('#deleteDNconfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Devices/DNPlans/Delete/' + selectedDN,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#deleteDNplanemodal').modal('hide');
                    Load();
                }
            }
        });
    });

    //show modal for add dn range
    $('#btnAdd').on('click', () => {
        $('#btnSaveDnRange').unbind();

        $('#editDNRangeTitle').text($('#addTitle').val());
        $('#rangeName').val('');
        $('#rangeType').val($('option:first', $('#rangeType')).val());

        $('#rangeFrom').prop('type', 'number');
        $('#rangeTo').prop('type', 'number');

        $('#rangeFrom').val('');
        $('#rangeTo').val('');

        $('#ipAlert').hide();
        $('#telAlert').show();

        $('#emptyFrom').hide();
        $('#emptyTo').hide();
        $('#emptyName').hide();

        $('#btnSaveDnRange').prop('disabled', true);

        //add range
        $('#btnSaveDnRange').on('click', () => {
            $('#btnSaveDnRange').prop('disabled', true);

            $.ajax({
                type: "POST",
                url: '/Devices/DNPlans/Add/' + $('#deviceID').val() + '/' + $('#rangeType').val()
                    + '/?Name=' + encodeURIComponent($('#rangeName').val())
                    + '&From=' + encodeURIComponent($('#rangeFrom').val())
                    + '&To=' + encodeURIComponent($('#rangeTo').val()),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#editDNRangemodal').modal('hide');
                        Load();
                    }
                }
            });
        });

        $('#editDNRangemodal').modal('show');
    });

    //change range type
    $('#rangeType').change(() => {
        $('#rangeFrom').val('');
        $('#rangeTo').val('');

        $('#emptyFrom').hide();
        $('#emptyTo').hide();
        $('#emptyName').hide();

        $('#btnSaveDnRange').prop('disabled', true);

        switch ($('#rangeType').val() * 1) {
            case 0:
                $('#rangeFrom').prop('type', 'number');
                $('#rangeTo').prop('type', 'number');

                $('#ipAlert').slideUp('fast');
                $('#telAlert').slideDown('fast');
                break;
            case 1:
                $('#rangeFrom').prop('type', 'text');
                $('#rangeTo').prop('type', 'text');

                $('#ipAlert').slideDown('fast');
                $('#telAlert').slideUp('fast');
                break;
            default:
            case 2:
                $('#rangeFrom').prop('type', 'text');
                $('#rangeTo').prop('type', 'text');

                $('#ipAlert').slideUp('fast');
                $('#telAlert').slideUp('fast');
                break;
        }
    });

    //validate inputs
    $('#rangeFrom').on('input', () => {
        if ($('#rangeType').val() * 1 !== 1) {
            $('#btnSaveDnRange').prop('disabled', !(ValidateTel(0) + ValidateName(1) > 1));
        }
        else {
            $('#btnSaveDnRange').prop('disabled', !(ValidateIP(0) + ValidateName(1) > 1));
        }
    });
    $('#rangeTo').on('input', () => {
        if ($('#rangeType').val() * 1 !== 1) {
            $('#btnSaveDnRange').prop('disabled', !(ValidateTel(1) + ValidateName(1) > 1));
        }
        else {
            $('#btnSaveDnRange').prop('disabled', !(ValidateIP(1) + ValidateName(1) > 1));
        }
    });
    $('#rangeName').on('input', () => {
        if ($('#rangeType').val() * 1 !== 1) {
            $('#btnSaveDnRange').prop('disabled', !(ValidateTel(2) + ValidateName(0) > 1));
        }
        else {
            $('#btnSaveDnRange').prop('disabled', !(ValidateIP(2) + ValidateName(0) > 1));
        }
    });

    //open modal for edit dn range
    $('#btnEdit').on('click', () => {
        $('#btnSaveDnRange').unbind();

        $('#editDNRangeTitle').text($('#editTitle').val());

        $('#emptyFrom').hide();
        $('#emptyTo').hide();
        $('#emptyName').hide();

        $('#btnSaveDnRange').prop('disabled', false);

        $.ajax({
            type: "POST",
            url: '/Devices/DNPlans/Get/' + selectedDN,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#rangeName').val(response.range.Name);
                    $('#rangeType').val(response.range.Type);
                    $('#rangeID').val(response.range.ID);

                    switch ($('#rangeType').val() * 1) {
                        case 0:
                            $('#rangeFrom').prop('type', 'number');
                            $('#rangeTo').prop('type', 'number');

                            $('#ipAlert').slideUp('fast');
                            $('#telAlert').slideDown('fast');
                            break;
                        case 1:
                            $('#rangeFrom').prop('type', 'text');
                            $('#rangeTo').prop('type', 'text');

                            $('#ipAlert').slideDown('fast');
                            $('#telAlert').slideUp('fast');
                            break;
                        default:
                        case 2:
                            $('#rangeFrom').prop('type', 'text');
                            $('#rangeTo').prop('type', 'text');

                            $('#ipAlert').slideUp('fast');
                            $('#telAlert').slideUp('fast');
                            break;
                    }

                    $('#rangeFrom').val(response.range.FromStr);
                    $('#rangeTo').val(response.range.ToStr);

                    //save edited range
                    $('#btnSaveDnRange').on('click', () => {
                        $('#btnSaveDnRange').prop('disabled', true);

                        $.ajax({
                            type: "POST",
                            url: '/Devices/DNPlans/Edit/' + $('#rangeID').val() + '/' + $('#deviceID').val() + '/'
                                + $('#rangeType').val()
                                + '/?Name=' + encodeURIComponent($('#rangeName').val())
                                + '&From=' + encodeURIComponent($('#rangeFrom').val())
                                + '&To=' + encodeURIComponent($('#rangeTo').val()),
                            traditional: true,
                            success: function (response) {
                                if (response !== null && response.success === true) {
                                    $('#editDNRangemodal').modal('hide');
                                    Load();
                                }
                            }
                        });
                    });

                    $('#editDNRangemodal').modal('show');
                }
            }
        });
    });

    Load();
    ExpandLeftMenu();
});