﻿$(document).ready(function () {
    let selectedBundle = null;

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/Services/Bundles/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/Services/Bundles/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateButtonsUI() {
        if (selectedBundle !== null) {
            $('#btnDelete').prop('disabled', false);
            $('#btnEdit').prop('disabled', false);
        }
        else {
            $('#btnDelete').prop('disabled', true);
            $('#btnEdit').prop('disabled', true);
        }
    }

    function RowClick(e) {
        if (e.hasClass('selected')) {
            e.removeClass('selected');
            selectedBundle = null;
        }
        else {
            selectedBundle = e.find('td[data-name="ID"]').text();
            $('#tariscope-bundles tr.selected').removeClass('selected');
            e.addClass('selected');
        }

        UpdateButtonsUI();
    }

    function AttachEventsToTable() {
        selectedBundle = null;

        $('#tariscope-bundles tbody').on('click', 'tr', function () { RowClick($(this)); });
        $('#tariscope-bundles tbody').on('dblclick', 'tr', function () {
            RowClick($(this));
            if (selectedBundle != null)
                $('#btnEdit').click();
        });

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/Services/Bundles/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        LoadBundles();
                    }
                }
            });
        });

        UpdateButtonsUI();
    }

    function LoadBundles() {
        $('#bundlesTable').load('/Services/Bundles/Search/?s=' + encodeURIComponent($('#tbSearch').val()), AttachEventsToTable);
    }

    //show modal for delete bundle
    $('#btnDelete').on('click', () => {
        $('#DeleteConfirm').prop('disabled', false);
        $('#cannotDelete').hide();
        $('#confirmDelete').modal('show');
    });

    //confirm delete bundle
    $('#DeleteConfirm').on('click', () => {
        $('#DeleteConfirm').prop('disabled', true);
        $.ajax({
            type: "POST",
            url: '/Services/Bundles/Delete/' + selectedBundle,
            traditional: true,
            success: function (response) {
                if (response !== null) {
                    if (response.success === true) {
                        LoadBundles();
                        $('#confirmDelete').modal('hide');
                    }
                    else {
                        $('#cannotDelete').slideDown('fast');
                    }
                }
            }
        });
    });

    //go to add new bundle
    $('#btnAdd').on('click', () => { window.location = "/Services/Bundles/Add"; });

    $('#btnEdit').on('click', () => { window.location = "/Services/Bundles/Edit/" + selectedBundle; });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    LoadBundles();
});