﻿$(document).ready(() => {
    let rateDates = [];
    let currentRateDate = null;

    let MainCurrencyID = 1;

    let IsLoad = false;
    let IsAdd = false;
    let IsUpdate = false;

    let selectedModifier = null;
    let selectedModifierIsCommon = false;

    let selectedStage = null;

    var openRateNow = false;

    function initDateTimePicker() {
        //init datetimepicker
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepicker').datetimepicker(options);
    }

    function GetValueBySelect(name) {
        //return value for some fields with select (UAH/%)
        var select = $('#' + name + 'Select option:selected').val();

        var value = $('#' + name).val() * 1;
        return select === 1 ? value : -value;
    }

    function UpdateButtonsForModifier() {
        /*update ui for buttons modifiers*/
        if (selectedModifier === null) {
            $("#btnEditModifier").attr("disabled", true);
            $("#btnDeleteModifier").attr("disabled", true);
        }
        else {
            $("#btnEditModifier").attr("disabled", false);
            $("#btnDeleteModifier").attr("disabled", false);
        }
    }

    function AttachEventsForModifiers() {
        //attacj events for table with modifiers
        $('#modifiersTable tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedModifier = null;
                selectedModifierIsCommon = null;
            }
            else {
                selectedModifier = $(this).find('td[data-name="ID"]').text();
                selectedModifierIsCommon = $(this).find('td[data-name="C"]').text();
                $('#modifiersTable tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtonsForModifier();
        });
    }

    function AttachEventsForStages() {
        //attach events for table with stages
        $('#tableWithStages tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedStage = null;
            }
            else {
                selectedStage = $(this).find('td[data-name="ID"]').text();
                $('#tableWithStages tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtonsForStages();
        });
    }

    function UpdateButtonsForStages() {
        /*update ui for buttons stages*/
        if (selectedStage === null) {
            $("#btnEditStages").attr("disabled", true);
            $("#btnDeleteStages").attr("disabled", true);
        }
        else {
            $("#btnEditStages").attr("disabled", false);
            $("#btnDeleteStages").attr("disabled", false);
        }
    }

    function LoadStages() {
        if (currentRateDate !== null)
            $('#stagesTable').load('/ServiceRate/GetTableWithStages/' + currentRateDate.toString().replace("'", '').replace("'", ''), AttachEventsForStages);
    }

    function LoadModifiers() {
        if (currentRateDate !== null)
            try { $('#modifiersTable').load('/ServiceRate/GetTableWithModifiers/' + currentRateDate.toString().replace("'", '').replace("'", '') + '/' + $('#editRoundTo').val(), AttachEventsForModifiers); }
            catch (e) { console.log(e); }
    }

    function IDToString(id) {
        return "'" + id + "'";
    }

    function generateRandomNumber(min, max) {
        //gate random number in range
        var rand = min - 0.5 + Math.random() * (max - min + 1);
        rand = Math.round(rand);
        return rand - 2000;
    }

    function GetAny(data) {
        //get eny item from array
        for (var prop in data)
            return prop;
    }

    function TakeRate(async = false) {
        //create rate from inputs
        var rate = {
            ID: currentRateDate,
            RecDate: $('#datetimepicker').data('date'),
            CurrencyID: $('#editCurrencyID option:selected').val(),
            RoundDurationDown: $('#Rounding').is(':checked'),
            RoundTo: $('#editRoundTo').val(),
            MininmumDuration: $('#editMinimumDuration').val(),
            RoundCostTo: $('#editRoundCostTo').val(),
            RoundCostDown: $('#RoundingDigits').is(':checked'),
            FreeSeconds: $('#editFreeSeconds').val(),
            SubstractSeconds: $('#editSubstractSeconds').val(),
            ConnectionCostLessThen: GetValueBySelect('editLessThen'),
            ThenConnFee: GetValueBySelect('editThenCost'),
            ElseConnFee: GetValueBySelect('editElseCost'),
            EnableAccountingMode: $('#EnableAccounting').is(':checked'),
            EverySub: $('#EverySubNumber').is(':checked'),
            AccountDescription: $('#editAccountDescription').val(),
            SingleCall: $('#SingleCall').is(':checked')
        };
        SendRate(rate, async);
        return rate;
    }

    function ApplyCurrencyName() {
        //apply currency name to other combobox (conn. fee)
        var curName = $('#editCurrencyID option:selected').html().substr(0, 3);

        $('#editLessThenSelect option[value=1]').html(curName);
        $('#editThenCostSelect option[value=1]').html(curName);
        $('#editElseCostSelect option[value=1]').html(curName);
    }

    function ApplyRate(rate, applyDate = false) {
        //aply this settings to ui
        if (applyDate) {
            try {

                $('#datetimepicker').data("DateTimePicker").setDate(rate.RecDate);
                $('#datetimepicker').data("DateTimePicker").setDate(new Date(rate.RecDate));
            } catch (e) { console.log(e); }
        }

        $('#editCurrencyID').val(rate.CurrencyID);
        ApplyCurrencyName();

        /*RoundTo*/
        $('#editRoundTo').val(rate.RoundTo);
        switch (rate.RoundTo * 1) {
            case 60:
                $('#RodunToSelect').val(1);
                $('#editRoundTo').attr('readonly', true);
                break;
            case 1:
                $('#RodunToSelect').val(2);
                $('#editRoundTo').attr('readonly', true);
                break;
            default:
                $('#RodunToSelect').val(3);
                $('#editRoundTo').attr('readonly', false);
                break;
        }

        $('#Rounding').prop('checked', rate.RoundDurationDown);
        $('#editMinimumDuration').val(rate.MininmumDuration);
        $('#editRoundCostTo').val(rate.RoundCostTo);
        $('#RoundingDigits').prop('checked', rate.RoundCostDown);
        $('#editFreeSeconds').val(rate.FreeSeconds);
        $('#editSubstractSeconds').val(rate.SubstractSeconds);

        /*ConnectionCostLessThen*/
        var l = rate.ConnectionCostLessThen;
        $('#editLessThen').val(l >= 0 ? l : -l);
        $('#editLessThenSelect').val(l >= 0 ? 1 : 2);

        /*ConnectionCostBefore*/
        var o = rate.ThenConnFee;
        $('#editThenCost').val(o >= 0 ? o : -o);
        $('#editThenCostSelect').val(o >= 0 ? 1 : 2);

        /*ConnectionCostAfter*/
        var r = rate.ElseConnFee;
        $('#editElseCost').val(r >= 0 ? r : -r);
        $('#editElseCostSelect').val(r >= 0 ? 1 : 2);

        $('#SingleCall').prop('checked', rate.SingleCall);
        $('#EnableAccounting').prop('checked', rate.EnableAccountingMode);

        if (rate.EnableAccountingMode)
            $('#AccountingModeSection').removeClass('disDiv');
        else
            $('#AccountingModeSection').addClass('disDiv');

        $('#EverySubNumber').prop('checked', rate.EverySub);
        $('#editAccountDescription').val(rate.AccountDescription);

        LoadModifiers();
        LoadStages();
    }

    function GetEmptyRate() {
        //return empty settings for rate
        return {
            ID: 0,
            RecDate: null,
            CurrencyID: MainCurrencyID,
            RoundDurationDown: false,
            RoundTo: 60,
            MininmumDuration: 0,
            RoundCostTo: 2,
            RoundCostDown: false,
            FreeSeconds: 0,
            SubstractSeconds: 0,
            ConnectionCostLessThen: 0,
            ThenConnFee: 0,
            ElseConnFee: 0,
            EnableAccountingMode: true,
            EverySub: false,
            AccountDescription: '',
            SingleCall: false
        };
    }

    function ApplyCurrent(applyDate) {
        if (currentRateDate === null) {
            ApplyRate(GetEmptyRate());
        }
        else {
            IsUpdate = applyDate;
            ApplyRate(rateDates[currentRateDate], applyDate);
        }
    }

    function SendRate(rate, async = false) {
        //send settings to server
        $.ajax({
            type: "POST",
            async: async,
            url: '/ServiceRate/SendRate',
            datatype: "json",
            data: rate
        });
    }

    function DeleteRate(id, async = false) {
        //set setting for delete
        $.ajax({
            type: "POST",
            async: async,
            url: '/ServiceRate/DeleteRecRate/' + id.toString().replace("'", '').replace("'", '') + '/' + $('#listRates').val()
        });
    }

    function AddNewSettings() {
        //create new settings
        var id = generateRandomNumber(1, 1000);
        var rate = GetEmptyRate();
        rate.ID = id;
        rate.RecDate = $('#datetimepicker').data('date');

        currentRateDate = IDToString(id);
        rateDates[currentRateDate] = rate;

        SendRate(rate, true);
        ApplyCurrent();

        $('#DatesList').append('<option value="' + id + '">' + $('#datetimepicker').data('date') + '</option>');
        $('#DatesList').val(id);
    }

    $('#cancelEdit').on('click', function () { window.open('/ServiceRate', '_parent'); });

    //enable or disable options for rate date
    $('#datetimepicker').on('dp.change', function () {

        if (IsUpdate) {
            IsUpdate = false;
            return;
        }

        if ($('#datetimepickerValue').val() === '') {
            $('#exTab').addClass('disDiv');
        }
        else {
            $('#exTab').removeClass('disDiv');

            if (IsAdd || Object.keys(rateDates).length === 0) {
                if (IsLoad) { return; }
                IsAdd = false;
                AddNewSettings();
            }
            else {
                //else edit current
                rateDates[currentRateDate].RecDate = $('#datetimepicker').data('date');
                $('#DatesList option[value=' + currentRateDate + ']').html($('#datetimepicker').data('date'));
                SendRate(rateDates[currentRateDate], true);
            }
        }
    });

    //button add new date
    $('#btnAddNewDate').on('click', function () {
        IsAdd = true;
        try { $('#datetimepicker').data("DateTimePicker").setDate(new Date()); } catch (e) { console.log(e); }
    });

    //clear date and set all fileds to null
    $('#btnClearRecDate').on('click', function () {
        $('option[value=' + currentRateDate + ']').remove();
        DeleteRate(currentRateDate, true);
        delete rateDates[currentRateDate];

        //deleted last element
        if (Object.keys(rateDates).length === 0) {
            try { $('#datetimepicker').data("DateTimePicker").setDate(null); } catch (e) { console.log(e); }
            $('#exTab').addClass('disDiv');
            currentRateDate = null;
        }
        //collection contains any other elements, apply random element from coll
        else {
            var id = GetAny(rateDates);
            $('#DatesList').val(id.toString().replace("'", '').replace("'", ''));
            currentRateDate = id;
            try { $('#datetimepicker').data("DateTimePicker").setDate(new Date(rateDates[id].RecDate)); } catch (e) { console.log(e); }
        }

        ApplyCurrent();
    });

    //switch between dates
    $('#DatesList').on('change', function (e) {
        var newID = IDToString($('#DatesList option:selected').val());
        rateDates[currentRateDate] = TakeRate(true);
        currentRateDate = newID;

        ApplyCurrent(true);
    });

    //evetn when changed currency
    $('#editCurrencyID').on('change', ApplyCurrencyName);

    //event when chaged roundTo
    $('#RodunToSelect').on('change', function () {
        var s = $('#RodunToSelect option:selected').val();

        switch (s) {
            case '1':
                $('#editRoundTo').val(60);
                $('#editRoundTo').attr('readonly', true);
                break;
            case '2':
                $('#editRoundTo').val(1);
                $('#editRoundTo').attr('readonly', true);
                break;
            case '3':
                $('#editRoundTo').attr('readonly', false);
                break;
            default:
                break;
        }

        LoadModifiers();
    });

    //enable or disable div with accounting mode options
    $('#EnableAccounting').on('click', function () {
        if ($('#EnableAccounting').is(':checked'))
            $('#AccountingModeSection').removeClass('disDiv');
        else
            $('#AccountingModeSection').addClass('disDiv');
    });

    //save opened setting before save rate
    $("form").submit(function () {
        if (currentRateDate !== null)
            TakeRate();
        return true;
    });

    //events for Add/Edit modifier
    //rate
    $('#editRateMinute').on('input', function () {
        var inputet = $('#editRateMinute').val() * 1;
        var common = $('#CommonRate').val() * 1;
        var secs = $('#editRoundTo').val() * 1;

        $('#editRateCustom').val(secs / 60 * inputet);
        $('#editRateFactor').val(inputet / common);
    });
    //custom rate
    $('#editRateCustom').on('input', function () {
        var inputet = $('#editRateCustom').val() * 1;
        var common = $('#CommonRate').val() * 1;
        var secs = $('#editRoundTo').val() * 1;

        $('#editRateMinute').val(inputet * 60 / secs);
        $('#editRateFactor').val(inputet * 60 / secs / common);
    });
    //factor
    $('#editRateFactor').on('input', function () {
        var inputet = $('#editRateFactor').val() * 1;
        var common = $('#CommonRate').val() * 1;
        var secs = $('#editRoundTo').val() * 1;

        $('#editRateMinute').val(common * inputet);
        $('#editRateCustom').val(common * inputet * secs / 60);
    });

    //event for add new modifieer
    $('#btnAddModifier').on('click', function () {
        $('#addModifierTitle').attr('hidden', false);
        $('#editModifierTitle').attr('hidden', true);

        $('#modifierEditId').val('0');

        if ($('#CommonRate').val() === '0')
            $('#editRateFactor').val('');

        $('#secLabel').html($('#editRoundTo').val());
        $('#editRateMinute').val('0');
        $('#editRateCustom').val('0');
        $('#editRateFactor').val('0');
        $('#editMinumumCost').val('0');

        $('#editRateFactor').removeClass('disDiv');
        $('#editFromHour').removeClass('disDiv');
        $('#editToHout').removeClass('disDiv');
        $('#DayType').removeClass('disDiv');

        $('#confirmModifier').modal('show');
    });

    //event for edit selected
    $('#btnEditModifier').on('click', function () {

        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/GetModifier/' + selectedModifier + '/' + currentRateDate.toString().replace("'", '').replace("'", ''),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#addModifierTitle').attr('hidden', true);
                    $('#editModifierTitle').attr('hidden', false);

                    $('#modifierEditId').val(selectedModifier);

                    $('#editRateMinute').val(response.modifier.Rate);
                    $('#editRateCustom').val(response.modifier.Rate2);
                    $('#editMinumumCost').val(response.modifier.MinimumCost);

                    if (selectedModifierIsCommon === 'True') {
                        $('#editRateFactor').addClass('disDiv');
                        $('#editRateFactor').val('1');

                        $('#editFromHour').addClass('disDiv');
                        $('#editToHout').addClass('disDiv');
                        $('#DayType').addClass('disDiv');
                    }
                    else {
                        $('#editRateFactor').removeClass('disDiv');
                        $('#editRateFactor').val(response.modifier.Factor);

                        $('#editFromHour').removeClass('disDiv');
                        $('#editFromHour').val(response.modifier.FromHour);

                        $('#editToHout').removeClass('disDiv');
                        $('#editToHout').val(response.modifier.ToHour);

                        $('#DayType').removeClass('disDiv');
                        $('#DayType').val(response.modifier.DayType);
                    }
                    $('#confirmModifier').modal('show');
                }
            }
        });
    });

    //submit save modifier
    $('#RateModifierSave').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/EditModifier/' + $('#modifierEditId').val() +
                '/' + currentRateDate.toString().replace("'", '').replace("'", '') +
                '/' + $('#editRateMinute').val() +
                '/' + $('#editMinumumCost').val() +
                '/' + $('#DayType option:selected').val() +
                '/' + $('#editFromHour').val() +
                '/' + $('#editToHout').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadModifiers();
                    selectedModifier = null;
                    UpdateButtonsForModifier();
                    $('#confirmModifier').modal('hide');
                }
            }
        });
    });

    //show delete modal for modifier
    $('#btnDeleteModifier').on('click', function () {
        $('#cannotDeleteEdit').attr('hidden', true);
        $('#confirmDeleteEditButton').attr('disabled', false);

        $('#confirmDeleteEdit').modal('show');
    });

    //confdirm delete modifier
    $('#confirmDeleteEditButton').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/DeleteModifier/' + selectedModifier + '/' + currentRateDate.toString().replace("'", '').replace("'", ''),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadModifiers();
                    selectedModifier = null;
                    UpdateButtonsForModifier();
                    $('#confirmDeleteEdit').modal('hide');
                }
                else {
                    $('#cannotDeleteEdit').attr('hidden', false);
                    $('#confirmDeleteEditButton').attr('disabled', true);
                }
            }
        });
    });

    //show window for add stage
    $('#btnAddStages').on('click', function () {
        $('#addStageTitle').attr('hidden', false);
        $('#editStageTitle').attr('hidden', true);

        $('#stageEditId').val('0');
        $('#editQuantity').val('0');
        $('#editStageFactor').val('1');

        $('#confirmStage').modal('show');
    });

    //show delete modal fro stage
    $('#btnDeleteStages').on('click', function () {
        $('#cannotDeleteEdit').attr('hidden', true);
        $('#confirmDeleteEditButton').attr('disabled', false);

        $('#confirmDeleteStage').modal('show');
    });

    //event for edit selected
    $('#btnEditStages').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/GetStage/' + selectedStage + '/' + currentRateDate.toString().replace("'", '').replace("'", ''),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#addStageTitle').attr('hidden', true);
                    $('#editStageTitle').attr('hidden', false);

                    $('#stageEditId').val(response.stage.ID);
                    $('#editQuantity').val(response.stage.Quantity);
                    $('#editStageFactor').val(response.stage.Factor);

                    $('#confirmStage').modal('show');
                }
            }
        });
    });

    //confirm deleting stage
    $('#confirmDeleteStageButton').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/DeleteStage/' + selectedStage + '/' + currentRateDate.toString().replace("'", '').replace("'", ''),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadStages();
                    selectedStage = null;
                    UpdateButtonsForStages();
                    $('#confirmDeleteStage').modal('hide');
                }
            }
        });
    });

    //confirm save stage
    $('#StageSave').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/EditStage/' + $('#stageEditId').val() +
                '/' + currentRateDate.toString().replace("'", '').replace("'", '') +
                '/' + $('#editQuantity').val() +
                '/' + $('#editStageFactor').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadStages();
                    selectedStage = null;
                    UpdateButtonsForStages();
                    $('#confirmStage').modal('hide');
                }
            }
        });
    });

    //change rate plan
    $('#listRates').change(function () {
        $('#divForm').addClass('disDiv');
        $('#planSelectionSection').addClass('disDiv');

        openRateNow = true;
        $('#submitButton').click();
    });

    //submit form
    $('#editRateForm').on("submit", function (e) {
        if (openRateNow) {
            e.preventDefault();

            $.ajax({
                type: $(this).attr('method'),
                url: $(this).attr('action'),
                data: $(this).serialize(),
                success: () => {
                    openRateNow = false;
                    rateDates = [];
                    currentRateDate = null;

                    $.ajax({
                        type: "POST",
                        async: true,
                        url: '/ServiceRate/GetLastID/',
                        traditional: true,
                        success: function (response) {
                            if (response !== null && response.success === true) {
                                window.open('/ServiceRate/EditRate/' + $('#listRates').val() + '/' + response.id, '_parent');
                            }
                        }
                    });


                }
            });

            return true;
        }
    });

    //disable selected rate when empty rate name
    $('#rateName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#planSelectionSection').addClass('disDiv');
        }
        else {
            $('#planSelectionSection').removeClass('disDiv');
        }
    });

    //get main currency id for create empty settings
    $.ajax({
        type: "POST",
        async: true,
        url: '/ServiceRate/GetMainCurrencyID',
        traditional: true,
        success: function (response) {
            if (response !== null && response.success === true) {
                MainCurrencyID = response.id;
                $('#urlForm').val(window.location.pathname);
            }
        }
    });

    //setup current plan
    $('#listRates').val($('#rateForEditPlaneID').val());

    if ($('#rateName').val() !== '') {

        //show edit title
        if ($('#divForm > form').attr('action').includes('EditRate')) {
            $('#lblAdd').attr('hidden', true);
            $('#lblEdit').attr('hidden', false);
            $('#lblCopy').attr('hidden', true);

            $('#lblKdb_edit').html($('#rateName').val());
        }
        //show copy title
        else if ($('#divForm > form').attr('action').includes('CopyRate')) {
            $('#lblAdd').attr('hidden', true);
            $('#lblEdit').attr('hidden', true);
            $('#lblCopy').attr('hidden', false);

            $('#lblKdb_copy').html($('#rateName').val());
        }
        //show add title
        else {
            $('#lblAdd').attr('hidden', false);
            $('#lblEdit').attr('hidden', true);
            $('#lblCopy').attr('hidden', true);
        }

        //load if not empty
        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/GetRateSettings/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    IsLoad = true;
                    response.SettingsPool.forEach(function (e) {
                        try { $('#datetimepicker').data("DateTimePicker").setDate(new Date(e.RecDate)); } catch (e) { console.log(e); }
                        $('#DatesList').append('<option value="' + e.ID + '">' + $('#datetimepicker').data('date') + '</option>');
                        rateDates["'" + e.ID + "'"] = e;
                    });

                    var id = GetAny(rateDates);
                    $('#DatesList').val(id.toString().replace("'", '').replace("'", ''));
                    currentRateDate = id;
                    try { $('#datetimepicker').data("DateTimePicker").setDate(new Date(rateDates[id].RecDate)); } catch (e) { console.log(e); }
                    IsLoad = false;

                    ApplyCurrent();
                }
            }
        });
    }
    else {
        $('#planSelectionSection').addClass('disDiv');
    }

    initDateTimePicker();
});