﻿$(document).ready(() => {
    let selectedDNPlans = [];

    function initdatetimepickers() {
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),
            locale: $('#LocaleThread').val(),
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true,
            format: 'L'
        };

        $('#datetimepickerFromDNPlan').datetimepicker(options);
    }

    function RemoveFromArray(array, element) {
        //remove element form array
        const index = array.indexOf(element);

        if (index !== -1) {
            array.splice(index, 1);
        }
    }

    function UpdateDNPlansButtonUI() {
        if (selectedDNPlans.length === 0) {
            $('#btnEditdnplan').prop('disabled', true);
            $('#btnDeletednplan').prop('disabled', true);
        }
        else if (selectedDNPlans.length === 1) {
            $('#btnEditdnplan').prop('disabled', false);
            $('#btnDeletednplan').prop('disabled', false);
        }
        else {
            $('#btnEditdnplan').prop('disabled', true);

            $('#btnDeletednplan').prop('disabled', false);
        }
    }

    function AttachEventsToDNPlans() {
        var header = document.getElementById("PlansDNHead");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        selectedDNPlans = [];

        $('#tariscope-plan tbody').on('click', 'tr', function (e) {
            if (e.shiftKey) {//select via shift
                var newIndex = $(this).index();

                var table = $('#tariscope-plan');

                //init first row
                if (rowIndex === null)
                    rowIndex = $(this).index();

                tempIndex = rowIndex;

                //clear prev selected
                selectedDNPlans = [];

                $('#tariscope-plan tr.selected').removeClass('selected');

                var direction = newIndex >= rowIndex;

                if (direction) {//select down
                    while (tempIndex <= newIndex) {
                        tempIndex += 1;

                        var tr = $('tr:eq(' + tempIndex + ')', table);

                        if (tr.css('display') !== 'none') {
                            tr.addClass('selected');
                            RemoveFromArray(selectedDNPlans, tr.find('td[data-name="ID"]').text());
                            selectedDNPlans.push(tr.find('td[data-name="ID"]').text());
                        }
                    }
                }
                else {//select up
                    while (tempIndex > (newIndex - 1)) {
                        var tr2 = $('tr:eq(' + (tempIndex + 1) + ')', table);

                        if (tr2.css('display') !== 'none') {
                            tr2.addClass('selected');
                            RemoveFromArray(selectedDNPlans, tr2.find('td[data-name="ID"]').text());
                            selectedDNPlans.push(tr2.find('td[data-name="ID"]').text());
                        }

                        tempIndex -= 1;
                    }
                }
            }
            else {//single select
                rowIndex = $(this).index();

                selectedDNPlans = [];

                if ($(this).hasClass('selected')) {
                    $('#tariscope-plan tr.selected').removeClass('selected');
                }
                else {
                    $('#tariscope-plan tr.selected').removeClass('selected');
                    selectedDNPlans.push($(this).find('td[data-name="ID"]').text());
                    $(this).addClass('selected');
                }
            }

            UpdateDNPlansButtonUI();
        });

        UpdateDNPlansButtonUI();
    }

    function LoadDNPlans() {
        $('#dnplansTable').load('/Subscribers/GetDNPlansTable/' + $('#DNIDForPlans').val(), AttachEventsToDNPlans);
    }

    //back to dns
    $('#btnBackToDNFromDNPlans').on('click', () => {
        $('#additionalSection').load('/Subscribers/GetExtensions');
    });

    //show modal to add a new plan
    $('#btnAdddnplan').on('click', () => {
        $('#saveDNPlanbtn').unbind();
        $('#editDNPlantitle').text($('#newABPlanTitle').val());
        $('#datetimepickerFromDNPlan').data("DateTimePicker").setDate(new Date());

        //add plan
        $('#saveDNPlanbtn').on('click', () => {
            $('#editDNPlanmodal').modal('hide');
            ShowSpinner(true);

            var formData = new FormData();
            formData.append('from', $('#datetimepickerFromDNPlan').data('date'));
            formData.append('plan', $('#dnPlane').val());

            $.ajax({
                type: 'POST',
                async: true,
                url: '/Subscribers/AddADNPlan/' + $('#DNIDForPlans').val(),
                data: formData,
                datatype: 'application/octet-stream',
                contentType: false,
                processData: false,
                traditional: true,
                success: function (response) {
                    ShowSpinner(false);
                    LoadDNPlans();
                }
            });
        });

        $('#editDNPlanmodal').modal('show');
    });

    //show modal for delete abonent dn
    $('#btnDeletednplan').on('click', () => {
        $('#deleteDNplanConfirm').prop('disabled', false);
        $('#deleteDNplan').modal('show');
    });

    //confirm delete dn
    $('#deleteDNplanConfirm').on('click', () => {
        $('#deleteDNplan').modal('hide');
        ShowSpinner(true);

        $.ajax({
            method: 'POST',
            data: { ids: selectedDNPlans },
            dataType: "json",
            url: '/Subscribers/DeleteDNPlan/',
            success: function (response) {
                ShowSpinner(false);
                LoadDNPlans();
            }
        });
    });

    //show modal for edit plan
    $('#btnEditdnplan').on('click', () => {
        $('#saveDNPlanbtn').unbind();
        $('#editDNPlantitle').text($('#editABPlanTitle').val());

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetDNPlan/' + $('#DNIDForPlans').val() + '/' + selectedDNPlans[0],
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#dnPlane').val(response.plan);
                    $('#datetimepickerFromDNPlan').data("DateTimePicker").setDate(new Date(response.from));

                    //update plan
                    $('#saveDNPlanbtn').on('click', () => {
                        $('#editDNPlanmodal').modal('hide');
                        ShowSpinner(true);

                        var formData = new FormData();
                        formData.append('from', $('#datetimepickerFromDNPlan').data('date'));
                        formData.append('plan', $('#dnPlane').val());

                        $.ajax({
                            type: 'POST',
                            async: true,
                            url: '/Subscribers/UpdateDNPlan/' + selectedDNPlans[0],
                            data: formData,
                            datatype: 'application/octet-stream',
                            contentType: false,
                            processData: false,
                            traditional: true,
                            success: function (response) {
                                if (response !== null && response.success === true) {
                                    ShowSpinner(false);
                                    LoadDNPlans();
                                }
                            }
                        });
                    });

                    $('#editDNPlanmodal').modal('show');
                }
            }
        });
    });

    LoadDNPlans();
    initdatetimepickers();
});