﻿$(document).ready(() => {
    let selectedAbonent = null;
    let isRes = false;

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/RestrictedSubscribers/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/RestrictedSubscribers/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function ExpandLeftMenu() {
        try {
            if (NodeIsLoaded) {
                ShowNodes('NewNodesMenu');
                ShowNodeEntry($('#nodeID').val() + '');
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }

    }

    function UpdateButtons() {
        if (selectedAbonent !== null) {
            $('#btnDisableRestrict').prop('disabled', !isRes);
            $('#btnEdit').prop('disabled', false);
        }
        else {
            $('#btnDisableRestrict').prop('disabled', true);
            $('#btnEdit').prop('disabled', true);
        }
    }

    function AttachEvents() {
        selectedAbonent = null;
        isRes = false;

        $('#resAbTable tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedAbonent = null;
                isRes = false;
            }
            else {
                selectedAbonent = $(this).find('td[data-name="ID"]').text();
                isRes = $(this).data('status') === 'Restricted';
                $('#resAbTable tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtons();
        });
        UpdateButtons();

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/RestrictedSubscribers/SetSort/?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        Load();
                    }
                }
            });
        });
    }

    function Load() {
        $('#restrSubscribersTable').load('/RestrictedSubscribers/Load/?Search=' + encodeURIComponent($('#tbSearch').val()), AttachEvents);
    }

    /*attach events for select column*/
    $('#MenuSelectColumn input').on('click', function (event) {
        var visible = $(event.target).prop('checked');
        var colName = $(event.target).attr('data-value');

        $.ajax({
            type: "POST",
            url: '/RestrictedSubscribers/SetTableColumnVisability/?colName=' + colName + "&visible=" + visible,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    Load();
                }
            }
        });
    });

    //save load all state
    $('#ShowAll').change(() => {
        $.ajax({
            type: "POST",
            url: '/RestrictedSubscribers/SetLoadAll/?state=' + $('#ShowAll').prop('checked'),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    Load();
                }
            }
        });
    });

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            Load();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //edit abonent
    $('#btnEdit').on('click', () => { window.location = '/Subscribers/' + $('#nodeID').val() + '#' + selectedAbonent; });

    //disable restirction
    $('#btnDisableRestrict').on('click', () => {
        if (isRes) {
            ShowSpinner(true);
            $.ajax({
                type: "POST",
                url: '/RestrictedSubscribers/Unrestrict/' + selectedAbonent,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        Load();
                        ShowSpinner(false);
                        $('#addedModal').modal('show');
                    }
                }
            });
        }
    });

    ExpandLeftMenu();
    Load();
});