﻿$(document).ready(function () {
    var _selectedViewId = null;

    _loadDataViews();

    function _loadDataViews() {
        console.log("_loadDataviews");
        var dataViews;

        $.ajax({
            type: "GET",
            async: false,
            url: '/api/dataviews/descriptions',
            contentType: "application/json",
            dataType: "json",
            success: function (data) {
                dataViews = data;
            }
        });

        _fillTable(dataViews);
    }

    function _fillTable(dataViews) {
        var rows = '';

        $.each(dataViews, function (index, dataView) {
            rows += '<tr data-id="' + dataView.Id + '">' +
                        '<td>' + dataView.Name + '</td>' +
                        '<td>' + dataView.ViewType + '</td>' +
                        '<td>' + dataView.Owner + '</td>' +
                    '</tr>';
        });

        $('table tbody').empty().append(rows);
    };

    $('table tbody').on('click', 'tr', function () {
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
            _selectedViewId = null;
            _changeButtonsState(true);
        }
        else {
            _selectedViewId = $(this).data('id');
            $('table tr.selected').removeClass('selected');
            $(this).addClass('selected');
            _changeButtonsState(false);
        }
    });

    function _changeButtonsState(active) {
        $('#btn-tools button[data-name="Open"]').attr('disabled', active);
        $('#btn-tools button[data-name="Edit"]').attr('disabled', active);
        $('#btn-tools button[data-name="Delete"]').attr('disabled', active);
    }


    $('table tbody').on('dblclick', 'tr', function () {
        url = '/DataViews/Detail?id=' + $(this).data('id');
        location.href = url;
    });

    $('#btn-tools').on('click', 'button[data-name="Open"]', function () {
        url = '/DataViews/Detail?id=' + _selectedViewId;
        location.href = url;
    });

    $('#btn-tools').on('click', 'button[data-name="Add"]', function () {
        url = '/DataViews/Edit';
        location.href = url;
    });

    $('#btn-tools').on('click', 'button[data-name="Edit"]', function () {
        url = '/DataViews/Edit?id=' + _selectedViewId;
        location.href = url;
    });

    $('#btn-tools').on('click', 'button[data-name="Delete"]', function () {
        $.ajax({
            type: 'DELETE',
            url: '/api/dataviews/' + _selectedViewId,
            contentType: 'application/json',
            success: function (data) {
                _loadDataViews();
            },
            dataType: 'html'
        });
    });
});