﻿var providerIsLoaded = false;   //show, provider loaded or not
var providers = [];             //list of all providers

{
    let ProviderLevelMargin = 7;

    let itemsList = [];             //list of all added menu items
    let itemsLevel = [];            //list for all added menu items margin set
    let providersState = {};        //state for providers (true: open, false: closed)
    let providersOutIncState = {};  //state for providers (outgoing, incoming) (true: open, false: closed)
    let providersOutIncLink = {};
    let providersEntryState = {};   //state for providers (codes, ip, etc) (true: open, false: closed)

    let providerRandomIcon = ['globe-europe', 'globe-asia', 'globe-americas', 'globe-africa'];

    function BuildItem(root, id, title, level, url, ic, chevrone, fa = "fa") {
        /* create menu tree-item */
        var li = document.createElement('li');
        li.id = id;
        li.className = "treeItem";

        var a = document.createElement('a');
        if (url !== null)
            a.href = url;
        else
            a.href = 'javascript:;';

        a.style.marginLeft = ProviderLevelMargin * level + "px";

        var icon = document.createElement('i');
        icon.id = "iconTree";
        icon.className = fa + " fa-" + ic;

        var ttl = document.createElement('span');
        ttl.innerHTML = title;

        a.appendChild(icon);
        a.appendChild(ttl);

        if (chevrone) {
            var chev = document.createElement('i');
            chev.className = "fa fa-chevron-down treeChevroneRight treeChevroneSmall";

            a.appendChild(chev);
        }

        li.appendChild(a);


        $(li).insertAfter($('#' + root));

        itemsList.push(li);
        itemsLevel.push(level);

        $(li).hide();

        return li.id;
    }

    function changeLevel(item, level) {
        /*change left margin for menu items*/
        $(item).find('a').css('margin-left', ProviderLevelMargin * level + "px");
    }

    function showChevron(item, show) {
        /* show or hide chevron icon*/
        if (show) {
            $(item).find($('.treeChevroneRight')).hide();
        }
        else {
            $(item).find($('.treeChevroneRight')).show();
        }
    }

    function rotateChevron(item, back) {
        /* show or hide chevron icon*/
        if (back) {
            $('#' + item).find($('.treeChevroneRight')).css('transform', 'rotate(-90deg)');
        }
        else {
            $('#' + item).find($('.treeChevroneRight')).css('transform', 'rotate(0)');
        }
    }

    function ShowProviders(parent, force = false) {
        /*show all providers*/
        providers.forEach(function (element) {
            if (force || providersState[element]) {
                $('#' + element).slideDown("fast");

                providersState[element] = false;
            }
            else {
                $('#' + element).slideUp("fast");
                ShowProviderOutInc(element, true);
                CloseAllProvidersEntry();
                CloseAllProvidersOutInc();
                providersState[element] = true;
            }

            rotateChevron(parent, !providersState[element]);
        });
    }

    function ShowProviderOutInc(provider, force = false) {
        let link = 'Provider_' + provider.ID;
        let linkOut = link + "_" + provider.OID;
        let linkIn = link + "_" + provider.IID;

        /*show incoming and outgoing for provider*/
        if (force || !providersOutIncState[link]) {
            $('#' + linkOut).slideUp("fast");
            $('#' + linkIn).slideUp("fast");

            providersOutIncState[link] = true;

            ShowProviderEntry(linkOut, true);
            ShowProviderEntry(linkIn, true);
        }
        else {
            CloseAllProvidersEntry();
            CloseAllProvidersOutInc();

            $('#' + linkOut).slideDown("fast");
            $('#' + linkIn).slideDown("fast");

            providersOutIncState[link] = false;
        }

        rotateChevron(link, !providersOutIncState[link]);
    }

    window.ShowProvider = function (ID) {
        let provider = $('[id ^=Provider_][id $=' + ID + ']');
        let link = $(provider).prop('id').replace('_' + ID, '');
        let links = link + '_';

        $('li[id^="' + links + '"]').not('[id $="_des"]').not('[id $="_ip"]').not('[id $="_day"]').not('[id $="_rat"]').slideDown("fast");

        providersOutIncState[link] = false;

        ShowProviderEntry(link + '_' + ID);
    };

    window.AddNewProvider = function (Provider) {
        AddProvider('ProvidersManagement', Provider, true);
    };

    function CloseAllProvidersOutInc() {
        /*only one provider can be opened, i think so*/

        for (var key in providersOutIncState) {
            if (!providersOutIncState[key]) {
                $('#' + providersOutIncLink[key + 'i']).slideUp("fast");
                $('#' + providersOutIncLink[key + 'o']).slideUp("fast");

                providersOutIncState[key] = true;
                rotateChevron(key, false);
            }
        }
    }

    function ShowProviderEntry(entry, force = false) {
        /*show entry of incoming and outgoing for provider*/
        if (force || !providersEntryState[entry]) {
            $('#' + entry + "_des").slideUp("fast");
            $('#' + entry + "_ip").slideUp("fast");
            $('#' + entry + "_day").slideUp("fast");
            $('#' + entry + "_rat").slideUp("fast");

            providersEntryState[entry] = true;
        }
        else {
            CloseAllProvidersEntry();

            $('#' + entry + "_des").slideDown("fast");
            $('#' + entry + "_ip").slideDown("fast");
            $('#' + entry + "_day").slideDown("fast");
            $('#' + entry + "_rat").slideDown("fast");

            providersEntryState[entry] = false;
        }

        rotateChevron(entry, !providersEntryState[entry]);
    }

    function CloseAllProvidersEntry() {
        /*only one entry can be opened, i think so*/
        for (var key in providersEntryState) {
            if (!providersEntryState[key]) {
                $('#' + key + "_des").slideUp("fast");
                $('#' + key + "_desTab").slideUp("fast");
                $('#' + key + "_ip").slideUp("fast");
                $('#' + key + "_day").slideUp("fast");
                $('#' + key + "_rat").slideUp("fast");

                providersEntryState[key] = true;
                rotateChevron(key, false);
            }
        }
    }

    function BuildManagement(parent, show = false) {
        var codes = BuildItem(parent, "TelephoneCodes", $('#LeftSideLocalizationString_CommonTelephoneCodes').val(), 1, '/TelephoneCodes', 'hashtag', false);
        var management = BuildItem(codes, "ProvidersManagement", $('#LeftSideLocalizationString_ProviderManagement').val(), 1, '/ProvidesAndRates/Management', 'atlas', false);

        providers.push(management);
        providersState[management] = !show;
        providers.push(codes);
        providersState[codes] = !show;

        return management;
    }

    function AddProvider(parent, provider, show = false) {
        //root provider
        var randomIcon = providerRandomIcon[Math.floor(Math.random() * providerRandomIcon.length)];
        var providerMenuItem = BuildItem(parent, "Provider_" + provider.ID, provider.Name, 2, null, randomIcon, true);

        providers.push(providerMenuItem);
        providersState[providerMenuItem] = !show;
        providersOutIncState[providerMenuItem] = true;

        $('#' + providerMenuItem).on('click', function () { ShowProviderOutInc(provider); });

        //outgoing
        var providerMenuItem_out = BuildItem(providerMenuItem, providerMenuItem + "_" + provider.OID, $('#LeftSideLocalizationString_Outgoing').val(), 4, null, "phone", true);

        providersEntryState[providerMenuItem_out] = true;
        providersOutIncLink[providerMenuItem + 'o'] = providerMenuItem_out;

        $('#' + providerMenuItem_out).on('click', function () { ShowProviderEntry(providerMenuItem_out); });

        var providerMenuItem_out_des = BuildItem(providerMenuItem_out, providerMenuItem_out + "_des", $('#LeftSideLocalizationString_DestinationCodes').val(), 6, '/TelephoneCodes/Provider/' + provider.OID, "list-ul", false);
        var providerMenuItem_out_ip = BuildItem(providerMenuItem_out_des, providerMenuItem_out + "_ip", $('#LeftSideLocalizationString_IPNetowrks').val(), 6, '/ProvidesAndRates/IPNetworks/' + provider.OID, "edge", false, "fab w200 fab");
        var providerMenuItem_out_day = BuildItem(providerMenuItem_out_ip, providerMenuItem_out + "_day", $('#LeftSideLocalizationString_DayTypes').val(), 6, '/ProvidesAndRates/DayTypes/' + provider.OID, "calendar-alt", false);
        var providerMenuItem_out_rat = BuildItem(providerMenuItem_out_day, providerMenuItem_out + "_rat", $('#LeftSideLocalizationString_Rates').val(), 6, '/ProvidesAndRates/Rates/' + provider.OID, "th", false);

        //incoming
        var providerMenuItem_inc = BuildItem(providerMenuItem_out_rat, providerMenuItem + "_" + provider.IID, $('#LeftSideLocalizationString_Incoming').val(), 4, null, "phone", true);

        providersEntryState[providerMenuItem_inc] = true;
        providersOutIncLink[providerMenuItem + 'i'] = providerMenuItem_inc;

        $('#' + providerMenuItem_inc).on('click', function () { ShowProviderEntry(providerMenuItem_inc); });

        var providerMenuItem_inc_des = BuildItem(providerMenuItem_inc, providerMenuItem_inc + "_des", $('#LeftSideLocalizationString_DestinationCodes').val(), 6, '/TelephoneCodes/Provider/' + provider.IID, "list-ul", false);
        var providerMenuItem_inc_ip = BuildItem(providerMenuItem_inc_des, providerMenuItem_inc + "_ip", $('#LeftSideLocalizationString_IPNetowrks').val(), 6, '/ProvidesAndRates/IPNetworks/' + provider.IID, "edge", false, "w200 fab");
        var providerMenuItem_inc_day = BuildItem(providerMenuItem_inc_ip, providerMenuItem_inc + "_day", $('#LeftSideLocalizationString_DayTypes').val(), 6, '/ProvidesAndRates/DayTypes/' + provider.IID, "calendar-alt", false);
        var providerMenuItem_inc_rat = BuildItem(providerMenuItem_inc_day, providerMenuItem_inc + "_rat", $('#LeftSideLocalizationString_Rates').val(), 6, '/ProvidesAndRates/Rates/' + provider.IID, "th", false);

        if (show)
            ShowProviders('ProvidersMenu', true);

        return providerMenuItem_inc_rat;
    }

    function DeleteProvider(selectedProvider) {
        //delete provider menu items form left side menu
        ShowProviderOutInc('Provider_' + selectedProvider, true, function () {
            $('#Provider_' + selectedProvider).slideUp('fast', function () {
                $('#Provider_' + selectedProvider).remove();
                $('#Provider_' + selectedProvider + '_out').remove();
                $('#Provider_' + selectedProvider + '_inc').remove();

                $('#Provider_' + selectedProvider + '_inc_des').remove();
                $('#Provider_' + selectedProvider + '_inc_desTab').remove();
                $('#Provider_' + selectedProvider + '_inc_ip').remove();
                $('#Provider_' + selectedProvider + '_inc_day').remove();
                $('#Provider_' + selectedProvider + '_inc_rat').remove();

                $('#Provider_' + selectedProvider + '_out_des').remove();
                $('#Provider_' + selectedProvider + '_out_desTab').remove();
                $('#Provider_' + selectedProvider + '_out_ip').remove();
                $('#Provider_' + selectedProvider + '_out_day').remove();
                $('#Provider_' + selectedProvider + '_out_rat').remove();
            });
        });
    };

    function RenameProvider(selectedProvider, newName) {
        //rename provider in left side menu
        $('#Provider_' + selectedProvider + ' a span').html(newName);
    };

    function LoadProviders() {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/ProvidesAndRates/GetMenu/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    var parent = BuildManagement('ProvidersMenu');
                    response.list.forEach(e => { parent = AddProvider(parent, e); });

                    providerIsLoaded = true;

                    if (window.location.href.includes('/TelephoneCodes') || window.location.href.includes('/ProvidesAndRates'))
                        ShowProviders('ProvidersMenu');
                }
            }
        });
    }

    $(document).ready(function () {

        /*hide chevron icon and set margin left to 0 whet menu is closing*/
        $('#MenuHamburger').on('click', function () {
            if ($('#SideMenu').width() >= 250) {
                itemsList.forEach(function (element) {
                    changeLevel(element, 0);
                    showChevron(element, true);
                });

                showChevron($('#ProvidersMenu'), true);
            }
            else {
                var i = 0;
                itemsList.forEach(function (element) {
                    changeLevel(element, itemsLevel[i]);
                    showChevron(element, false);
                    i++;
                });

                showChevron($('#ProvidersMenu'), false);
            }

        });

        /*show or hide all providers if url = /Providers/Index else go to this url*/
        $('#ProvidersMenu').on('click', function () {
            ShowProviders('ProvidersMenu');
        });

        LoadProviders();
    });
}