﻿using System;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;

/// <summary>

/// ''' Load Call Detail Recording information from CS1000 CDR buffer (older vxWorks releases)

/// ''' </summary>

/// ''' <remarks></remarks>
public class LoadCdrPdtNortelCS1000 : IScript
{
    private IScriptHost Host;


    public void Init(IScriptHost host)
    {
        this.Host = host;
        host.Close += OnClose;
    }
    private void OnClose(ref bool Cancel)
    {
        return;
    }
    public void Main(object Parameters)
    {
        try
        {
            Host.Send(Convert.ToChar(13).ToString());

            
            Host.WaitFor("pdt>");
            // moving to cdr directory
            Host.Send("cd c:/u/smp_DB/" + Convert.ToChar(13));
            Host.WaitFor("pdt>");
            // renaming current cdr file
            Host.Send("ren dba.cdr dba2.cdr" + Convert.ToChar(13));
            Host.WaitFor("pdt>");
            // restoring new dba.cdr
            Host.Send("echo  >dba.cdr" + Convert.ToChar(13));
            Host.WaitFor("pdt>");
            // listing cdr
            Host.Send("cat dba2.cdr" + Convert.ToChar(13));
            Host.WaitFor("pdt>");

            // deleting listed cdr & quiting
            Host.Send("del dba2.cdr" + Convert.ToChar(13));
            Host.WaitFor("pdt>");
        }
        catch (Exception ex)
        {
            this.Host.AddEvent(ex.ToString());
        }
    }
}
