﻿using System;
using Microsoft.Data.SqlClient;
using SoftPi.Tariscope.Common;
using SoftPi.Tariscope.DAL;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;

public class LimitingGroupEmailScript : IScript
{
    private IScriptHost Host;
    private const string MailSubjectRestrict = "Tariscope limiting notification";
    private const string MailSubjectUnrestrict = "Tariscope limiting notification (unrestrict)";

    public void Init(IScriptHost host)
    {
        this.Host = host;
        host.Close += OnClose;
    }
    private void OnClose(ref bool Cancel)
    {
        return;
    }
    public void Main(object Parameters)
    {
        try
        {
            DepartmentLimitingActionParameters ActionParameters = (DepartmentLimitingActionParameters)Parameters;

            this.Host.AddEvent(string.Format("Limiting event, Group: {0}, Category: {2}", ActionParameters.Group.Name, ActionParameters.CosValue, ActionParameters.Credit.CategoryID));
            this.Host.AddEvent(ActionParameters.ActionType.ToString());

            string CategoryName = string.Empty;
            Abonent GroupHead = null/* TODO Change to default(_) if this is not a reference type */;
            using (SqlConnection cn = new SqlConnection(this.Host.DatabaseConnectionString))
            {
                cn.Open();
                if (ActionParameters.Credit.CategoryID.HasValue)
                    CategoryName = Categories.Instance(cn).Details(ActionParameters.Credit.CategoryID.Value).Name;
                /*else
                    CategoryName = "All categories";
                if (ActionParameters.Group.HeadAbonentID.HasValue)
                    GroupHead = Abonents.Instance(cn).Details(ActionParameters.Group.HeadAbonentID.GetValueOrDefault());*/
            }
            if (ActionParameters.ActionType == RestrictStatus.QueueRestrict)
            {
                string MessageText = string.Format("Restricted group: {0}, Category: {2}, Limit: {3}, Charged: {4}", ActionParameters.Group.Name, ActionParameters.CosValue, CategoryName, ActionParameters.Credit.Credit, ActionParameters.Credit.Debit);
                MessageText = string.Format("Ограничить подразделение: {0}, Категория: {2}, Установленный лимит: {3:0.00} тг, Затраты по факту: {4:0.00} тг", ActionParameters.Group.Name, ActionParameters.CosValue, CategoryName, ActionParameters.Credit.Credit, ActionParameters.Credit.Debit);
                this.Host.SendMail("", MailSubjectRestrict, MessageText);
                this.Host.Wait(5000);
                if (GroupHead != null && !string.IsNullOrEmpty(GroupHead.EMail))
                {
                    this.Host.SendMail(GroupHead.EMail, MailSubjectRestrict, MessageText);
                    this.Host.Wait(5000);
                }
            }
            else if (ActionParameters.ActionType == RestrictStatus.QueueUnrestrict)
            {
                string MessageText = string.Format("Unrestricted group:{0}, Category: {2}", ActionParameters.Group.Name, ActionParameters.CosValue, CategoryName);
                this.Host.SendMail("", MailSubjectUnrestrict, MessageText);
                this.Host.Wait(5000);
                if (GroupHead != null && !string.IsNullOrEmpty(GroupHead.EMail))
                {
                    this.Host.SendMail(GroupHead.EMail, MailSubjectUnrestrict, MessageText);
                    this.Host.Wait(5000);
                }
            }

            ActionParameters.Result = MediationActionResult.Success;
        }
        catch (Exception ex)
        {
            this.Host.AddEvent(ex.ToString());
        }
    }
}
