﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;
using Microsoft.Data.SqlClient;

public class MissedReaction : IScript
{
    //////////////////////////
    ///     PARAMETERS     ///
    //////////////////////////

    /*Record type, 4 - unanswered calls*/
    int RecType = 4;

    /*
     *  Call directions
     *  If all are false - call direction will be ignored
     */
    bool IncludeIncoming = true;
    bool IncludeOutgoing = false;
    bool IncludeInternal = false;

    /*
     *  Check only the specified numbers A
     *  Example, check only number 100 and 101
     *  List<string> NumbersA = new List<string> { "100", "101" };
     *  Leave empty to check the all numbers A
     */
    List<string> NumbersA = new List<string> { };

    /*
     *  Check only the specified numbers B
     *  Example is the same as for NumbersA
     *  Leave empty to check the all numbers B
     */
    List<string> NumbersB = new List<string> { };

    /*Email settings*/
    bool SendEmail = true;
    /*Leave empty to send to default admin email*/
    string Email = "";
    string MessageBody = "A new missed call detected:\n" +
                         "ID: {0}\n" +
                         "NumberA: {1}\n" +
                         "NumberB: {2}\n" +
                         "Call time: {3}\n" +
                         "Calling: {4}\n" +
                         "Called: {5}";

    //////////////////////////
    ///       SCRIPT       ///
    //////////////////////////

    IScriptHost Host;
    string SQL = string.Empty;

    public void Init(IScriptHost host)
    {
        this.Host = host;
        host.Close += OnClose;

        Host.AddEvent("Missed reaction script initialized");

        StringBuilder sql = new StringBuilder("SELECT ID, RecType, CallDirection, CallDateTime, NumberA, NumberB, CallingParty, CalledParty FROM viCalls");
        sql.Append(" WHERE ID=@callid");
        sql.Append(string.Format(" and RecType={0}", RecType));
        sql.Append(GetDirections());
        sql.Append(GetNumbers(NumbersA, "NumberA"));
        sql.Append(GetNumbers(NumbersB, "NumberB"));

        SQL = sql.ToString();
        Host.AddEvent(string.Format("Missed reaction sql builded:\n{0}", SQL));
    }

    public void Main(Object parameters)
    {
        var callParams = parameters as NewCallActionParameters;

        try
        {
            using (var cn = new SqlConnection(Host.DatabaseConnectionString))
            {
                cn.Open();
                var cmd = SoftPi.Tariscope.MSSQL.NewQuery(cn, SQL);
                cmd.Parameters.AddWithValue("@callid", callParams.Id);

                using (var rs = cmd.ExecuteReader())
                    while (rs.Read())
                    {
                        DateTime dt = rs.GetDateTime(3);
                        string a = rs.GetString(4);
                        string b = rs.GetString(5);
                        string calling = rs.GetString(6);
                        string called = rs.GetString(7);

                        if (SendEmail)
                        {
                            Host.AddEvent(string.Format("Missed call detected, ID={0}. Try to send email to {1}", callParams.Id, (string.IsNullOrWhiteSpace(Email) ? "administrator" : Email)));

                            try
                            {
                                Host.SendMail(Email, "Missed call detected!", string.Format(MessageBody, callParams.Id, a, b, dt.ToString(), calling, called));
                            }
                            catch (Exception e1)
                            {
                                Host.AddEvent(string.Format("Missed reaction email sending error: {0}", e1.Message));
                            }
                        }
                        else
                        {
                            Host.AddEvent(string.Format(MessageBody, callParams.Id, a, b, dt.ToString(), calling, called));
                        }
                    }
            }
        }
        catch (Exception e2)
        {
            Host.AddEvent(string.Format("Missed reaction error: {0}", e2.Message));
        }
    }

    void OnClose(ref bool Cancel)
    {
        return;
    }

    string GetDirections()
    {
        List<byte> dirs = new List<byte>();

        if (IncludeIncoming)
            dirs.Add(2);

        if (IncludeOutgoing)
            dirs.Add(3);

        if (IncludeInternal)
            dirs.Add(1);

        return dirs.Count > 0 ? string.Format(" AND CallDirection IN ({0})", string.Join(",", dirs)) : string.Empty;
    }

    string GetNumbers(List<string> ToCheck, string NumberType)
    {
        return ToCheck.Count > 0 ? string.Format(" AND {0} IN ({1})", NumberType, string.Join(",", from i in ToCheck select string.Format("'{0}'", i))) : string.Empty;
    }
}